/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorRegistryImpl
extends ExecutorRegistry {
    private static final Logger LOG = Logger.getInstance(ExecutorRegistryImpl.class);
    @NonNls
    public static final String RUNNERS_GROUP = "RunnerActions";
    @NonNls
    public static final String RUN_CONTEXT_GROUP = "RunContextGroup";
    private List<Executor> myExecutors = new ArrayList<Executor>();
    private ActionManager myActionManager;
    private final Map<String, Executor> myId2Executor = new HashMap();
    private final Set<String> myContextActionIdSet = new com.intellij.util.containers.HashSet();
    private final Map<String, AnAction> myId2Action = new HashMap();
    private final Map<String, AnAction> myContextActionId2Action = new HashMap();
    private final Set<Trinity<Project, String, String>> myInProgress = Collections.synchronizedSet(new HashSet());

    public ExecutorRegistryImpl(ActionManager actionManager) {
        this.myActionManager = actionManager;
    }

    synchronized void initExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ExecutorRegistryImpl", "initExecutor"));
        }
        if (this.myId2Executor.get(executor.getId()) != null) {
            LOG.error("Executor with id: \"" + executor.getId() + "\" was already registered!");
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        this.myExecutors.add(executor);
        this.myId2Executor.put(executor.getId(), executor);
        this.myContextActionIdSet.add(executor.getContextActionId());
        this.registerAction(executor.getId(), new ExecutorAction(executor), RUNNERS_GROUP, this.myId2Action);
        this.registerAction(executor.getContextActionId(), (AnAction)new RunContextAction(executor), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void registerAction(@NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId, @NotNull Map<String, AnAction> map) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/execution/ExecutorRegistryImpl", "registerAction"));
        }
        AnAction action = this.myActionManager.getAction(actionId);
        if (action == null) {
            this.myActionManager.registerAction(actionId, anAction);
            map.put(actionId, anAction);
            action = anAction;
        }
        ((DefaultActionGroup)this.myActionManager.getAction(groupId)).add(action);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ExecutorRegistryImpl", "deinitExecutor"));
        }
        this.myExecutors.remove(executor);
        this.myId2Executor.remove(executor.getId());
        this.myContextActionIdSet.remove(executor.getContextActionId());
        this.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myId2Action);
        this.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void unregisterAction(@NotNull String actionId, @NotNull String groupId, @NotNull Map<String, AnAction> map) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/execution/ExecutorRegistryImpl", "unregisterAction"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/execution/ExecutorRegistryImpl", "unregisterAction"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/execution/ExecutorRegistryImpl", "unregisterAction"));
        }
        DefaultActionGroup group = (DefaultActionGroup)this.myActionManager.getAction(groupId);
        if (group != null) {
            group.remove(this.myActionManager.getAction(actionId));
            AnAction action = map.get(actionId);
            if (action != null) {
                this.myActionManager.unregisterAction(actionId);
                map.remove(actionId);
            }
        }
    }

    @NotNull
    public synchronized Executor[] getRegisteredExecutors() {
        Executor[] executorArray = this.myExecutors.toArray(new Executor[this.myExecutors.size()]);
        if (executorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutorRegistryImpl", "getRegisteredExecutors"));
        }
        return executorArray;
    }

    public Executor getExecutorById(String executorId) {
        return this.myId2Executor.get(executorId);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ExecutorRegistyImpl" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutorRegistryImpl", "getComponentName"));
        }
        return "ExecutorRegistyImpl";
    }

    public void initComponent() {
        Executor[] executors;
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project) {
                MessageBusConnection connect = project.getMessageBus().connect((Disposable)project);
                connect.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

                    public void processStartScheduled(String executorId, ExecutionEnvironment environment) {
                        ExecutorRegistryImpl.this.myInProgress.add(ExecutorRegistryImpl.createExecutionId(executorId, environment));
                    }

                    public void processNotStarted(String executorId, @NotNull ExecutionEnvironment environment) {
                        if (environment == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ExecutorRegistryImpl$1$1", "processNotStarted"));
                        }
                        ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
                    }

                    public void processStarted(String executorId, @NotNull ExecutionEnvironment environment, @NotNull ProcessHandler handler) {
                        if (environment == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ExecutorRegistryImpl$1$1", "processStarted"));
                        }
                        if (handler == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/ExecutorRegistryImpl$1$1", "processStarted"));
                        }
                        ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(Project project) {
                Set set = ExecutorRegistryImpl.this.myInProgress;
                synchronized (set) {
                    Iterator it = ExecutorRegistryImpl.this.myInProgress.iterator();
                    while (it.hasNext()) {
                        Trinity trinity = (Trinity)it.next();
                        if (!project.equals(trinity.first)) continue;
                        it.remove();
                    }
                }
            }
        });
        for (Executor executor : executors = (Executor[])Extensions.getExtensions((ExtensionPointName)Executor.EXECUTOR_EXTENSION_NAME)) {
            this.initExecutor(executor);
        }
    }

    @NotNull
    private static Trinity<Project, String, String> createExecutionId(String executorId, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ExecutorRegistryImpl", "createExecutionId"));
        }
        Trinity trinity = Trinity.create((Object)environment.getProject(), (Object)executorId, (Object)environment.getRunner().getRunnerId());
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutorRegistryImpl", "createExecutionId"));
        }
        return trinity;
    }

    public boolean isStarting(Project project, String executorId, String runnerId) {
        return this.myInProgress.contains(Trinity.create((Object)project, (Object)executorId, (Object)runnerId));
    }

    public boolean isStarting(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/ExecutorRegistryImpl", "isStarting"));
        }
        return this.isStarting(environment.getProject(), environment.getExecutor().getId(), environment.getRunner().getRunnerId());
    }

    public synchronized void disposeComponent() {
        if (!this.myExecutors.isEmpty()) {
            for (Executor executor : new ArrayList<Executor>(this.myExecutors)) {
                this.deinitExecutor(executor);
            }
        }
        this.myExecutors = null;
        this.myActionManager = null;
    }

    private class ExecutorAction
    extends AnAction
    implements DumbAware {
        private final Executor myExecutor;

        private ExecutorAction(Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction", "<init>"));
            }
            super(executor.getStartActionText(), executor.getDescription(), executor.getIcon());
            this.myExecutor = executor;
        }

        public void update(AnActionEvent e) {
            String text;
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed() || DumbService.getInstance((Project)project).isDumb()) {
                presentation.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedConfiguration = this.getSelectedConfiguration(project);
            boolean enabled = false;
            String textWithMnemonic = this.getTemplatePresentation().getTextWithMnemonic();
            if (selectedConfiguration != null) {
                presentation.setIcon(this.getInformativeIcon(project, selectedConfiguration));
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)selectedConfiguration.getConfiguration());
                ExecutionTarget target = ExecutionTargetManager.getActiveTarget((Project)project);
                boolean bl = enabled = ExecutionTargetManager.canRun((RunnerAndConfigurationSettings)selectedConfiguration, (ExecutionTarget)target) && runner != null && !ExecutorRegistryImpl.this.isStarting(project, this.myExecutor.getId(), runner.getRunnerId());
                if (enabled) {
                    presentation.setDescription(this.myExecutor.getDescription());
                }
                text = this.myExecutor.getStartActionText(selectedConfiguration.getName());
            } else {
                text = textWithMnemonic;
            }
            presentation.setEnabled(enabled);
            presentation.setText(text);
        }

        private Icon getInformativeIcon(Project project, final RunnerAndConfigurationSettings selectedConfiguration) {
            final ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            List runningDescriptors = executionManager.getRunningDescriptors(new Condition<RunnerAndConfigurationSettings>(){

                public boolean value(RunnerAndConfigurationSettings s) {
                    return s == selectedConfiguration;
                }
            });
            if (!(runningDescriptors = ContainerUtil.filter(runningDescriptors, (Condition)new Condition<RunContentDescriptor>(){

                public boolean value(RunContentDescriptor descriptor) {
                    RunContentDescriptor contentDescriptor = executionManager.getContentManager().findContentDescriptor(ExecutorAction.this.myExecutor, descriptor.getProcessHandler());
                    return contentDescriptor != null && executionManager.getExecutors(contentDescriptor).contains(ExecutorAction.this.myExecutor);
                }
            })).isEmpty() && DefaultRunExecutor.EXECUTOR_ID.equals(this.myExecutor.getId()) && selectedConfiguration.isSingleton()) {
                return AllIcons.Actions.Restart;
            }
            if (runningDescriptors.isEmpty()) {
                return this.myExecutor.getIcon();
            }
            if (runningDescriptors.size() == 1) {
                return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
            }
            return IconUtil.addText((Icon)this.myExecutor.getIcon(), (String)String.valueOf(runningDescriptors.size()));
        }

        @Nullable
        private RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction", "getSelectedConfiguration"));
            }
            return RunManagerEx.getInstanceEx(project).getSelectedConfiguration();
        }

        public void actionPerformed(AnActionEvent e) {
            ExecutionEnvironmentBuilder builder;
            Project project = e.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            RunnerAndConfigurationSettings configuration = this.getSelectedConfiguration(project);
            ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder = configuration == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)this.myExecutor, (RunnerAndConfigurationSettings)configuration);
            if (builder == null) {
                return;
            }
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.activeTarget().dataContext(e.getDataContext()).build());
        }
    }
}

