/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralIdBasedToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GeneralIdBasedToSMTRunnerEventsConvertor.class.getName());
    private final TIntObjectHashMap<Node> myNodeByIdMap;
    private final Set<Node> myRunningTestNodes;
    private final SMTestProxy.SMRootTestProxy myTestsRootProxy;
    private final Node myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator;
    private TestProxyPrinterProvider myTestProxyPrinterProvider;

    public GeneralIdBasedToSMTRunnerEventsConvertor(Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        if (testsRootProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRootProxy", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "<init>"));
        }
        super(project);
        this.myNodeByIdMap = new TIntObjectHashMap();
        this.myRunningTestNodes = ContainerUtil.newHashSet();
        this.myIsTestingFinished = false;
        this.myLocator = null;
        this.myTestProxyPrinterProvider = null;
        this.myTestsRootProxy = testsRootProxy;
        this.myTestsRootNode = new Node(0, null, testsRootProxy);
        this.myTestFrameworkName = testFrameworkName;
        this.myNodeByIdMap.put(this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void setLocator(@NotNull SMTestLocator locator) {
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "setLocator"));
        }
        this.myLocator = locator;
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootNode.setState(State.RUNNING, GeneralIdBasedToSMTRunnerEventsConvertor.this);
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setStarted();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestingStarted(GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralTestEventsProcessor.fireOnTestsReporterAttached(GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GeneralIdBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                boolean completeTree = GeneralTestEventsProcessor.isTreeComplete(GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes, GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
                if (completeTree) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setFinished();
                } else {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setTerminated();
                }
                if (!GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty()) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Unexpected running nodes: " + GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes);
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestingFinished(GeneralIdBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy);
            }
        });
        this.stopEventProcessing();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printerProvider", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "setPrinterProvider"));
        }
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(final @NotNull TestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestStarted"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.doStartNode(testStartedEvent, false);
            }
        });
    }

    @Override
    public void onSuiteStarted(final @NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onSuiteStarted"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.doStartNode(suiteStartedEvent, true);
            }
        });
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        if (startedNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "doStartNode"));
        }
        Node node = this.findNode(startedNodeEvent);
        if (node != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return;
        }
        if (!this.validateNodeId(startedNodeEvent)) {
            return;
        }
        String nodeName = startedNodeEvent.getName();
        SMTestProxy childProxy = new SMTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), true);
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        node = new Node(startedNodeEvent.getId(), parentNode, childProxy);
        this.myNodeByIdMap.put(startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        if (startedNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findValidParentNode"));
        }
        int parentId = startedNodeEvent.getParentId();
        if (parentId < 0) {
            this.logProblem("Parent node id should be non-negative: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get(startedNodeEvent.getParentId());
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(final @NotNull TestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestFinished"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(testFinishedEvent);
                if (node != null) {
                    SMTestProxy testProxy = node.getProxy();
                    testProxy.setDuration(testFinishedEvent.getDuration());
                    testProxy.setFinished();
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Override
    public void onSuiteFinished(final @NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onSuiteFinished"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(suiteFinishedEvent);
                if (node != null) {
                    SMTestProxy suiteProxy = node.getProxy();
                    suiteProxy.setFinished();
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnSuiteFinished(suiteProxy);
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findNodeToTerminate"));
        }
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish not existent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onUncapturedOutput"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GeneralIdBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                SMTestProxy activeProxy = activeNode.getProxy();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    activeProxy.addStdErr(text);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    activeProxy.addSystemOutput(text);
                } else {
                    activeProxy.addStdOutput(text, outputType);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isCritical) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onError"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GeneralIdBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                SMTestProxy activeProxy = activeNode.getProxy();
                activeProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull TestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailedEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestFailure"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(testFailedEvent);
                if (node == null) {
                    return;
                }
                SMTestProxy testProxy = node.getProxy();
                String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                String failureMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                    testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText, testFailedEvent.getFilePath());
                } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                    testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
                } else {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\n" + "Actual:\n" + comparisonFailureActualText);
                }
                long duration = testFailedEvent.getDurationMillis();
                if (duration >= 0L) {
                    testProxy.setDuration(duration);
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
                GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FAILED);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull TestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnoredEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestIgnored"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate(testIgnoredEvent);
                if (node != null) {
                    SMTestProxy testProxy = node.getProxy();
                    testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.IGNORED);
                }
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull TestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testOutputEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "onTestOutput"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GeneralIdBasedToSMTRunnerEventsConvertor.this.findNode(testOutputEvent);
                if (node == null) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! But " + testOutputEvent + "!");
                    return;
                }
                SMTestProxy testProxy = node.getProxy();
                if (testOutputEvent.isStdOut()) {
                    testProxy.addStdOutput(testOutputEvent.getText(), ProcessOutputTypes.STDOUT);
                } else {
                    testProxy.addStdErr(testOutputEvent.getText());
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralIdBasedToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    private boolean validateNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "validateNodeId"));
        }
        int nodeId = treeNodeEvent.getId();
        if (nodeId <= 0) {
            this.logProblem("Node id should be positive: " + treeNodeEvent + ".", true);
            return false;
        }
        return true;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findNode"));
        }
        if (!this.validateNodeId(treeNodeEvent)) {
            return null;
        }
        return (Node)this.myNodeByIdMap.get(treeNodeEvent.getId());
    }

    @Nullable
    public SMTestProxy findProxyById(int id) {
        Node node = (Node)this.myNodeByIdMap.get(id);
        return node != null ? node.getProxy() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GeneralIdBasedToSMTRunnerEventsConvertor.this.disconnectListeners();
                if (!(GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GeneralIdBasedToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed!");
                }
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GeneralIdBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
            }
        });
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        if (lowestNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowestNode", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "setNodeAndAncestorsRunning"));
        }
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING, this);
            SMTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "terminateNode"));
        }
        if (terminateState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminateState", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "terminateNode"));
        }
        node.setState(terminateState, this);
        this.myRunningTestNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        if (this.myRunningTestNodes.isEmpty()) {
            Node node = this.myTestsRootNode;
            if (node == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findActiveNode"));
            }
            return node;
        }
        Node node = this.myRunningTestNodes.iterator().next();
        if (node == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "findActiveNode"));
        }
        return node;
    }

    private void logProblem(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "logProblem"));
        }
        this.logProblem(msg, SMTestRunnerConnectionUtil.isInDebugMode());
    }

    private void logProblem(@NotNull String msg, boolean throwError) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor", "logProblem"));
        }
        String text = "[" + this.myTestFrameworkName + "] " + msg;
        if (throwError) {
            LOG.error(text);
        } else {
            LOG.warn(text);
        }
    }

    private static class Node {
        private final int myId;
        private final Node myParentNode;
        private final SMTestProxy myProxy;
        private State myState;

        Node(int id, @Nullable Node parentNode, @NotNull SMTestProxy proxy) {
            if (proxy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "<init>"));
            }
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        public int getId() {
            return this.myId;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public SMTestProxy getProxy() {
            SMTestProxy sMTestProxy = this.myProxy;
            if (sMTestProxy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "getProxy"));
            }
            return sMTestProxy;
        }

        @NotNull
        public State getState() {
            State state = this.myState;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "getState"));
            }
            return state;
        }

        public void setState(@NotNull State newState, @NotNull GeneralIdBasedToSMTRunnerEventsConvertor convertor) {
            if (newState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "setState"));
            }
            if (convertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/execution/testframework/sm/runner/GeneralIdBasedToSMTRunnerEventsConvertor$Node", "setState"));
            }
            boolean accepted = false;
            if (this.myState == State.NOT_RUNNING || this.myState == State.RUNNING) {
                boolean bl = accepted = this.myState.ordinal() < newState.ordinal();
            }
            if (accepted) {
                this.myState = newState;
            } else {
                convertor.logProblem("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString(), false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId;
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

