/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.SMStacktraceParserEx;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.SuiteInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestComparisionFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestProxy
extends AbstractTestProxy {
    private static final Logger LOG = Logger.getInstance((String)SMTestProxy.class.getName());
    private final String myName;
    private final boolean myIsSuite;
    private final String myLocationUrl;
    private final boolean myPreservePresentableName;
    private List<SMTestProxy> myChildren;
    private SMTestProxy myParent;
    private AbstractState myState = NotRunState.getInstance();
    private Long myDuration = null;
    private boolean myDurationIsCached = false;
    private boolean myHasCriticalErrors = false;
    private boolean myHasErrorsCached = false;
    private boolean myHasPassedTests = false;
    private boolean myHasPassedTestsCached = false;
    private String myStacktrace;
    private boolean myIsEmptyIsCached = false;
    private boolean myIsEmpty = true;
    private SMTestLocator myLocator = null;
    private Printer myPreferredPrinter = null;
    private String myPresentableName;
    private boolean myConfig = false;

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this(testName, isSuite, locationUrl, false);
    }

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, boolean preservePresentableName) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
        this.myPreservePresentableName = preservePresentableName;
    }

    public void setLocator(@NotNull SMTestLocator testLocator) {
        if (testLocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testLocator", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setLocator"));
        }
        this.myLocator = testLocator;
    }

    public void setConfig(boolean config) {
        this.myConfig = config;
    }

    public void setLocator(final @NotNull TestLocationProvider locator) {
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setLocator"));
        }
        class Adapter
        implements SMTestLocator,
        PossiblyDumbAware {
            Adapter() {
            }

            @Override
            @NotNull
            public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
                if (protocol == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/runner/SMTestProxy$1Adapter", "getLocation"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/runner/SMTestProxy$1Adapter", "getLocation"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTestProxy$1Adapter", "getLocation"));
                }
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/runner/SMTestProxy$1Adapter", "getLocation"));
                }
                List<Location> list = locator.getLocation(protocol, path, project);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTestProxy$1Adapter", "getLocation"));
                }
                return list;
            }

            public boolean isDumbAware() {
                return DumbService.isDumbAware((Object)locator);
            }
        }
        this.myLocator = new Adapter();
    }

    public void setPreferredPrinter(@NotNull Printer preferredPrinter) {
        if (preferredPrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredPrinter", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setPreferredPrinter"));
        }
        this.myPreferredPrinter = preferredPrinter;
    }

    @Override
    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    @Override
    public boolean isDefect() {
        return this.myState.isDefect();
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        if (this.myHasErrorsCached) {
            return this.myHasCriticalErrors;
        }
        boolean canCacheErrors = !this.myState.isInProgress();
        boolean hasErrors = this.calcHasErrors();
        if (canCacheErrors || hasErrors) {
            this.myHasCriticalErrors = hasErrors;
            this.myHasErrorsCached = true;
        }
        return hasErrors;
    }

    private boolean calcHasErrors() {
        if (this.myHasCriticalErrors) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal() {
        return this.myState.isFinal();
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    @Override
    public boolean hasPassedTests() {
        boolean canCache;
        if (this.myHasPassedTestsCached) {
            return this.myHasPassedTests;
        }
        boolean hasPassedTests = this.calcPassedTests();
        boolean bl = canCache = !this.myState.isInProgress();
        if (canCache) {
            this.myHasPassedTests = hasPassedTests;
            this.myHasPassedTestsCached = true;
        }
        return hasPassedTests;
    }

    @Override
    public boolean isInterrupted() {
        return this.myState.wasTerminated();
    }

    private boolean calcPassedTests() {
        if (this.isPassed()) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasPassedTests()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    @Override
    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(@NotNull SMTestProxy child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "addChild"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myChildren == null) {
            this.myChildren = ContainerUtil.newArrayListWithCapacity((int)4);
        }
        this.myChildren.add(child);
        this.addLast(child);
        child.setParent(this);
        child.setPrinter(this.myPrinter);
        if (this.myPreferredPrinter != null && child.myPreferredPrinter == null) {
            child.setPreferredPrinter(this.myPreferredPrinter);
        }
    }

    @Nullable
    private Printer getRightPrinter(@Nullable Printer printer) {
        if (this.myPreferredPrinter != null && printer != null) {
            return this.myPreferredPrinter;
        }
        return printer;
    }

    @Override
    public void setPrinter(Printer printer) {
        super.setPrinter(this.getRightPrinter(printer));
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isConfig() {
        return this.myConfig;
    }

    @Override
    @Nullable
    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getLocation"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getLocation"));
        }
        String locationUrl = this.myLocationUrl;
        return this.getLocation(project, searchScope, locationUrl);
    }

    protected Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope, String locationUrl) {
        String protocolId;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getLocation"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getLocation"));
        }
        if (locationUrl != null && this.myLocator != null && (protocolId = VirtualFileManager.extractProtocol((String)locationUrl)) != null) {
            List<Location> locations;
            String path = VirtualFileManager.extractPath((String)locationUrl);
            if (!(DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)this.myLocator) || (locations = this.myLocator.getLocation(protocolId, path, project, searchScope)).isEmpty())) {
                return locations.get(0);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Navigatable getDescriptor(@Nullable Location location, @NotNull TestConsoleProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getDescriptor"));
        }
        if (location == null) {
            return null;
        }
        String stacktrace = this.myStacktrace;
        if (stacktrace != null && properties instanceof SMStacktraceParser && this.isLeaf()) {
            Navigatable result;
            Navigatable navigatable = result = properties instanceof SMStacktraceParserEx ? ((SMStacktraceParserEx)((Object)properties)).getErrorNavigatable(location, stacktrace) : ((SMStacktraceParser)((Object)properties)).getErrorNavigatable(location.getProject(), stacktrace);
            if (result != null) {
                return result;
            }
        }
        return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    @Override
    public SMTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends SMTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<SMTestProxy> getAllTests() {
        ArrayList<SMTestProxy> allTests = new ArrayList<SMTestProxy>();
        allTests.add(this);
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            allTests.addAll(sMTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new SuiteInProgressState(this);
    }

    @Override
    @Nullable
    public Long getDuration() {
        if (this.myDurationIsCached || !this.isSuite()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    @Override
    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        switch (this.getMagnitudeInfo()) {
            case PASSED_INDEX: 
            case RUNNING_INDEX: {
                return !this.isSubjectToHide(consoleProperties) ? this.getDurationString() : null;
            }
            case COMPLETE_INDEX: 
            case FAILED_INDEX: 
            case ERROR_INDEX: 
            case IGNORED_INDEX: 
            case SKIPPED_INDEX: 
            case TERMINATED_INDEX: {
                return this.getDurationString();
            }
        }
        return null;
    }

    private boolean isSubjectToHide(TestConsoleProperties consoleProperties) {
        return TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)consoleProperties) && this.getParent() != null && !this.isDefect();
    }

    private String getDurationString() {
        Long duration = this.getDuration();
        return duration != null ? StringUtil.formatDuration((long)duration) : null;
    }

    @Override
    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    public void setDuration(long duration) {
        this.invalidateCachedDurationForContainerSuites();
        if (!this.isSuite()) {
            this.myDurationIsCached = true;
            this.myDuration = duration >= 0L ? Long.valueOf(duration) : null;
            return;
        }
        LOG.warn("Unsupported operation");
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestFailed"));
        }
        this.setStacktraceIfNotSet(stackTrace);
        if (this.myState instanceof TestFailedState) {
            ((TestFailedState)this.myState).addError(localizedMessage, stackTrace, this.myPrinter);
        } else {
            this.myState = testError ? new TestErrorState(localizedMessage, stackTrace) : new TestFailedState(localizedMessage, stackTrace);
            this.fireOnNewPrintable(this.myState);
        }
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualText", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        if (expectedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedText", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        this.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText, null);
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @Nullable String filePath) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualText", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        if (expectedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedText", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "setTestComparisonFailed"));
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestComparisionFailedState(localizedMessage, stackTrace, actualText, expectedText, filePath);
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestIgnoredState(ignoreComment, stackTrace);
        this.fireOnNewPrintable(this.myState);
    }

    public void setParent(@Nullable SMTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends SMTestProxy> collectChildren(@Nullable Filter<SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.collectChildren());
    }

    public List<? extends SMTestProxy> collectChildren() {
        List<? extends SMTestProxy> allChildren = this.getChildren();
        ArrayList result = ContainerUtilRt.newArrayList();
        result.addAll(allChildren);
        for (SMTestProxy sMTestProxy : allChildren) {
            result.addAll(sMTestProxy.collectChildren());
        }
        return result;
    }

    public List<? extends SMTestProxy> getChildren(@Nullable Filter<? super SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.getChildren());
    }

    private static List<? extends SMTestProxy> filterChildren(@Nullable Filter<? super SMTestProxy> filter, List<? extends SMTestProxy> allChildren) {
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<SMTestProxy> selectedChildren = new ArrayList<SMTestProxy>();
        for (SMTestProxy sMTestProxy : allChildren) {
            if (!filter.shouldAccept(sMTestProxy)) continue;
            selectedChildren.add(sMTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    @Override
    public void printOn(Printer printer) {
        final Printer rightPrinter = this.getRightPrinter(printer);
        super.printOn(rightPrinter);
        final AbstractState oldState = this.myState;
        SMTestProxy.invokeInAlarm(new Runnable(){

            @Override
            public void run() {
                oldState.printOn(rightPrinter);
            }
        });
    }

    public void addStdOutput(final String output, final Key outputType) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        });
    }

    public void addStdErr(final String output) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.ERROR_OUTPUT);
            }
        });
    }

    @Deprecated
    public void addError(String output, @Nullable String stackTrace) {
        this.addError(output, stackTrace, true);
    }

    public void addError(final String output, final @Nullable String stackTrace, boolean isCritical) {
        this.myHasCriticalErrors = isCritical;
        this.setStacktraceIfNotSet(stackTrace);
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                String errorText = TestFailedState.buildErrorPresentationText(output, stackTrace);
                LOG.assertTrue(errorText != null);
                TestFailedState.printError(printer, Collections.singletonList(errorText));
            }
        });
    }

    public void addSystemOutput(final String output) {
        this.addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    @NotNull
    public String getPresentableName() {
        if (this.myPresentableName == null) {
            this.myPresentableName = this.myPreservePresentableName ? TestsPresentationUtil.getPresentableNameTrimmedOnly(this) : TestsPresentationUtil.getPresentableName(this);
        }
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTestProxy", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        if (this.myState instanceof TestComparisionFailedState) {
            return ((TestComparisionFailedState)this.myState).getHyperlink();
        }
        if (this.myChildren != null) {
            for (SMTestProxy child : this.myChildren) {
                DiffHyperlink provider;
                if (!child.isDefect() || (provider = child.getDiffViewerProvider()) == null) continue;
                return provider;
            }
        }
        return null;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public void setTerminated() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = TerminatedState.INSTANCE;
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            sMTestProxy.setTerminated();
        }
        this.fireOnNewPrintable(this.myState);
    }

    public boolean wasTerminated() {
        return this.myState.wasTerminated();
    }

    @Override
    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    private boolean containsErrorTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    protected AbstractState determineSuiteStateOnFinished() {
        SuiteFinishedState state = this.isLeaf() ? SuiteFinishedState.EMPTY_LEAF_SUITE : (this.isEmptySuite() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE)) : SuiteFinishedState.PASSED_SUITE));
        return state;
    }

    public boolean isEmptySuite() {
        if (this.myIsEmptyIsCached) {
            return this.myIsEmpty;
        }
        if (!this.isSuite()) {
            this.myIsEmpty = true;
            this.myIsEmptyIsCached = true;
            return true;
        }
        this.myIsEmpty = true;
        List<? extends SMTestProxy> allTestCases = this.getChildren();
        for (SMTestProxy sMTestProxy : allTestCases) {
            if (sMTestProxy.isSuite()) {
                if (!sMTestProxy.isEmptySuite()) {
                    this.myIsEmpty = false;
                    this.myIsEmptyIsCached = true;
                    break;
                }
                this.myIsEmpty = true;
                this.myIsEmptyIsCached = this.myState.isFinal();
                continue;
            }
            this.myIsEmpty = false;
            this.myIsEmptyIsCached = true;
            break;
        }
        return this.myIsEmpty;
    }

    @Nullable
    private Long calcSuiteDuration() {
        long partialDuration = 0L;
        boolean durationOfChildrenIsUnknown = true;
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            Long duration = sMTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.longValue();
        }
        return durationOfChildrenIsUnknown ? null : Long.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites() {
        this.myDuration = null;
        this.myDurationIsCached = false;
        SMTestProxy containerSuite = this.getParent();
        if (containerSuite != null) {
            containerSuite.invalidateCachedDurationForContainerSuites();
        }
    }

    public SMRootTestProxy getRoot() {
        SMTestProxy parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof SMRootTestProxy); parent = parent.getParent()) {
        }
        return parent instanceof SMRootTestProxy ? (SMRootTestProxy)parent : null;
    }

    public static class SMRootTestProxy
    extends SMTestProxy
    implements TestProxyRoot {
        private boolean myTestsReporterAttached;
        private String myPresentation;
        private String myComment;
        private String myRootLocationUrl;
        private ProcessHandler myHandler;

        public SMRootTestProxy() {
            super("[root]", true, null);
        }

        public void setTestsReporterAttached() {
            this.myTestsReporterAttached = true;
        }

        public boolean isTestsReporterAttached() {
            return this.myTestsReporterAttached;
        }

        @Override
        public String getPresentation() {
            return this.myPresentation;
        }

        public void setPresentation(String presentation) {
            this.myPresentation = presentation;
        }

        public void setComment(String comment) {
            this.myComment = comment;
        }

        @Override
        public String getComment() {
            return this.myComment;
        }

        public void setRootLocationUrl(String locationUrl) {
            this.myRootLocationUrl = locationUrl;
        }

        @Override
        public String getRootLocation() {
            return this.myRootLocationUrl;
        }

        public ProcessHandler getHandler() {
            return this.myHandler;
        }

        @Override
        public void setHandler(ProcessHandler handler) {
            this.myHandler = handler;
        }

        @Override
        @Nullable
        public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy", "getLocation"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy", "getLocation"));
            }
            return this.myRootLocationUrl != null ? super.getLocation(project, searchScope, this.myRootLocationUrl) : super.getLocation(project, searchScope);
        }

        @Override
        protected AbstractState determineSuiteStateOnFinished() {
            if (this.isLeaf() && !this.isTestsReporterAttached()) {
                return SuiteFinishedState.TESTS_REPORTER_NOT_ATTACHED;
            }
            return super.determineSuiteStateOnFinished();
        }
    }
}

