/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestComparisionFailedState
extends TestFailedState {
    private final String myErrorMsgPresentation;
    private final String myStacktracePresentation;
    private DiffHyperlink myHyperlink;

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualText", "com/intellij/execution/testframework/sm/runner/states/TestComparisionFailedState", "<init>"));
        }
        if (expectedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedText", "com/intellij/execution/testframework/sm/runner/states/TestComparisionFailedState", "<init>"));
        }
        this(localizedMessage, stackTrace, actualText, expectedText, null);
    }

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @Nullable String filePath) {
        if (actualText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualText", "com/intellij/execution/testframework/sm/runner/states/TestComparisionFailedState", "<init>"));
        }
        if (expectedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedText", "com/intellij/execution/testframework/sm/runner/states/TestComparisionFailedState", "<init>"));
        }
        super(localizedMessage, stackTrace);
        this.myHyperlink = new DiffHyperlink(expectedText, actualText, filePath);
        this.myErrorMsgPresentation = StringUtil.isEmptyOrSpaces((String)localizedMessage) ? "" : localizedMessage;
        this.myStacktracePresentation = StringUtil.isEmptyOrSpaces((String)stackTrace) ? "" : stackTrace;
    }

    @Override
    public void printOn(Printer printer) {
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.mark();
        TestsPresentationUtil.printWithAnsiColoring(printer, this.myErrorMsgPresentation, ProcessOutputTypes.STDERR);
        this.myHyperlink.printOn(printer);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        TestsPresentationUtil.printWithAnsiColoring(printer, this.myStacktracePresentation, ProcessOutputTypes.STDERR);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    @Nullable
    public DiffHyperlink getHyperlink() {
        return this.myHyperlink;
    }
}

