/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchWrapper;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.CloseOnESCAction;
import com.intellij.find.editorHeaderActions.FindAllAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.ReplaceOnEnterAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.ShowHistoryAction;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAndLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleInCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleInLiteralsOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchComponent
extends EditorHeaderComponent
implements DataProvider,
SelectionListener,
SearchResults.SearchResultsListener {
    private final Project myProject;
    private JPanel myLeftPanel;
    private JTextComponent mySearchTextComponent;
    private Wrapper mySearchFieldWrapper;
    private JTextComponent myReplaceTextComponent;
    private Wrapper myReplaceFieldWrapper;
    private JPanel myRightPanel;
    private ActionToolbarImpl mySearchActionsToolbar1;
    private ActionToolbarImpl mySearchActionsToolbar2;
    private JLabel myMatchInfoLabel;
    private LinkLabel<Object> myClickToHighlightLabel;
    private ActionToolbarImpl myReplaceActionsToolbar1;
    private ActionToolbarImpl myReplaceActionsToolbar2;
    private JPanel myReplaceToolbarWrapper;
    @NotNull
    private final Editor myEditor;
    private final Color myDefaultBackground;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    private final FindModel myFindModel;

    public JTextComponent getSearchTextComponent() {
        return this.mySearchTextComponent;
    }

    public JTextComponent getReplaceTextComponent() {
        return this.myReplaceTextComponent;
    }

    public EditorSearchComponent(@NotNull Editor editor, Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchComponent", "<init>"));
        }
        this(editor, project, EditorSearchComponent.createDefaultFindModel(project, editor));
    }

    public EditorSearchComponent(@NotNull Editor editor, Project project, FindModel findModel) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/EditorSearchComponent", "<init>"));
        }
        this.myFindModel = findModel;
        this.myProject = project;
        this.myEditor = editor;
        this.mySearchResults = new SearchResults(this.myEditor, this.myProject);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this);
        this.myDefaultBackground = new JTextField().getBackground();
        this.initUI();
        new SwitchToFind(this);
        new SwitchToReplace(this);
        this.myFindModel.addObserver(new FindModel.FindModelObserver(){

            public void findModelChanged(FindModel findModel) {
                String stringToFind = EditorSearchComponent.this.myFindModel.getStringToFind();
                if (!EditorSearchComponent.wholeWordsApplicable(stringToFind)) {
                    EditorSearchComponent.this.myFindModel.setWholeWordsOnly(false);
                }
                EditorSearchComponent.this.updateUIWithFindModel();
                EditorSearchComponent.this.updateResults(true);
                EditorSearchComponent.syncFindModels(FindManager.getInstance((Project)EditorSearchComponent.this.myProject).getFindInFileModel(), EditorSearchComponent.this.myFindModel);
            }
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
        this.updateMultiLineStateIfNeed();
    }

    private static FindModel createDefaultFindModel(Project project, Editor editor) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)project).getFindInFileModel());
        if (editor.getSelectionModel().hasSelection() && (selectedText = editor.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        return findModel;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchTextComponent.getText();
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(SearchResults sr) {
        if (this.mySearchTextComponent.getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            int count = sr.getMatchesCount();
            boolean notTooMuch = count <= this.mySearchResults.getMatchesLimit();
            this.myMatchInfoLabel.setText(notTooMuch ? ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{count}) : ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])new Object[]{this.mySearchResults.getMatchesLimit()}));
            this.myClickToHighlightLabel.setVisible(!notTooMuch);
            if (notTooMuch) {
                if (count > 0) {
                    this.setRegularBackground();
                } else {
                    this.setNotFoundBackground();
                }
            } else {
                this.setRegularBackground();
            }
        }
        this.myReplaceActionsToolbar1.updateActionsImmediately();
    }

    @Override
    public void cursorMoved() {
        this.myReplaceActionsToolbar1.updateActionsImmediately();
    }

    @Override
    public void updateFinished() {
    }

    private void initUI() {
        this.myLeftPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.mySearchFieldWrapper = new Wrapper();
        this.myLeftPanel.add((Component)this.mySearchFieldWrapper, "North");
        this.myReplaceFieldWrapper = new Wrapper();
        this.myLeftPanel.add((Component)this.myReplaceFieldWrapper, "Center");
        this.updateSearchComponent();
        this.updateReplaceComponent();
        this.initSearchToolbars();
        this.initReplaceToolBars();
        NonOpaquePanel searchToolbarWrapper1 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        searchToolbarWrapper1.add((Component)this.mySearchActionsToolbar1, (Object)"West");
        Wrapper searchToolbarWrapper2 = new Wrapper((JComponent)this.mySearchActionsToolbar2);
        this.mySearchActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        Wrapper searchPair = new NonOpaquePanel((LayoutManager)new BorderLayout()).setVerticalSizeReferent((JComponent)this.mySearchFieldWrapper);
        searchPair.add((Component)searchToolbarWrapper1, "West");
        searchPair.add((Component)searchToolbarWrapper2, "Center");
        JLabel closeLabel = new JLabel(null, AllIcons.Actions.Cross, 4);
        closeLabel.setBorder(JBUI.Borders.empty((int)5));
        closeLabel.setVerticalAlignment(1);
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditorSearchComponent.this.close();
            }
        });
        closeLabel.setToolTipText("Close search bar (Escape)");
        searchPair.add((Component)new Wrapper.North((JComponent)closeLabel), "East");
        Wrapper replaceToolbarWrapper1 = new Wrapper((JComponent)this.myReplaceActionsToolbar1).setVerticalSizeReferent((JComponent)this.myReplaceFieldWrapper);
        Wrapper replaceToolbarWrapper2 = new Wrapper((JComponent)this.myReplaceActionsToolbar2).setVerticalSizeReferent((JComponent)this.myReplaceFieldWrapper);
        this.myReplaceActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.myReplaceToolbarWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper1, "West");
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper2, "Center");
        searchToolbarWrapper1.setHorizontalSizeReferent((JComponent)replaceToolbarWrapper1);
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myRightPanel.add((Component)searchPair, "North");
        this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.25f);
        splitter.setFirstComponent((JComponent)this.myLeftPanel);
        splitter.setSecondComponent((JComponent)this.myRightPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setAndLoadSplitterProportionKey("FindSplitterProportion");
        splitter.setOpaque(false);
        splitter.getDivider().setOpaque(false);
        this.add((Component)splitter, "Center");
    }

    private void updateSearchComponent() {
        final int oldCaretPosition = this.mySearchTextComponent != null ? this.mySearchTextComponent.getCaretPosition() : 0;
        boolean wasNull = this.mySearchTextComponent == null;
        String textToSet = this.myFindModel.getStringToFind();
        if (!this.updateTextComponent(true)) {
            this.mySearchTextComponent.setText(textToSet);
            return;
        }
        this.mySearchTextComponent.setText(textToSet);
        if (wasNull) {
            this.mySearchTextComponent.selectAll();
        }
        this.mySearchTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorSearchComponent.this.searchFieldDocumentChanged();
                    }
                });
            }
        });
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty((String)EditorSearchComponent.this.mySearchTextComponent.getText())) {
                    EditorSearchComponent.this.close();
                } else {
                    EditorSearchComponent.this.requestFocus(EditorSearchComponent.this.myEditor.getContentComponent());
                    EditorSearchComponent.this.addTextToRecent(EditorSearchComponent.this.mySearchTextComponent);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        if (!wasNull) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorSearchComponent.this.mySearchTextComponent.setCaretPosition(oldCaretPosition);
                }
            });
        }
        new RestorePreviousSettingsAction(this, (JComponent)this.mySearchFieldWrapper);
        new VariantsCompletionAction(this.mySearchTextComponent);
    }

    private void searchFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        String text = this.mySearchTextComponent.getText();
        this.myFindModel.setStringToFind(text);
        if (!StringUtil.isEmpty((String)text)) {
            this.updateResults(true);
        } else {
            this.nothingToSearchFor();
        }
        if (this.mySearchTextComponent instanceof JTextArea) {
            EditorSearchComponent.adjustRows((JTextArea)this.mySearchTextComponent);
        }
        this.updateMultiLineStateIfNeed();
    }

    private void updateMultiLineStateIfNeed() {
        this.myFindModel.setMultiline(this.mySearchTextComponent.getText().contains("\n") || this.myReplaceTextComponent.getText().contains("\n"));
    }

    private void updateReplaceComponent() {
        int oldCaretPosition;
        int n = oldCaretPosition = this.myReplaceTextComponent != null ? this.myReplaceTextComponent.getCaretPosition() : 0;
        if (!this.updateTextComponent(false)) {
            return;
        }
        this.myReplaceTextComponent.setText(this.myFindModel.getStringToReplace());
        this.myReplaceTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorSearchComponent.this.replaceFieldDocumentChanged();
                    }
                });
            }
        });
        if (!this.getFindModel().isMultiline()) {
            new ReplaceOnEnterAction(this, this.myReplaceTextComponent);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorSearchComponent.this.myReplaceTextComponent.setCaretPosition(oldCaretPosition);
            }
        });
        new VariantsCompletionAction(this.myReplaceTextComponent);
        new NextOccurrenceAction(this, (JComponent)this.myReplaceFieldWrapper, false);
        new PrevOccurrenceAction(this, (JComponent)this.myReplaceFieldWrapper);
        this.myReplaceFieldWrapper.revalidate();
        this.myReplaceFieldWrapper.repaint();
    }

    private void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myReplaceTextComponent.getText());
        if (this.myReplaceTextComponent instanceof JTextArea) {
            EditorSearchComponent.adjustRows((JTextArea)this.myReplaceTextComponent);
        }
        this.updateMultiLineStateIfNeed();
    }

    private void initSearchToolbars() {
        DefaultActionGroup actionGroup1 = new DefaultActionGroup("search bar 1", false);
        this.mySearchActionsToolbar1 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)actionGroup1, true);
        this.mySearchActionsToolbar1.setForceMinimumSize(true);
        this.mySearchActionsToolbar1.setReservePlaceAutoPopupIcon(false);
        this.mySearchActionsToolbar1.setSecondaryButtonPopupStateModifier(new ActionToolbarImpl.PopupStateModifier(){

            @Override
            public int getModifiedPopupState() {
                return -1;
            }

            @Override
            public boolean willModify() {
                return EditorSearchComponent.this.myFindModel.getSearchContext() != FindModel.SearchContext.ANY;
            }
        });
        this.mySearchActionsToolbar1.setSecondaryActionsTooltip("More Options(" + ShowMoreOptions.SHORT_CUT + ")");
        actionGroup1.add((AnAction)new PrevOccurrenceAction(this, (JComponent)this.mySearchFieldWrapper));
        actionGroup1.add((AnAction)new NextOccurrenceAction(this, (JComponent)this.mySearchFieldWrapper, true));
        actionGroup1.add((AnAction)new FindAllAction(this));
        actionGroup1.addSeparator();
        actionGroup1.add((AnAction)new AddOccurrenceAction(this));
        actionGroup1.add((AnAction)new RemoveOccurrenceAction(this));
        actionGroup1.add((AnAction)new SelectAllAction(this));
        actionGroup1.addSeparator();
        actionGroup1.addAction((AnAction)new ToggleInCommentsAction(this)).setAsSecondary(true);
        actionGroup1.addAction((AnAction)new ToggleInLiteralsOnlyAction(this)).setAsSecondary(true);
        actionGroup1.addAction((AnAction)new ToggleExceptCommentsAction(this)).setAsSecondary(true);
        actionGroup1.addAction((AnAction)new ToggleExceptLiteralsAction(this)).setAsSecondary(true);
        actionGroup1.addAction((AnAction)new ToggleExceptCommentsAndLiteralsAction(this)).setAsSecondary(true);
        DefaultActionGroup actionGroup2 = new DefaultActionGroup("search bar 2", false);
        this.mySearchActionsToolbar2 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)actionGroup2, true);
        actionGroup2.add((AnAction)new ToggleMatchCase(this));
        actionGroup2.add((AnAction)new ToggleRegex(this));
        actionGroup2.add((AnAction)new ToggleWholeWordsOnlyAction(this));
        this.myMatchInfoLabel = new JLabel(){

            @Override
            public Font getFont() {
                Font font = super.getFont();
                return font != null ? font.deriveFont(1) : null;
            }
        };
        this.myMatchInfoLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)20, (int)0, (int)20));
        this.myClickToHighlightLabel = new LinkLabel("Click to highlight", null, (LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                EditorSearchComponent.this.setMatchesLimit(Integer.MAX_VALUE);
                EditorSearchComponent.this.updateResults(true);
            }
        });
        this.myClickToHighlightLabel.setVisible(false);
        this.mySearchActionsToolbar2 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)actionGroup2, true);
        actionGroup2.add((AnAction)new DefaultCustomComponentAction((JComponent)this.myMatchInfoLabel));
        actionGroup2.add((AnAction)new DefaultCustomComponentAction(this.myClickToHighlightLabel));
        this.mySearchActionsToolbar1.setLayoutPolicy(2);
        this.mySearchActionsToolbar2.setLayoutPolicy(2);
        this.mySearchActionsToolbar1.setBorder(null);
        this.mySearchActionsToolbar2.setBorder(null);
        this.mySearchActionsToolbar1.setOpaque(false);
        this.mySearchActionsToolbar2.setOpaque(false);
        new ShowMoreOptions(this.mySearchActionsToolbar1, (JComponent)this.mySearchFieldWrapper);
        Utils.setSmallerFontForChildren(this.mySearchActionsToolbar1);
        Utils.setSmallerFontForChildren(this.mySearchActionsToolbar2);
    }

    private void initReplaceToolBars() {
        DefaultActionGroup actionGroup1 = new DefaultActionGroup("replace bar 1", false);
        this.myReplaceActionsToolbar1 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)actionGroup1, true);
        this.myReplaceActionsToolbar1.setForceMinimumSize(true);
        this.myReplaceActionsToolbar1.setReservePlaceAutoPopupIcon(false);
        final JButton myReplaceButton = new JButton("Replace");
        myReplaceButton.setFocusable(false);
        myReplaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorSearchComponent.this.replaceCurrent();
            }
        });
        final JButton myReplaceAllButton = new JButton("Replace all");
        myReplaceAllButton.setFocusable(false);
        myReplaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorSearchComponent.this.myLivePreviewController.performReplaceAll();
            }
        });
        final JButton myExcludeButton = new JButton("");
        myExcludeButton.setFocusable(false);
        myExcludeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorSearchComponent.this.myLivePreviewController.exclude();
                EditorSearchComponent.this.moveCursor(SearchResults.Direction.DOWN);
            }
        });
        if (!UISettings.getInstance().DISABLE_MNEMONICS_IN_CONTROLS) {
            myReplaceButton.setMnemonic('p');
            myReplaceAllButton.setMnemonic('a');
            myExcludeButton.setMnemonic('l');
        }
        actionGroup1.addAction((AnAction)new DefaultCustomComponentAction(myReplaceButton){

            public void update(AnActionEvent e) {
                myReplaceButton.setEnabled(EditorSearchComponent.this.canReplaceCurrent());
            }
        });
        actionGroup1.addAction((AnAction)new DefaultCustomComponentAction(myReplaceAllButton){

            public void update(AnActionEvent e) {
                myReplaceAllButton.setEnabled(EditorSearchComponent.this.mySearchResults != null && EditorSearchComponent.this.mySearchResults.hasMatches());
            }
        });
        actionGroup1.addAction((AnAction)new DefaultCustomComponentAction(myExcludeButton){

            public void update(AnActionEvent e) {
                FindResult cursor = EditorSearchComponent.this.mySearchResults != null ? EditorSearchComponent.this.mySearchResults.getCursor() : null;
                myExcludeButton.setEnabled(cursor != null);
                myExcludeButton.setText(cursor != null && EditorSearchComponent.this.mySearchResults.isExcluded(cursor) ? "Include" : "Exclude");
            }
        });
        this.myReplaceActionsToolbar1.setLayoutPolicy(2);
        this.myReplaceActionsToolbar1.setBorder(null);
        this.myReplaceActionsToolbar1.setOpaque(false);
        DefaultActionGroup actionGroup2 = new DefaultActionGroup("replace bar 2", false);
        this.myReplaceActionsToolbar2 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)actionGroup2, true);
        actionGroup2.addAction((AnAction)new TogglePreserveCaseAction(this));
        actionGroup2.addAction((AnAction)new ToggleSelectionOnlyAction(this));
        this.myReplaceActionsToolbar2.setLayoutPolicy(2);
        this.myReplaceActionsToolbar2.setBorder(null);
        this.myReplaceActionsToolbar2.setOpaque(false);
        Utils.setSmallerFontForChildren(this.myReplaceActionsToolbar1);
        Utils.setSmallerFontForChildren(this.myReplaceActionsToolbar2);
    }

    private static void adjustRows(JTextArea area) {
        area.setRows(Math.max(2, Math.min(3, StringUtil.countChars((CharSequence)area.getText(), (char)'\n') + 1)));
    }

    public FindModel getFindModel() {
        return this.myFindModel;
    }

    private static void syncFindModels(FindModel to, FindModel from) {
        to.setCaseSensitive(from.isCaseSensitive());
        to.setWholeWordsOnly(from.isWholeWordsOnly());
        to.setRegularExpressions(from.isRegularExpressions());
        to.setSearchContext(from.getSearchContext());
        if (from.isReplaceState()) {
            to.setPreserveCase(from.isPreserveCase());
        }
    }

    public void updateUIWithFindModel() {
        boolean needToResetSearchFocus = this.mySearchTextComponent.hasFocus();
        boolean needToResetReplaceFocus = this.myReplaceTextComponent.hasFocus();
        this.updateSearchComponent();
        this.updateReplaceComponent();
        if (this.myFindModel.isReplaceState()) {
            if (this.myReplaceFieldWrapper.getParent() == null) {
                this.myLeftPanel.add((Component)this.myReplaceFieldWrapper, "Center");
            }
            if (this.myReplaceToolbarWrapper.getParent() == null) {
                this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
            }
            if (needToResetReplaceFocus) {
                this.myReplaceTextComponent.requestFocusInWindow();
            }
        } else {
            if (this.myReplaceFieldWrapper.getParent() != null) {
                this.myLeftPanel.remove((Component)this.myReplaceFieldWrapper);
            }
            if (this.myReplaceToolbarWrapper.getParent() != null) {
                this.myRightPanel.remove(this.myReplaceToolbarWrapper);
            }
        }
        if (needToResetSearchFocus) {
            this.mySearchTextComponent.requestFocusInWindow();
        }
        this.mySearchActionsToolbar1.updateActionsImmediately();
        this.mySearchActionsToolbar2.updateActionsImmediately();
        this.myReplaceActionsToolbar1.updateActionsImmediately();
        this.myReplaceActionsToolbar2.updateActionsImmediately();
        this.myReplaceToolbarWrapper.revalidate();
        this.revalidate();
        this.repaint();
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value) {
        this.mySearchResults.setMatchesLimit(value);
    }

    private boolean canReplaceCurrent() {
        return this.myLivePreviewController != null && this.myLivePreviewController.canReplace();
    }

    public void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            this.myLivePreviewController.performReplace();
        }
    }

    public void showHistory(boolean byClickingToolbarButton, JTextComponent textField) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("find.recent.search");
        FindSettings settings = FindSettings.getInstance();
        Object[] recent = textField == this.mySearchTextComponent ? settings.getRecentFindStrings() : settings.getRecentReplaceStrings();
        boolean toShowAd = textField == this.mySearchTextComponent && textField.getText().isEmpty() && FindManager.getInstance((Project)this.myProject).getPreviousFindModel() != null;
        Utils.showCompletionPopup(byClickingToolbarButton ? this.mySearchActionsToolbar1 : null, (JList)new JBList(ArrayUtil.reverseArray((Object[])recent)), "Recent " + (textField == this.mySearchTextComponent ? "Searches" : "Replaces"), textField, toShowAd ? RestorePreviousSettingsAction.getAd() : null);
    }

    private boolean updateTextComponent(final boolean search) {
        JTextComponent textComponent;
        JTextComponent oldComponent = search ? this.mySearchTextComponent : this.myReplaceTextComponent;
        Color oldBackground = oldComponent != null ? oldComponent.getBackground() : null;
        Wrapper wrapper = search ? this.mySearchFieldWrapper : this.myReplaceFieldWrapper;
        boolean multiline = this.myFindModel.isMultiline();
        if (multiline && oldComponent instanceof JTextArea) {
            return false;
        }
        if (!multiline && oldComponent instanceof JTextField) {
            return false;
        }
        if (multiline) {
            textComponent = new JTextArea();
            ((JTextArea)textComponent).setColumns(25);
            ((JTextArea)textComponent).setRows(2);
            wrapper.setContent((JComponent)((Object)new SearchWrapper(textComponent, new ShowHistoryAction(textComponent, this))));
        } else {
            SearchTextField searchTextField = new SearchTextField(true);
            searchTextField.setOpaque(false);
            textComponent = searchTextField.getTextEditor();
            searchTextField.getTextEditor().setColumns(25);
            if (UIUtil.isUnderGTKLookAndFeel()) {
                textComponent.setOpaque(false);
            }
            searchTextField.setHistorySize(20);
            searchTextField.setHistory(ContainerUtil.reverse(Arrays.asList(search ? FindSettings.getInstance().getRecentFindStrings() : FindSettings.getInstance().getRecentReplaceStrings())));
            textComponent.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final String text = textComponent.getText();
                    EditorSearchComponent.this.myFindModel.setMultiline(true);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (search) {
                                EditorSearchComponent.this.mySearchTextComponent.setText(text + "\n");
                            } else {
                                EditorSearchComponent.this.myReplaceTextComponent.setText(text + "\n");
                            }
                        }
                    });
                }
            }, KeyStroke.getKeyStroke(10, 512), 0);
            wrapper.setContent((JComponent)searchTextField);
        }
        if (search) {
            this.mySearchTextComponent = textComponent;
        } else {
            this.myReplaceTextComponent = textComponent;
        }
        UIUtil.addUndoRedoActions((JTextComponent)textComponent);
        Utils.setSmallerFont(textComponent);
        textComponent.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        if (oldBackground != null) {
            textComponent.setBackground(oldBackground);
        }
        textComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }
        });
        new CloseOnESCAction(this, textComponent);
        return true;
    }

    private void requestFocus(Component c) {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, true);
    }

    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.mySearchTextComponent);
    }

    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.mySearchTextComponent);
    }

    public void addTextToRecent(JTextComponent textField) {
        String text = textField.getText();
        if (text.length() > 0) {
            if (textField == this.mySearchTextComponent) {
                FindSettings.getInstance().addStringToFind(text);
                if (this.mySearchFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            } else {
                FindSettings.getInstance().addStringToReplace(text);
                if (this.myReplaceFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            }
        }
    }

    public void selectionChanged(SelectionEvent e) {
        this.updateResults(false);
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    @Override
    public void requestFocus() {
        this.mySearchTextComponent.setSelectionStart(0);
        this.mySearchTextComponent.setSelectionEnd(this.mySearchTextComponent.getText().length());
        this.requestFocus(this.mySearchTextComponent);
    }

    public void close() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initLivePreview();
    }

    private void initLivePreview() {
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.myLivePreviewController.off();
        this.mySearchResults.removeListener(this);
        this.addTextToRecent(this.mySearchTextComponent);
        if (this.myReplaceTextComponent != null) {
            this.addTextToRecent(this.myReplaceTextComponent);
        }
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        String text = this.myFindModel.getStringToFind();
        if (text.length() == 0) {
            this.nothingToSearchFor();
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text);
                }
                catch (Exception e) {
                    this.setNotFoundBackground();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    this.myMatchInfoLabel.setText("Incorrect regular expression");
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance((Project)this.myProject);
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy = new FindModel();
                copy.copyFrom(this.myFindModel);
                copy.setReplaceState(false);
                findManager.setFindNextModel(copy);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor() {
        this.updateUIWithEmptyResults();
        if (this.mySearchResults != null) {
            this.mySearchResults.clear();
        }
    }

    private void updateUIWithEmptyResults() {
        this.setRegularBackground();
        this.myMatchInfoLabel.setText("");
        this.myClickToHighlightLabel.setVisible(false);
    }

    private void setRegularBackground() {
        this.mySearchTextComponent.setBackground(this.myDefaultBackground);
    }

    private void setNotFoundBackground() {
        this.mySearchTextComponent.setBackground(LightColors.RED);
    }

    public String getTextInField() {
        return this.mySearchTextComponent.getText();
    }

    public void setTextInField(String text) {
        this.mySearchTextComponent.setText(text);
        this.myFindModel.setStringToFind(text);
    }

    public boolean hasMatches() {
        return this.mySearchResults != null && this.mySearchResults.hasMatches();
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel()) {
            ++insets.top;
            insets.bottom += 2;
        }
        return insets;
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        UIUtil.resetUndoRedoActions((JTextComponent)this.mySearchTextComponent);
        UIUtil.resetUndoRedoActions((JTextComponent)this.myReplaceTextComponent);
    }
}

