/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportSettingsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ExportSettingsAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@Nullable AnActionEvent e) {
        ApplicationManager.getApplication().saveSettings();
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(ExportSettingsAction.getExportableComponentsMap(true, true), true, IdeBundle.message((String)"title.select.components.to.export", (Object[])new Object[0]), IdeBundle.message((String)"prompt.please.check.all.components.to.export", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        Set<ExportableComponent> markedComponents = dialog.getExportableComponents();
        if (markedComponents.isEmpty()) {
            return;
        }
        THashSet exportFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (ExportableComponent markedComponent : markedComponents) {
            ContainerUtil.addAll((Collection)exportFiles, (Object[])markedComponent.getExportFiles());
        }
        File saveFile = dialog.getExportFile();
        try {
            if (saveFile.exists() && Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.overwrite.settings.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)saveFile.getPath())}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            MyZipOutputStream zipOut = new MyZipOutputStream(new BufferedOutputStream(new FileOutputStream(saveFile)));
            try {
                THashSet writtenItemRelativePaths = new THashSet();
                String configRoot = PathManager.getConfigPath();
                for (File file : exportFiles) {
                    if (!file.exists()) continue;
                    String rPath = FileUtilRt.getRelativePath((String)configRoot, (String)file.getAbsolutePath(), (char)File.separatorChar);
                    assert (rPath != null);
                    ZipUtil.addFileOrDirRecursively((ZipOutputStream)zipOut, null, (File)file, (String)FileUtilRt.toSystemIndependentName((String)rPath), null, (Set)writtenItemRelativePaths);
                }
                ExportSettingsAction.exportInstalledPlugins(zipOut);
                ZipEntry zipEntry = new ZipEntry("IntelliJ IDEA Global Settings");
                zipOut.putNextEntry(zipEntry);
                zipOut.closeEntry();
            }
            finally {
                zipOut.close();
            }
            ShowFilePathAction.showDialog(ExportSettingsAction.getEventProject((AnActionEvent)e), IdeBundle.message((String)"message.settings.exported.successfully", (Object[])new Object[0]), IdeBundle.message((String)"title.export.successful", (Object[])new Object[0]), saveFile, null);
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.writing.settings", (Object[])new Object[]{e1.toString()}), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportInstalledPlugins(@NotNull MyZipOutputStream zipOut) throws IOException {
        if (zipOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zipOut", "com/intellij/ide/actions/ExportSettingsAction", "exportInstalledPlugins"));
        }
        ArrayList<String> plugins = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (descriptor.isBundled() || !descriptor.isEnabled()) continue;
            plugins.add(descriptor.getPluginId().getIdString());
        }
        if (plugins.isEmpty()) {
            return;
        }
        ZipEntry e = new ZipEntry("installed.txt");
        zipOut.putNextEntry(e);
        zipOut.ignoreClose = true;
        try {
            PluginManagerCore.writePluginsList(plugins, new OutputStreamWriter((OutputStream)zipOut, CharsetToolkit.UTF8_CHARSET));
        }
        finally {
            zipOut.ignoreClose = false;
            zipOut.closeEntry();
        }
    }

    @NotNull
    public static MultiMap<File, ExportableComponent> getExportableComponentsMap(final boolean onlyExisting, final boolean computePresentableNames) {
        List<ExportableApplicationComponent> components1 = ComponentsPackage.getComponents((ComponentManager)ApplicationManager.getApplication(), ExportableApplicationComponent.class);
        List components2 = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        final MultiMap result = MultiMap.createLinkedSet();
        for (ExportableComponent component : ContainerUtil.concat(components1, (List)components2)) {
            for (File exportFile : component.getExportFiles()) {
                result.putValue((Object)exportFile, (Object)component);
            }
        }
        if (onlyExisting) {
            Iterator it = result.keySet().iterator();
            while (it.hasNext()) {
                if (((File)it.next()).exists()) continue;
                it.remove();
            }
        }
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        final StateStorageManager storageManager2 = ComponentsPackage.getStateStore(application).getStateStorageManager();
        ServiceManagerImpl.processAllImplementationClasses(application, new PairProcessor<Class<?>, PluginDescriptor>(){

            public boolean process(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/actions/ExportSettingsAction$1", "process"));
                }
                State stateAnnotation = StoreUtil.getStateSpec(aClass);
                if (stateAnnotation != null && !StringUtil.isEmpty((String)stateAnnotation.name())) {
                    if (ExportableComponent.class.isAssignableFrom(aClass)) {
                        return true;
                    }
                    Storage[] storages = stateAnnotation.storages();
                    if (storages.length != 1) {
                        return true;
                    }
                    int storageIndex = 0;
                    Storage storage2 = storages[storageIndex];
                    if (storage2.roamingType() != RoamingType.DISABLED && storage2.storageClass().equals(StateStorage.class) && storage2.scheme() == StorageScheme.DEFAULT && !StringUtil.isEmpty((String)storage2.file()) && storage2.file().startsWith("$APP_CONFIG$")) {
                        boolean fileExists;
                        File additionalExportFile = null;
                        if (!StringUtil.isEmpty((String)stateAnnotation.additionalExportFile())) {
                            String expandedPath = storageManager2.expandMacros(stateAnnotation.additionalExportFile());
                            additionalExportFile = new File(expandedPath);
                            if (!additionalExportFile.exists()) {
                                additionalExportFile = new File(storageManager2.expandMacros("$ROOT_CONFIG$") + '/' + expandedPath);
                            }
                            if (onlyExisting && !additionalExportFile.exists()) {
                                additionalExportFile = null;
                            }
                        }
                        File file = new File(storageManager2.expandMacros(storage2.file()));
                        boolean bl = fileExists = !onlyExisting || file.exists();
                        if (fileExists || additionalExportFile != null) {
                            File[] files;
                            if (additionalExportFile == null) {
                                files = new File[]{file};
                            } else {
                                File[] fileArray;
                                if (fileExists) {
                                    File[] fileArray2 = new File[2];
                                    fileArray2[0] = file;
                                    fileArray = fileArray2;
                                    fileArray2[1] = additionalExportFile;
                                } else {
                                    File[] fileArray3 = new File[1];
                                    fileArray = fileArray3;
                                    fileArray3[0] = additionalExportFile;
                                }
                                files = fileArray;
                            }
                            ExportableComponentItem item = new ExportableComponentItem(files, computePresentableNames ? ExportSettingsAction.getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "", storage2.roamingType());
                            result.putValue((Object)file, (Object)item);
                            if (additionalExportFile != null) {
                                result.putValue((Object)additionalExportFile, (Object)item);
                            }
                        }
                    }
                }
                return true;
            }
        });
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentsMap"));
        }
        return multiMap;
    }

    @NotNull
    private static String getComponentPresentableName(@NotNull State state, @NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
        }
        if (state.presentableName() != State.NameGetter.class) {
            String string;
            try {
                string = (String)((State.NameGetter)ReflectionUtil.newInstance((Class)state.presentableName())).get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
            }
            return string;
        }
        String defaultName = state.name();
        String resourceBundleName = pluginDescriptor != null && pluginDescriptor instanceof IdeaPluginDescriptor && !"com.intellij".equals(pluginDescriptor.getPluginId().getIdString()) ? ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName() : "messages.OptionsBundle";
        if (resourceBundleName == null) {
            String string = defaultName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
            }
            return string;
        }
        ClassLoader classLoader = pluginDescriptor == null ? null : pluginDescriptor.getPluginClassLoader();
        ClassLoader classLoader2 = classLoader = classLoader == null ? aClass.getClassLoader() : classLoader;
        if (classLoader != null) {
            String message = ExportSettingsAction.messageOrDefault(classLoader, resourceBundleName, defaultName);
            if (message != defaultName) {
                String string = message;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
                }
                return string;
            }
            if (PlatformUtils.isRubyMine()) {
                String string = ExportSettingsAction.messageOrDefault(classLoader, "org.jetbrains.plugins.ruby.RBundle", defaultName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
                }
                return string;
            }
        }
        String string = defaultName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getComponentPresentableName"));
        }
        return string;
    }

    @NotNull
    private static String messageOrDefault(@NotNull ClassLoader classLoader, @NotNull String bundleName, @NotNull String defaultName) {
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "com/intellij/ide/actions/ExportSettingsAction", "messageOrDefault"));
        }
        if (bundleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleName", "com/intellij/ide/actions/ExportSettingsAction", "messageOrDefault"));
        }
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/ide/actions/ExportSettingsAction", "messageOrDefault"));
        }
        ResourceBundle bundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        String string = bundle == null ? defaultName : CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "messageOrDefault"));
        }
        return string;
    }

    public static final class ExportableComponentItem
    implements ExportableComponent {
        private final File[] files;
        private final String name;
        private final RoamingType roamingType;

        public ExportableComponentItem(@NotNull File[] files, @NotNull String name, @NotNull RoamingType roamingType) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/ide/actions/ExportSettingsAction$ExportableComponentItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/actions/ExportSettingsAction$ExportableComponentItem", "<init>"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/ide/actions/ExportSettingsAction$ExportableComponentItem", "<init>"));
            }
            this.files = files;
            this.name = name;
            this.roamingType = roamingType;
        }

        @NotNull
        public File[] getExportFiles() {
            if (this.files == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction$ExportableComponentItem", "getExportFiles"));
            }
            return this.files;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction$ExportableComponentItem", "getPresentableName"));
            }
            return string;
        }

        @NotNull
        public RoamingType getRoamingType() {
            RoamingType roamingType = this.roamingType;
            if (roamingType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction$ExportableComponentItem", "getRoamingType"));
            }
            return roamingType;
        }
    }

    private static class MyZipOutputStream
    extends ZipOutputStream {
        private boolean ignoreClose;

        public MyZipOutputStream(@NotNull OutputStream out) {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/ide/actions/ExportSettingsAction$MyZipOutputStream", "<init>"));
            }
            super(out);
            this.ignoreClose = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.ignoreClose) {
                super.close();
            }
        }
    }
}

