/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class BaseOpenInBrowserAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(BaseOpenInBrowserAction.class);

    protected BaseOpenInBrowserAction(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "<init>"));
        }
        super(browser.getName(), null, browser.getIcon());
    }

    protected BaseOpenInBrowserAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    protected abstract WebBrowser getBrowser(@NotNull AnActionEvent var1);

    public final void update(AnActionEvent e) {
        WebBrowser browser = this.getBrowser(e);
        if (browser == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        OpenInBrowserRequest result = BaseOpenInBrowserAction.doUpdate(e);
        if (result == null) {
            return;
        }
        String description = this.getTemplatePresentation().getText();
        if ("ContextToolbar".equals(e.getPlace())) {
            boolean exists;
            StringBuilder builder = new StringBuilder(description);
            builder.append(" (");
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("WebOpenInAction");
            boolean bl = exists = shortcuts.length > 0;
            if (exists) {
                builder.append(KeymapUtil.getShortcutText((Shortcut)shortcuts[0]));
            }
            if (HtmlUtil.isHtmlFile((PsiElement)result.getFile())) {
                builder.append(exists ? ", " : "").append("hold Shift to open URL of local file");
            }
            builder.append(')');
            description = builder.toString();
        }
        e.getPresentation().setText(description);
    }

    public final void actionPerformed(AnActionEvent e) {
        WebBrowser browser = this.getBrowser(e);
        if (browser != null) {
            UsageTrigger.trigger("OpenInBrowser." + browser.getName());
            BaseOpenInBrowserAction.open(e, browser);
        }
    }

    @Nullable
    public static OpenInBrowserRequest createRequest(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "createRequest"));
        }
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            Project project = editor.getProject();
            if (project != null && project.isInitialized()) {
                PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
                if (psiFile == null) {
                    psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                }
                if (psiFile != null) {
                    return new OpenInBrowserRequest(psiFile){
                        private PsiElement element;

                        @NotNull
                        public PsiElement getElement() {
                            if (this.element == null) {
                                this.element = this.getFile().findElementAt(editor.getCaretModel().getOffset());
                            }
                            PsiElement psiElement = (PsiElement)ObjectUtils.chooseNotNull((Object)this.element, (Object)this.getFile());
                            if (psiElement == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction$1", "getElement"));
                            }
                            return psiElement;
                        }
                    };
                }
            }
        } else {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (virtualFile != null && !virtualFile.isDirectory() && virtualFile.isValid() && project != null && project.isInitialized()) {
                psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            }
            if (psiFile != null) {
                return OpenInBrowserRequest.create((PsiElement)psiFile);
            }
        }
        return null;
    }

    @Nullable
    public static OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "doUpdate"));
        }
        OpenInBrowserRequest request = BaseOpenInBrowserAction.createRequest(event.getDataContext());
        boolean applicable = request != null && WebBrowserServiceImpl.getProvider(request) != null;
        event.getPresentation().setEnabledAndVisible(applicable);
        return applicable ? request : null;
    }

    public static void open(@NotNull AnActionEvent event, @Nullable WebBrowser browser) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "open"));
        }
        BaseOpenInBrowserAction.open(BaseOpenInBrowserAction.createRequest(event.getDataContext()), (event.getModifiers() & 1) != 0, browser);
    }

    public static void open(final @Nullable OpenInBrowserRequest request, boolean preferLocalUrl, final @Nullable WebBrowser browser) {
        if (request == null) {
            return;
        }
        try {
            Collection urls = WebBrowserService.getInstance().getUrlsToOpen(request, preferLocalUrl);
            if (!urls.isEmpty()) {
                BaseOpenInBrowserAction.chooseUrl(urls).done((Consumer)new Consumer<Url>(){

                    public void consume(Url url) {
                        ApplicationManager.getApplication().saveAll();
                        BrowserLauncher.getInstance().browse(url.toExternalForm(), browser, request.getProject());
                    }
                });
            }
        }
        catch (WebBrowserUrlProvider.BrowserException e1) {
            Messages.showErrorDialog((String)e1.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
        }
        catch (Exception e1) {
            LOG.error((Throwable)e1);
        }
    }

    @NotNull
    private static Promise<Url> chooseUrl(@NotNull Collection<Url> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "chooseUrl"));
        }
        if (urls.size() == 1) {
            Promise promise = Promise.resolve((Object)ContainerUtil.getFirstItem(urls));
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "chooseUrl"));
            }
            return promise;
        }
        final JBList list = new JBList(urls);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setIcon(AllIcons.Nodes.Servlet);
                this.append(((Url)value).toDecodedForm());
            }
        });
        final AsyncPromise result = new AsyncPromise();
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Url").setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                Url value = (Url)list.getSelectedValue();
                if (value == null) {
                    result.setError((Throwable)Promise.createError((String)"selected value is null"));
                } else {
                    result.setResult((Object)value);
                }
            }
        }).createPopup().showInFocusCenter();
        AsyncPromise asyncPromise2 = result;
        if (asyncPromise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/actions/BaseOpenInBrowserAction", "chooseUrl"));
        }
        return asyncPromise2;
    }
}

