/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.ClassSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiClassFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, ViewSettings viewSettings) {
        PsiElement element;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiClass) || !this.checkClassUnderSources(element2, project)) continue;
                result.add((AbstractTreeNode)new ClassSmartPointerNode(project, element2, viewSettings));
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    private boolean checkClassUnderSources(PsiElement element, Project project) {
        PsiFile file = element.getContainingFile();
        if (file != null && file.getVirtualFile() != null) {
            VirtualFile vf;
            FileIndexFacade indexFacade = FileIndexFacade.getInstance((Project)project);
            return indexFacade.isInSource(vf = file.getVirtualFile()) || indexFacade.isInSourceContent(vf);
        }
        return false;
    }

    public AbstractTreeNode createNode(Project project, Object element, ViewSettings viewSettings) {
        if (element instanceof PsiClass && this.checkClassUnderSources((PsiElement)element, project)) {
            return new ClassSmartPointerNode(project, element, viewSettings);
        }
        return super.createNode(project, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        PsiFile file;
        return element instanceof PsiClass && (file = ((PsiClass)element).getContainingFile()) != null && Comparing.equal((Object)file.getVirtualFile(), (Object)vFile);
    }

    public int getElementWeight(Object value, boolean isSortByType) {
        if (value instanceof PsiClass) {
            return isSortByType ? ClassTreeNode.getClassPosition((PsiClass)value) : 3;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiClass && !((PsiClass)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/PsiClassFavoriteNodeProvider", "getFavoriteTypeId"));
        }
        return "class";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            return aClass.getQualifiedName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            return module != null ? module.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        PsiClass aClass;
        Module module;
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        GlobalSearchScope scope = null;
        if (moduleName != null && (module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName)) != null) {
            scope = GlobalSearchScope.moduleScope((Module)module);
        }
        if (scope == null) {
            scope = GlobalSearchScope.allScope((Project)project);
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)project).findClass(url, scope)) == null) {
            return null;
        }
        return new Object[]{aClass};
    }
}

