/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.impl.ConversionServiceImpl;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.impl.convert.ProjectFileVersion;
import com.intellij.ide.impl.convert.ProjectFileVersionState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFileVersion", storages={@Storage(file="$PROJECT_FILE$")})
public class ProjectFileVersionImpl
extends ProjectFileVersion
implements ProjectComponent,
PersistentStateComponent<ProjectFileVersionState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.convert.ProjectFileVersionImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFileVersion";
    private final Project myProject;
    private final ProjectFileVersionState myState = new ProjectFileVersionState();

    public ProjectFileVersionImpl(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/convert/ProjectFileVersionImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        VirtualFile file;
        if (this.myProject.isDefault() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile virtualFile = file = ProjectUtil.isDirectoryBased(this.myProject) ? this.myProject.getBaseDir() : this.myProject.getProjectFile();
        if (file == null) {
            LOG.info("Cannot save conversion result: filePath == null");
        } else {
            ConversionServiceImpl.saveConversionResult(FileUtil.toSystemDependentName((String)file.getPath()));
        }
    }

    public ProjectFileVersionState getState() {
        if (this.myState != null && !this.myState.getPerformedConversionIds().isEmpty()) {
            return this.myState;
        }
        return null;
    }

    public void loadState(ProjectFileVersionState state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }
}

