/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.newProjectWizard.modes.ImportImlMode;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFromSourcesBuilderImpl
extends ProjectImportBuilder
implements ProjectFromSourcesBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl");
    private static final String NAME = "Existing Sources";
    private String myBaseProjectPath;
    private final List<ProjectConfigurationUpdater> myUpdaters = new ArrayList<ProjectConfigurationUpdater>();
    private final Map<ProjectStructureDetector, ProjectDescriptor> myProjectDescriptors = new LinkedHashMap<ProjectStructureDetector, ProjectDescriptor>();
    private MultiMap<ProjectStructureDetector, DetectedProjectRoot> myRoots = MultiMap.emptyInstance();
    private final WizardContext myContext;
    private final ModulesProvider myModulesProvider;
    private Set<String> myModuleNames;
    private Set<String> myProjectLibrariesNames;

    public ProjectFromSourcesBuilderImpl(WizardContext context, ModulesProvider modulesProvider) {
        this.myContext = context;
        this.myModulesProvider = modulesProvider;
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            this.myProjectDescriptors.put(detector, new ProjectDescriptor());
        }
    }

    @Override
    @NotNull
    public Set<String> getExistingModuleNames() {
        if (this.myModuleNames == null) {
            this.myModuleNames = new HashSet<String>();
            for (Module module : this.myModulesProvider.getModules()) {
                this.myModuleNames.add(module.getName());
            }
        }
        Set<String> set = this.myModuleNames;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getExistingModuleNames"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getExistingProjectLibraryNames() {
        if (this.myProjectLibrariesNames == null) {
            this.myProjectLibrariesNames = new HashSet<String>();
            LibrariesContainer container = LibrariesContainerFactory.createContainer(this.myContext, this.myModulesProvider);
            for (Library library : container.getLibraries(LibrariesContainer.LibraryLevel.PROJECT)) {
                this.myProjectLibrariesNames.add(library.getName());
            }
        }
        Set<String> set = this.myProjectLibrariesNames;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getExistingProjectLibraryNames"));
        }
        return set;
    }

    @Override
    @NotNull
    public WizardContext getContext() {
        WizardContext wizardContext = this.myContext;
        if (wizardContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getContext"));
        }
        return wizardContext;
    }

    public void setBaseProjectPath(String contentRootPath) {
        this.myBaseProjectPath = contentRootPath;
    }

    @Override
    public String getBaseProjectPath() {
        return this.myBaseProjectPath;
    }

    public void setupProjectStructure(MultiMap<ProjectStructureDetector, DetectedProjectRoot> roots) {
        this.myRoots = roots;
        for (ProjectStructureDetector detector : roots.keySet()) {
            detector.setupProjectStructure(roots.get((Object)detector), this.getProjectDescriptor(detector), this);
        }
    }

    @Override
    @NotNull
    public Collection<DetectedProjectRoot> getProjectRoots(@NotNull ProjectStructureDetector detector) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getProjectRoots"));
        }
        Collection collection = this.myRoots.get((Object)detector);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getProjectRoots"));
        }
        return collection;
    }

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getName"));
        }
        return NAME;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Folder;
    }

    public List getList() {
        return null;
    }

    public boolean isMarked(Object element) {
        return false;
    }

    public void setList(List list) throws ConfigurationException {
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @Override
    public void setFileToImport(String path) {
        this.setBaseProjectPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Module> commit(@NotNull Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        AccessToken token;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "commit"));
        }
        boolean fromProjectStructure = model != null;
        IdeaModifiableModelsProvider modelsProvider = new IdeaModifiableModelsProvider();
        LibraryTable.ModifiableModel projectLibraryTable = modelsProvider.getLibraryTableModifiableModel(project);
        HashMap<LibraryDescriptor, Library> projectLibs = new HashMap<LibraryDescriptor, Library>();
        ArrayList<Module> result = new ArrayList<Module>();
        try {
            AccessToken token2 = WriteAction.start();
            try {
                for (ProjectDescriptor projectDescriptor : this.getSelectedDescriptors()) {
                    for (LibraryDescriptor libraryDescriptor : projectDescriptor.getLibraries()) {
                        Collection<File> files = libraryDescriptor.getJars();
                        Library projectLib = projectLibraryTable.createLibrary(libraryDescriptor.getName());
                        Library.ModifiableModel libraryModel = projectLib.getModifiableModel();
                        Iterator<File> iterator = files.iterator();
                        while (iterator.hasNext()) {
                            File file = iterator.next();
                            libraryModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
                        }
                        libraryModel.commit();
                        projectLibs.put(libraryDescriptor, projectLib);
                    }
                }
                if (!fromProjectStructure) {
                    projectLibraryTable.commit();
                }
            }
            finally {
                token2.finish();
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        HashMap<ModuleDescriptor, Module> descriptorToModuleMap = new HashMap<ModuleDescriptor, Module>();
        try {
            token = WriteAction.start();
            try {
                ModifiableModuleModel moduleModel = fromProjectStructure ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
                for (ProjectDescriptor projectDescriptor : this.getSelectedDescriptors()) {
                    for (ModuleDescriptor moduleDescriptor : projectDescriptor.getModules()) {
                        Module module;
                        if (moduleDescriptor.isReuseExistingElement()) {
                            ExistingModuleLoader moduleLoader = ImportImlMode.setUpLoader(FileUtil.toSystemIndependentName((String)moduleDescriptor.computeModuleFilePath()));
                            module = moduleLoader.createModule(moduleModel);
                        } else {
                            module = ProjectFromSourcesBuilderImpl.createModule(projectDescriptor, moduleDescriptor, projectLibs, moduleModel);
                        }
                        result.add(module);
                        descriptorToModuleMap.put(moduleDescriptor, module);
                    }
                }
                if (!fromProjectStructure) {
                    moduleModel.commit();
                }
            }
            finally {
                token.finish();
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        try {
            token = WriteAction.start();
            try {
                for (ProjectDescriptor data2 : this.getSelectedDescriptors()) {
                    for (ModuleDescriptor descriptor : data2.getModules()) {
                        Set<ModuleDescriptor> deps;
                        Module module = (Module)descriptorToModuleMap.get(descriptor);
                        if (module == null || (deps = descriptor.getDependencies()).size() == 0) continue;
                        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                        for (ModuleDescriptor dependentDescriptor : deps) {
                            Module dependentModule = (Module)descriptorToModuleMap.get(dependentDescriptor);
                            if (dependentModule == null) continue;
                            rootModel.addModuleOrderEntry(dependentModule);
                        }
                        rootModel.commit();
                    }
                }
            }
            finally {
                token.finish();
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.adding.module.to.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.add.module", (Object[])new Object[0]));
        }
        token = WriteAction.start();
        try {
            ModulesProvider updatedModulesProvider = fromProjectStructure ? modulesProvider : new DefaultModulesProvider(project);
            for (ProjectConfigurationUpdater projectConfigurationUpdater : this.myUpdaters) {
                projectConfigurationUpdater.updateProject(project, modelsProvider, updatedModulesProvider);
            }
        }
        finally {
            token.finish();
        }
        return result;
    }

    @Override
    @Nullable
    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        return this.commit(project, model, modulesProvider);
    }

    public Collection<ProjectDescriptor> getSelectedDescriptors() {
        return this.myProjectDescriptors.values();
    }

    public void addConfigurationUpdater(ProjectConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    @Override
    public boolean hasRootsFromOtherDetectors(ProjectStructureDetector thisDetector) {
        for (ProjectStructureDetector projectStructureDetector : (ProjectStructureDetector[])Extensions.getExtensions(ProjectStructureDetector.EP_NAME)) {
            if (projectStructureDetector == thisDetector || this.getProjectRoots(projectStructureDetector).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setupModulesByContentRoots(ProjectDescriptor projectDescriptor, Collection<DetectedProjectRoot> roots) {
        if (projectDescriptor.getModules().isEmpty()) {
            ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
            for (DetectedProjectRoot root : roots) {
                if (!(root instanceof DetectedContentRoot)) continue;
                modules.add(new ModuleDescriptor(root.getDirectory(), ((DetectedContentRoot)root).getModuleType(), Collections.emptyList()));
            }
            projectDescriptor.setModules(modules);
        }
    }

    @NotNull
    private static Module createModule(ProjectDescriptor projectDescriptor, ModuleDescriptor descriptor, Map<LibraryDescriptor, Library> projectLibs, ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        String moduleFilePath = descriptor.computeModuleFilePath();
        ModuleBuilder.deleteModuleFile((String)moduleFilePath);
        Module module = moduleModel.newModule(moduleFilePath, descriptor.getModuleType().getId());
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        ProjectFromSourcesBuilderImpl.setupRootModel(projectDescriptor, descriptor, modifiableModel, projectLibs);
        descriptor.updateModuleConfiguration(module, modifiableModel);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "createModule"));
        }
        return module2;
    }

    private static void setupRootModel(ProjectDescriptor projectDescriptor, ModuleDescriptor descriptor, ModifiableRootModel rootModel, Map<LibraryDescriptor, Library> projectLibs) {
        CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setExcludeOutput(true);
        rootModel.inheritSdk();
        Set<File> contentRoots = descriptor.getContentRoots();
        for (File contentRoot : contentRoots) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            VirtualFile moduleContentRoot = lfs.refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)contentRoot.getPath()));
            if (moduleContentRoot == null) continue;
            ContentEntry contentEntry = rootModel.addContentEntry(moduleContentRoot);
            Collection<DetectedSourceRoot> sourceRoots = descriptor.getSourceRoots(contentRoot);
            for (DetectedSourceRoot srcRoot : sourceRoots) {
                String srcpath = FileUtil.toSystemIndependentName((String)srcRoot.getDirectory().getPath());
                VirtualFile sourceRoot = lfs.refreshAndFindFileByPath(srcpath);
                if (sourceRoot == null) continue;
                contentEntry.addSourceFolder(sourceRoot, ProjectFromSourcesBuilderImpl.shouldBeTestRoot(srcRoot.getDirectory()), ProjectFromSourcesBuilderImpl.getPackagePrefix(srcRoot));
            }
        }
        compilerModuleExtension.inheritCompilerOutputPath(true);
        LibraryTable moduleLibraryTable = rootModel.getModuleLibraryTable();
        for (LibraryDescriptor libDescriptor : ModuleInsight.getLibraryDependencies(descriptor, projectDescriptor.getLibraries())) {
            Library projectLib = projectLibs.get(libDescriptor);
            if (projectLib != null) {
                rootModel.addLibraryEntry(projectLib);
                continue;
            }
            Collection<File> jars = libDescriptor.getJars();
            for (File file : jars) {
                Library library = moduleLibraryTable.createLibrary();
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                modifiableModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
                modifiableModel.commit();
            }
        }
    }

    public static String getPackagePrefix(DetectedSourceRoot srcRoot) {
        return srcRoot.getPackagePrefix();
    }

    @Override
    @NotNull
    public ProjectDescriptor getProjectDescriptor(@NotNull ProjectStructureDetector detector) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getProjectDescriptor"));
        }
        ProjectDescriptor projectDescriptor = this.myProjectDescriptors.get(detector);
        if (projectDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl", "getProjectDescriptor"));
        }
        return projectDescriptor;
    }

    private static boolean shouldBeTestRoot(File srcRoot) {
        if (ProjectFromSourcesBuilderImpl.isTestRootName(srcRoot.getName())) {
            return true;
        }
        File parentFile = srcRoot.getParentFile();
        return parentFile != null && ProjectFromSourcesBuilderImpl.isTestRootName(parentFile.getName());
    }

    private static boolean isTestRootName(String name) {
        return "test".equalsIgnoreCase(name) || "tests".equalsIgnoreCase(name) || "testSource".equalsIgnoreCase(name) || "testSources".equalsIgnoreCase(name) || "testSrc".equalsIgnoreCase(name) || "tst".equalsIgnoreCase(name);
    }

    public boolean isSuitableSdkType(SdkTypeId sdkTypeId) {
        for (ProjectDescriptor projectDescriptor : this.getSelectedDescriptors()) {
            for (ModuleDescriptor moduleDescriptor : projectDescriptor.getModules()) {
                try {
                    ModuleType moduleType = ProjectFromSourcesBuilderImpl.getModuleType(moduleDescriptor);
                    if (moduleType == null || moduleType.createModuleBuilder().isSuitableSdkType(sdkTypeId)) continue;
                    return false;
                }
                catch (Exception exception) {
                }
            }
        }
        return true;
    }

    @Nullable
    private static ModuleType getModuleType(ModuleDescriptor moduleDescriptor) throws InvalidDataException, JDOMException, IOException {
        if (moduleDescriptor.isReuseExistingElement()) {
            Element rootElement;
            String type;
            File file = new File(moduleDescriptor.computeModuleFilePath());
            if (file.exists() && (type = (rootElement = JDOMUtil.loadDocument((File)file).getRootElement()).getAttributeValue("type")) != null) {
                return ModuleTypeManager.getInstance().findByID(type);
            }
            return null;
        }
        return moduleDescriptor.getModuleType();
    }

    public static interface ProjectConfigurationUpdater {
        public void updateProject(@NotNull Project var1, @NotNull ModifiableModelsProvider var2, @NotNull ModulesProvider var3);
    }
}

