/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="AbbreviationManager", storages={@Storage(file="$APP_CONFIG$/abbreviations.xml", roamingType=RoamingType.PER_OS)})
public class AbbreviationManagerImpl
extends AbbreviationManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<String>> myAbbreviation2ActionId = new THashMap();
    private final Map<String, LinkedHashSet<String>> myActionId2Abbreviations = new THashMap();
    private final Map<String, LinkedHashSet<String>> myPluginsActionId2Abbreviations = new THashMap();

    @Nullable
    public Element getState() {
        Element actions2 = new Element("actions");
        if (this.myActionId2Abbreviations.isEmpty()) {
            return actions2;
        }
        Element abbreviations = null;
        for (String key : this.myActionId2Abbreviations.keySet()) {
            LinkedHashSet<String> pluginAbbrs;
            LinkedHashSet<String> abbrs = this.myActionId2Abbreviations.get(key);
            if (abbrs == (pluginAbbrs = this.myPluginsActionId2Abbreviations.get(key)) || abbrs != null && abbrs.equals(pluginAbbrs) || abbrs == null) continue;
            if (abbreviations == null) {
                abbreviations = new Element("abbreviations");
                actions2.addContent(abbreviations);
            }
            Element action = new Element("action");
            action.setAttribute("id", key);
            abbreviations.addContent(action);
            for (String abbr : abbrs) {
                Element abbreviation = new Element("abbreviation");
                abbreviation.setAttribute("name", abbr);
                action.addContent(abbreviation);
            }
        }
        return actions2;
    }

    public void loadState(Element state) {
        List actions2;
        List abbreviations = state.getChildren("abbreviations");
        if (abbreviations != null && abbreviations.size() == 1 && (actions2 = ((Element)abbreviations.get(0)).getChildren("action")) != null && actions2.size() > 0) {
            for (Element action : actions2) {
                List abbreviation;
                String actionId = action.getAttributeValue("id");
                LinkedHashSet<String> values = this.myActionId2Abbreviations.get(actionId);
                if (values == null) {
                    values = new LinkedHashSet(1);
                    this.myActionId2Abbreviations.put(actionId, values);
                }
                if ((abbreviation = action.getChildren("abbreviation")) == null) continue;
                for (Element abbr : abbreviation) {
                    String abbrValue = abbr.getAttributeValue("name");
                    if (abbrValue == null) continue;
                    values.add(abbrValue);
                    List<String> actionIds = this.myAbbreviation2ActionId.get(abbrValue);
                    if (actionIds == null) {
                        actionIds = new ArrayList<String>();
                        this.myAbbreviation2ActionId.put(abbrValue, actionIds);
                    }
                    actionIds.add(actionId);
                }
            }
        }
    }

    public Set<String> getAbbreviations() {
        HashSet<String> result = new HashSet<String>();
        for (Set set : this.myActionId2Abbreviations.values()) {
            result.addAll(set);
        }
        return result;
    }

    public Set<String> getAbbreviations(String actionId) {
        LinkedHashSet<String> abbreviations = this.myActionId2Abbreviations.get(actionId);
        if (abbreviations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(abbreviations);
    }

    public List<String> findActions(String abbreviation) {
        List<String> actions2 = this.myAbbreviation2ActionId.get(abbreviation);
        return actions2 == null ? Collections.emptyList() : Collections.unmodifiableList(actions2);
    }

    public void register(String abbreviation, String actionId, Map<String, LinkedHashSet<String>> storage2) {
        LinkedHashSet<String> abbreviations = storage2.get(actionId);
        if (abbreviations == null) {
            abbreviations = new LinkedHashSet(1);
            storage2.put(actionId, abbreviations);
        }
        abbreviations.add(abbreviation);
    }

    public void register(String abbreviation, String actionId, boolean fromPluginXml) {
        List<String> ids;
        if (fromPluginXml && this.myActionId2Abbreviations.containsKey(actionId)) {
            this.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
            return;
        }
        this.register(abbreviation, actionId, this.myActionId2Abbreviations);
        if (fromPluginXml) {
            this.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
        }
        if ((ids = this.myAbbreviation2ActionId.get(abbreviation)) == null) {
            ids = new ArrayList<String>(0);
            this.myAbbreviation2ActionId.put(abbreviation, ids);
        }
        if (!ids.contains(actionId)) {
            ids.add(actionId);
        }
    }

    public void register(String abbreviation, String actionId) {
        this.register(abbreviation, actionId, false);
    }

    public void remove(String abbreviation, String actionId) {
        LinkedHashSet<String> abbreviations;
        List<String> actions2 = this.myAbbreviation2ActionId.get(abbreviation);
        if (actions2 != null) {
            actions2.remove(actionId);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) != null) {
            abbreviations.remove(abbreviation);
        } else {
            LinkedHashSet<String> abbrs = this.myActionId2Abbreviations.get(actionId);
            if (abbrs != null) {
                LinkedHashSet<String> customValues = new LinkedHashSet<String>(abbrs);
                customValues.remove(abbreviation);
                this.myActionId2Abbreviations.put(actionId, customValues);
            }
        }
    }
}

