/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.StringInterner;
import java.util.Iterator;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StorageDataBase {
    protected static final Logger LOG = Logger.getInstance(StorageDataBase.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";

    @NotNull
    public abstract Set<String> getComponentNames();

    public abstract boolean hasState(@NotNull String var1);

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageDataBase", "getComponentNameIfValid"));
        }
        String name = element.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name)) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        return name;
    }

    public static void load(@NotNull StateMap states, @NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/openapi/components/impl/stores/StorageDataBase", "load"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/StorageDataBase", "load"));
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        StringInterner interner = intern ? new StringInterner() : null;
        Iterator iterator = rootElement.getChildren(COMPONENT).iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String name = StorageDataBase.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
            iterator.remove();
            if (interner != null) {
                JDOMUtil.internElement((Element)element, (StringInterner)interner);
            }
            states.put(name, element);
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element));
            }
            element.removeAttribute(NAME);
        }
    }
}

