/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StoreUtil {
    private static final Logger LOG = Logger.getInstance(StoreUtil.class);

    private StoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(@NotNull IComponentStore stateStore, @Nullable Project project) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/intellij/openapi/components/impl/stores/StoreUtil", "save"));
        }
        ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
        try {
            stateStore.save((List<Pair<StateStorage.SaveSession, VirtualFile>>)new SmartList());
        }
        catch (IComponentStore.SaveCancelledException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Save settings failed", e);
            } else {
                LOG.warn("Save settings failed", e);
            }
            String messagePostfix = " Please restart " + ApplicationNamesInfo.getInstance().getFullProductName() + "</p>" + (ApplicationManagerEx.getApplicationEx().isInternal() ? "<p>" + StringUtil.getThrowableText((Throwable)e) + "</p>" : "");
            PluginId pluginId = IdeErrorsDialog.findPluginId(e);
            if (pluginId == null) {
                new Notification("Settings Error", "Unable to save settings", "<p>Failed to save settings." + messagePostfix, NotificationType.ERROR).notify(project);
            } else {
                PluginManagerCore.disablePlugin(pluginId.getIdString());
                new Notification("Settings Error", "Unable to save plugin settings", "<p>The plugin <i>" + pluginId + "</i> failed to save settings and has been disabled." + messagePostfix, NotificationType.ERROR).notify(project);
            }
        }
        finally {
            ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
        }
    }

    @NotNull
    public static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/StoreUtil", "getStateSpec"));
        }
        Class<?> componentClass = persistentStateComponent.getClass();
        State spec = StoreUtil.getStateSpec(componentClass);
        if (spec != null) {
            State state = spec;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StoreUtil", "getStateSpec"));
            }
            return state;
        }
        PluginId pluginId = PluginManagerCore.getPluginByClassName(componentClass.getName());
        if (pluginId == null) {
            throw new RuntimeException("No @State annotation found in " + componentClass);
        }
        throw new PluginException("No @State annotation found in " + componentClass, pluginId);
    }

    @Nullable
    public static State getStateSpec(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/components/impl/stores/StoreUtil", "getStateSpec"));
        }
        do {
            State stateSpec;
            if ((stateSpec = aClass.getAnnotation(State.class)) == null) continue;
            return stateSpec;
        } while ((aClass = aClass.getSuperclass()) != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ReloadComponentStoreStatus reloadStore(@NotNull Set<StateStorage> changes, @NotNull IComponentStore store) {
        Collection<String> notReloadableComponents;
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/components/impl/stores/StoreUtil", "reloadStore"));
        }
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/StoreUtil", "reloadStore"));
        }
        boolean willBeReloaded = false;
        AccessToken token = WriteAction.start();
        try {
            notReloadableComponents = store.reload(changes);
        }
        catch (Throwable e) {
            ReloadComponentStoreStatus reloadComponentStoreStatus;
            block16: {
                try {
                    LOG.warn(e);
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                    if (willBeReloaded) break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    token.finish();
                }
                for (StateStorage storage2 : changes) {
                    if (!(storage2 instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage2).enableSaving();
                }
            }
            ReloadComponentStoreStatus reloadComponentStoreStatus2 = reloadComponentStoreStatus;
            if (reloadComponentStoreStatus2 != null) return reloadComponentStoreStatus2;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StoreUtil", "reloadStore"));
        }
        token.finish();
        if (ContainerUtil.isEmpty(notReloadableComponents)) {
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            ReloadComponentStoreStatus reloadComponentStoreStatus3 = reloadComponentStoreStatus;
            if (reloadComponentStoreStatus3 != null) return reloadComponentStoreStatus3;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StoreUtil", "reloadStore"));
        }
        willBeReloaded = StoreUtil.askToRestart(store, notReloadableComponents, changes);
        ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
        ReloadComponentStoreStatus reloadComponentStoreStatus4 = reloadComponentStoreStatus;
        if (reloadComponentStoreStatus4 != null) return reloadComponentStoreStatus4;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StoreUtil", "reloadStore"));
        finally {
            if (!willBeReloaded) {
                for (StateStorage storage3 : changes) {
                    if (!(storage3 instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage3).enableSaving();
                }
            }
        }
    }

    public static boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<StateStorage> changedStorages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/StoreUtil", "askToRestart"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/StoreUtil", "askToRestart"));
        }
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project" : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String component : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(component).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (store instanceof IProjectStore) {
            message.append("reload project?");
        } else {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage storage2 : changedStorages) {
                    if (!(storage2 instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage2).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    public static enum ReloadComponentStoreStatus {
        RESTART_AGREED,
        RESTART_CANCELLED,
        ERROR,
        SUCCESS;

    }
}

