/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaSdkUtil {
    @NonNls
    public static final String IDEA_PREPEND_RTJAR = "idea.prepend.rtjar";

    public static void addRtJar(PathsList pathsList) {
        String ideaRtJarPath = JavaSdkUtil.getIdeaRtJarPath();
        if (Boolean.getBoolean(IDEA_PREPEND_RTJAR)) {
            pathsList.addFirst(ideaRtJarPath);
        } else {
            pathsList.addTail(ideaRtJarPath);
        }
    }

    public static String getJunit4JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.junit.Test"));
    }

    public static String getJunit3JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"junit.runner.TestSuiteLoader"));
    }

    public static String getIdeaRtJarPath() {
        return PathUtil.getJarPathForClass(JavacRunner.class);
    }

    @NotNull
    public static List<String> getJUnit4JarPaths() {
        List<String> list = Arrays.asList(JavaSdkUtil.getJunit4JarPath(), PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.hamcrest.Matcher")), PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.hamcrest.Matchers")));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "getJUnit4JarPaths"));
        }
        return list;
    }
}

