/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater");
    private final Project myProject;
    private final FilePropertyPusher[] myPushers;
    private final FilePropertyPusher[] myFilePushers;
    private final Queue<Runnable> myTasks = new ConcurrentLinkedQueue<Runnable>();
    private final MessageBusConnection myConnection;

    public PushedFilePropertiesUpdaterImpl(final Project project) {
        this.myProject = project;
        this.myPushers = (FilePropertyPusher[])Extensions.getExtensions((ExtensionPointName)FilePropertyPusher.EP_NAME);
        this.myFilePushers = (FilePropertyPusher[])ContainerUtil.findAllAsArray((Object[])this.myPushers, (Condition)new Condition<FilePropertyPusher>(){

            public boolean value(FilePropertyPusher pusher) {
                return !pusher.pushDirectoriesOnly();
            }
        });
        this.myConnection = project.getMessageBus().connect();
        StartupManager.getInstance((Project)project).registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                PushedFilePropertiesUpdaterImpl.this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                    public void rootsChanged(ModuleRootEvent event) {
                        for (FilePropertyPusher pusher : PushedFilePropertiesUpdaterImpl.this.myPushers) {
                            pusher.afterRootsChanged(project);
                        }
                    }
                });
                PushedFilePropertiesUpdaterImpl.this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

                    public void after(@NotNull List<? extends VFileEvent> events) {
                        if (events == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$2$2", "after"));
                        }
                        ArrayList delayedTasks = ContainerUtil.newArrayList();
                        for (VFileEvent vFileEvent : events) {
                            FilePropertyPusher[] pushers;
                            VirtualFile file = vFileEvent.getFile();
                            if (file == null || (pushers = file.isDirectory() ? PushedFilePropertiesUpdaterImpl.this.myPushers : PushedFilePropertiesUpdaterImpl.this.myFilePushers).length == 0) continue;
                            if (vFileEvent instanceof VFileCreateEvent) {
                                if (!vFileEvent.isFromRefresh() || !file.isDirectory()) {
                                    PushedFilePropertiesUpdaterImpl.this.doPushRecursively(file, pushers, ProjectRootManager.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).getFileIndex());
                                    continue;
                                }
                                if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file)) continue;
                                ContainerUtil.addIfNotNull((Collection)delayedTasks, (Object)PushedFilePropertiesUpdaterImpl.this.createRecursivePushTask(file, pushers));
                                continue;
                            }
                            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                            for (FilePropertyPusher pusher : pushers) {
                                file.putUserData(pusher.getFileDataKey(), null);
                            }
                            PushedFilePropertiesUpdaterImpl.this.doPushRecursively(file, pushers, ProjectRootManager.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).getFileIndex());
                        }
                        if (!delayedTasks.isEmpty()) {
                            PushedFilePropertiesUpdaterImpl.this.queueTasks(delayedTasks);
                        }
                    }
                });
            }
        });
    }

    public void initializeProperties() {
        for (final FilePropertyPusher pusher : this.myPushers) {
            pusher.initExtra(this.myProject, this.myProject.getMessageBus(), new FilePropertyPusher.Engine(){

                public void pushAll() {
                    PushedFilePropertiesUpdaterImpl.this.pushAll(pusher);
                }

                public void pushRecursively(VirtualFile file, Project project) {
                    PushedFilePropertiesUpdaterImpl.this.queueTasks(ContainerUtil.createMaybeSingletonList((Object)PushedFilePropertiesUpdaterImpl.this.createRecursivePushTask(file, new FilePropertyPusher[]{pusher})));
                }
            });
        }
    }

    public void pushAllPropertiesNow() {
        this.performPushTasks();
        this.doPushAll(this.myPushers);
    }

    @Nullable
    private Runnable createRecursivePushTask(final VirtualFile dir, final FilePropertyPusher[] pushers) {
        if (pushers.length == 0) {
            return null;
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (!fileIndex.isInContent(dir)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                PushedFilePropertiesUpdaterImpl.this.doPushRecursively(dir, pushers, fileIndex);
            }
        };
    }

    private void doPushRecursively(VirtualFile dir, final FilePropertyPusher[] pushers, ProjectFileIndex fileIndex) {
        fileIndex.iterateContentUnderDirectory(dir, new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                PushedFilePropertiesUpdaterImpl.this.applyPushersToFile(fileOrDir, pushers, null);
                return true;
            }
        });
    }

    private void queueTasks(List<? extends Runnable> actions2) {
        for (Runnable runnable : actions2) {
            this.myTasks.offer(runnable);
        }
        final DumbModeTask task = new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$6", "performInDumbMode"));
                }
                PushedFilePropertiesUpdaterImpl.this.performPushTasks();
            }
        };
        this.myProject.getMessageBus().connect((Disposable)task).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                DumbService.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task);
            }
        });
        DumbService.getInstance((Project)this.myProject).queueTask(task);
    }

    private void performPushTasks() {
        Runnable task;
        boolean hadTasks = false;
        while ((task = this.myTasks.poll()) != null) {
            hadTasks = true;
            task.run();
        }
        if (hadTasks && !this.myProject.isDisposed() && (task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject)) != null) {
            DumbService.getInstance((Project)this.myProject).queueTask((DumbModeTask)task);
        }
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<T> pusher, T moduleValue) {
        Object value = pusher.getImmediateValue(project, dir);
        if (value != null) {
            return (T)value;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            return PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(project, parent, pusher);
        }
        Object projectValue = pusher.getImmediateValue(project, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    private static <T> T findPusherValuesUpwards(Project project, VirtualFile dir, FilePropertyPusher<T> pusher) {
        Object userValue = dir.getUserData(pusher.getFileDataKey());
        if (userValue != null) {
            return (T)userValue;
        }
        Object value = pusher.getImmediateValue(project, dir);
        if (value != null) {
            return (T)value;
        }
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            return PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(project, parent, pusher);
        }
        Object projectValue = pusher.getImmediateValue(project, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    public void pushAll(final FilePropertyPusher ... pushers) {
        this.queueTasks(Collections.singletonList(new Runnable(){

            @Override
            public void run() {
                PushedFilePropertiesUpdaterImpl.this.doPushAll(pushers);
            }
        }));
    }

    private void doPushAll(final FilePropertyPusher[] pushers) {
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleManager.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).getModules();
            }
        });
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (final Module module : modules) {
            Runnable iteration = (Runnable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Runnable>(){

                public Runnable compute() {
                    if (module.isDisposed()) {
                        return EmptyRunnable.INSTANCE;
                    }
                    ProgressManager.checkCanceled();
                    final Object[] moduleValues = new Object[pushers.length];
                    for (int i = 0; i < moduleValues.length; ++i) {
                        moduleValues[i] = pushers[i].getImmediateValue(module);
                    }
                    final ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                    return new Runnable(){

                        @Override
                        public void run() {
                            fileIndex.iterateContent(new ContentIterator(){

                                public boolean processFile(VirtualFile fileOrDir) {
                                    PushedFilePropertiesUpdaterImpl.this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                                    return true;
                                }
                            });
                        }
                    };
                }
            });
            tasks.add(iteration);
        }
        PushedFilePropertiesUpdaterImpl.invoke2xConcurrentlyIfPossible(tasks);
    }

    public static void invoke2xConcurrentlyIfPossible(List<Runnable> tasks) {
        Runnable runnable;
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed() || !Registry.is((String)"idea.concurrent.scanning.files.to.index")) {
            for (Runnable r : tasks) {
                r.run();
            }
            return;
        }
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        final ConcurrentLinkedQueue<Runnable> tasksQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        Future result = null;
        if (tasks.size() > 1) {
            result = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            Runnable runnable;
                            while ((runnable = (Runnable)tasksQueue.poll()) != null) {
                                runnable.run();
                            }
                        }
                    }, (ProgressIndicator)ProgressWrapper.wrap(progress));
                }
            });
        }
        while ((runnable = tasksQueue.poll()) != null) {
            runnable.run();
        }
        if (result != null) {
            try {
                result.get();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    private void applyPushersToFile(final VirtualFile fileOrDir, final FilePropertyPusher[] pushers, final Object[] moduleValues) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ProgressManager.checkCanceled();
                if (!fileOrDir.isValid()) {
                    return;
                }
                PushedFilePropertiesUpdaterImpl.this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
            }
        });
    }

    private void doApplyPushersToFile(VirtualFile fileOrDir, FilePropertyPusher[] pushers, Object[] moduleValues) {
        Object pusher = null;
        try {
            boolean isDir = fileOrDir.isDirectory();
            int pushersLength = pushers.length;
            for (int i = 0; i < pushersLength; ++i) {
                pusher = pushers[i];
                if (!isDir && (pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir)) || isDir && !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
                this.findAndUpdateValue(fileOrDir, (FilePropertyPusher)pusher, (Object)(moduleValues != null ? moduleValues[i] : null));
            }
        }
        catch (AbstractMethodError ame) {
            if (pusher != null) {
                throw new ExtensionException(pusher.getClass());
            }
            throw ame;
        }
    }

    public <T> void findAndUpdateValue(VirtualFile fileOrDir, FilePropertyPusher<T> pusher, T moduleValue) {
        T value = PushedFilePropertiesUpdaterImpl.findPusherValuesUpwards(this.myProject, fileOrDir, pusher, moduleValue);
        PushedFilePropertiesUpdaterImpl.updateValue(this.myProject, fileOrDir, value, pusher);
    }

    private static <T> void updateValue(Project project, VirtualFile fileOrDir, T value, FilePropertyPusher<T> pusher) {
        Object oldValue = fileOrDir.getUserData(pusher.getFileDataKey());
        if (value != oldValue) {
            fileOrDir.putUserData(pusher.getFileDataKey(), value);
            try {
                pusher.persistAttribute(project, fileOrDir, value);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl", "filePropertiesChanged"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex.getInstance().requestReindex(file);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file, project);
        }
    }

    private static void reloadPsi(final VirtualFile file, final Project project) {
        final FileManagerImpl fileManager = (FileManagerImpl)((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager();
        if (fileManager.findCachedViewProvider(file) != null) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            fileManager.forceReload(file);
                        }
                    });
                }
            });
        }
    }

    public void processPendingEvents() {
        this.myConnection.deliverImmediately();
    }
}

