/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectJdksConfigurable
extends MasterDetailsComponent {
    private final ProjectSdksModel myProjectJdksModel;
    private final Project myProject;

    public ProjectJdksConfigurable(Project project) {
        this(project, ProjectStructureConfigurable.getInstance(project).getProjectJdksModel());
    }

    public ProjectJdksConfigurable(Project project, ProjectSdksModel sdksModel) {
        this.myProject = project;
        this.myProjectJdksModel = sdksModel;
        this.initTree();
        this.myToReInitWholePanel = true;
        this.reInitWholePanelIfNeeded();
    }

    protected String getComponentStateKey() {
        return "ProjectJDKs.UI";
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath treePath) {
                return ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName();
            }
        }, true);
        this.myTree.setRootVisible(false);
    }

    public void reset() {
        super.reset();
        this.myProjectJdksModel.reset(this.myProject);
        this.myRoot.removeAllChildren();
        HashMap<Sdk, Sdk> sdks = this.myProjectJdksModel.getProjectSdks();
        for (Sdk sdk : sdks.keySet()) {
            JdkConfigurable configurable = new JdkConfigurable((ProjectJdkImpl)((Object)sdks.get(sdk)), this.myProjectJdksModel, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
        }
        this.selectJdk(this.myProjectJdksModel.getProjectSdk());
        JBSplitter splitter = this.extractSplitter();
        if (splitter != null) {
            splitter.setAndLoadSplitterProportionKey("project.jdk.splitter");
        }
    }

    @Nullable
    private JBSplitter extractSplitter() {
        Component[] components = this.myWholePanel.getComponents();
        return components.length == 1 && components[0] instanceof JBSplitter ? (JBSplitter)components[0] : null;
    }

    public void apply() throws ConfigurationException {
        final Ref exceptionRef = Ref.create();
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectJdksConfigurable.super.apply();
                    boolean modifiedJdks = false;
                    for (int i = 0; i < ProjectJdksConfigurable.this.myRoot.getChildCount(); ++i) {
                        NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)ProjectJdksConfigurable.this.myRoot.getChildAt(i)).getConfigurable();
                        if (!configurable.isModified()) continue;
                        configurable.apply();
                        modifiedJdks = true;
                    }
                    if (ProjectJdksConfigurable.this.myProjectJdksModel.isModified() || modifiedJdks) {
                        ProjectJdksConfigurable.this.myProjectJdksModel.apply(ProjectJdksConfigurable.this);
                    }
                    ProjectJdksConfigurable.this.myProjectJdksModel.setProjectSdk(ProjectJdksConfigurable.this.getSelectedJdk());
                }
                catch (ConfigurationException e) {
                    exceptionRef.set((Object)e);
                }
            }
        });
        if (!exceptionRef.isNull()) {
            throw (ConfigurationException)((Object)exceptionRef.get());
        }
    }

    public boolean isModified() {
        return super.isModified() || this.myProjectJdksModel.isModified();
    }

    public void disposeUIResources() {
        this.myProjectJdksModel.disposeUIResources();
        super.disposeUIResources();
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        if (this.myProjectJdksModel == null) {
            return null;
        }
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        DefaultActionGroup group = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
        group.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        this.myProjectJdksModel.createAddActions(group, (JComponent)this.myTree, new Consumer<Sdk>(){

            public void consume(Sdk projectJdk) {
                ProjectJdksConfigurable.this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)projectJdk, ProjectJdksConfigurable.this.myProjectJdksModel, ProjectJdksConfigurable.this.TREE_UPDATER, ProjectJdksConfigurable.this.myHistory, ProjectJdksConfigurable.this.myProject), false), ProjectJdksConfigurable.this.myRoot);
                ProjectJdksConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)MasterDetailsComponent.findNodeByObject((TreeNode)ProjectJdksConfigurable.this.myRoot, (Object)projectJdk));
            }
        });
        actions2.add((AnAction)new MasterDetailsComponent.MyActionGroupWrapper((MasterDetailsComponent)this, (ActionGroup)group));
        actions2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, Conditions.alwaysTrue()));
        return actions2;
    }

    protected void processRemovedItems() {
        HashSet<Sdk> jdks = new HashSet<Sdk>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            NamedConfigurable namedConfigurable = (NamedConfigurable)node.getUserObject();
            jdks.add(((JdkConfigurable)namedConfigurable).getEditableObject());
        }
        HashMap<Sdk, Sdk> sdks = new HashMap<Sdk, Sdk>(this.myProjectJdksModel.getProjectSdks());
        for (Sdk sdk : sdks.values()) {
            if (jdks.contains(sdk)) continue;
            this.myProjectJdksModel.removeSdk(sdk);
        }
    }

    protected boolean wasObjectStored(Object editableObject) {
        return this.myProjectJdksModel.getProjectSdks().containsKey((Sdk)editableObject);
    }

    @Nullable
    public Sdk getSelectedJdk() {
        return (Sdk)this.getSelectedObject();
    }

    public void selectJdk(Sdk projectJdk) {
        this.selectNodeInTree(projectJdk);
    }

    @Nullable
    public String getDisplayName() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select an SDK to view or edit its details here";
    }
}

