/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDataImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyFileSystem
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    @NonNls
    public static final String PROTOCOL = "dummy";
    private VirtualFileDirectoryImpl myRoot;

    public static DummyFileSystem getInstance() {
        return (DummyFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DummyFileSystem() {
        this.startEventPropagation();
    }

    public VirtualFile createRoot(String name) {
        this.myRoot = new VirtualFileDirectoryImpl(this, null, name);
        this.fireFileCreated(null, this.myRoot);
        return this.myRoot;
    }

    @Nullable
    public VirtualFile findById(int id) {
        return DummyFileSystem.findById(id, this.myRoot);
    }

    @Nullable
    private static VirtualFile findById(int id, VirtualFileImpl r) {
        if (r == null) {
            return null;
        }
        if (r.getId() == id) {
            return r;
        }
        VirtualFile[] children = r.getChildren();
        if (children != null) {
            for (VirtualFile f : children) {
                VirtualFile child = DummyFileSystem.findById(id, (VirtualFileImpl)f);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "findFileByPath"));
        }
        return null;
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "extractPresentableUrl"));
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "extractPresentableUrl"));
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "deleteFile"));
        }
        this.fireBeforeFileDeletion(requestor, vFile);
        VirtualFileDirectoryImpl parent = (VirtualFileDirectoryImpl)vFile.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"file.delete.root.error", (Object[])new Object[]{vFile.getPresentableUrl()}));
        }
        parent.removeChild((VirtualFileImpl)vFile);
        this.fireFileDeleted(requestor, vFile, vFile.getName(), parent);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "renameFile"));
        }
        String oldName = vFile.getName();
        this.fireBeforePropertyChange(requestor, vFile, "name", oldName, newName);
        ((VirtualFileImpl)vFile).setName(newName);
        this.firePropertyChanged(requestor, vFile, "name", oldName, newName);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "createChildFile"));
        }
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDataImpl child = new VirtualFileDataImpl(this, dir, fileName);
        dir.addChild(child);
        this.fireFileCreated(requestor, child);
        VirtualFileDataImpl virtualFileDataImpl = child;
        if (virtualFileDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "createChildFile"));
        }
        return virtualFileDataImpl;
    }

    public void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "fireBeforeContentsChange"));
        }
        super.fireBeforeContentsChange(requestor, file);
    }

    public void fireContentsChanged(Object requestor, @NotNull VirtualFile file, long oldModificationStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "fireContentsChanged"));
        }
        super.fireContentsChanged(requestor, file, oldModificationStamp);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "createChildDirectory"));
        }
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDirectoryImpl child = new VirtualFileDirectoryImpl(this, dir, dirName);
        dir.addChild(child);
        this.fireFileCreated(requestor, child);
        VirtualFileDirectoryImpl virtualFileDirectoryImpl = child;
        if (virtualFileDirectoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem", "createChildDirectory"));
        }
        return virtualFileDirectoryImpl;
    }
}

