/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker");
    private final boolean myIsRecursive;
    private final Queue<Pair<NewVirtualFile, FileAttributes>> myRefreshQueue;
    private final List<VFileEvent> myEvents;
    private volatile boolean myCancelled;
    private static Function<VirtualFile, Boolean> ourCancellingCondition = null;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refreshRoot", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "<init>"));
        }
        this.myRefreshQueue = new Queue(100);
        this.myEvents = new ArrayList<VFileEvent>();
        this.myCancelled = false;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)Pair.create((Object)refreshRoot, (Object)null));
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        List<VFileEvent> list = this.myEvents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "getEvents"));
        }
        return list;
    }

    public void cancel() {
        this.myCancelled = true;
    }

    public void scan() {
        NewVirtualFile root = (NewVirtualFile)((Pair)this.myRefreshQueue.pullFirst()).first;
        boolean rootDirty = root.isDirty();
        LogUtil.debug((Logger)LOG, (String)"root=%s dirty=%b", (Object[])new Object[]{root, rootDirty});
        if (!rootDirty) {
            return;
        }
        NewVirtualFileSystem fs = root.getFileSystem();
        FileAttributes rootAttributes = fs.getAttributes((VirtualFile)root);
        if (rootAttributes == null) {
            this.scheduleDeletion((VirtualFile)root);
            root.markClean();
            return;
        }
        if (rootAttributes.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        this.myRefreshQueue.addLast((Object)Pair.pair((Object)root, (Object)rootAttributes));
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            LOG.debug("refresh cancelled");
        }
    }

    private void processQueue(NewVirtualFileSystem fs, PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            boolean upToDateHidden;
            boolean currentHidden;
            FileAttributes attributes;
            Pair pair = (Pair)this.myRefreshQueue.pullFirst();
            NewVirtualFile file = (NewVirtualFile)pair.first;
            boolean fileDirty = file.isDirty();
            LogUtil.debug((Logger)LOG, (String)"file=%s dirty=%b", (Object[])new Object[]{file, fileDirty});
            if (!fileDirty) continue;
            this.checkCancelled(file);
            FileAttributes fileAttributes = attributes = pair.second != null ? (FileAttributes)pair.second : fs.getAttributes((VirtualFile)file);
            if (attributes == null) {
                this.scheduleDeletion((VirtualFile)file);
                continue;
            }
            NewVirtualFile parent = file.getParent();
            if (parent != null && this.checkAndScheduleFileTypeChange((VirtualFile)parent, (VirtualFile)file, attributes)) {
                file.markClean();
                continue;
            }
            if (file.isDirectory()) {
                boolean fullSync = ((VirtualDirectoryImpl)file).allChildrenLoaded();
                if (fullSync) {
                    this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file);
                } else {
                    this.partialDirRefresh(fs, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file);
                }
            } else {
                long currentTimestamp = persistence.getTimeStamp((VirtualFile)file);
                long upToDateTimestamp = attributes.lastModified;
                long currentLength = persistence.getLength((VirtualFile)file);
                long upToDateLength = attributes.length;
                if (currentTimestamp != upToDateTimestamp || currentLength != upToDateLength) {
                    this.scheduleUpdateContent((VirtualFile)file);
                }
            }
            boolean currentWritable = persistence.isWritable((VirtualFile)file);
            boolean upToDateWritable = attributes.isWritable();
            if (currentWritable != upToDateWritable) {
                this.scheduleAttributeChange((VirtualFile)file, "writable", currentWritable, upToDateWritable);
            }
            if (SystemInfo.isWindows && (currentHidden = file.is(VFileProperty.HIDDEN)) != (upToDateHidden = attributes.isHidden())) {
                this.scheduleAttributeChange((VirtualFile)file, VirtualFile.PROP_HIDDEN, currentHidden, upToDateHidden);
            }
            if (attributes.isSymLink()) {
                String upToDateVfsTarget;
                String currentTarget = file.getCanonicalPath();
                String upToDateTarget = fs.resolveSymLink((VirtualFile)file);
                String string = upToDateVfsTarget = upToDateTarget != null ? FileUtil.toSystemIndependentName((String)upToDateTarget) : null;
                if (!Comparing.equal((String)currentTarget, (String)upToDateVfsTarget)) {
                    this.scheduleAttributeChange((VirtualFile)file, "symlink", currentTarget, upToDateVfsTarget);
                }
            }
            if (!this.myIsRecursive && file.isDirectory()) continue;
            file.markClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullDirRefresh(NewVirtualFileSystem fs, PersistentFS persistence, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            Object[] children;
            Object[] currentNames;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                currentNames = persistence.list((VirtualFile)dir);
                children = dir.getChildren();
            }
            finally {
                token.finish();
            }
            Object[] upToDateNames = VfsUtil.filterNames((String[])fs.list((VirtualFile)dir));
            THashSet newNames = ContainerUtil.newTroveSet(strategy, (Object[])upToDateNames);
            ContainerUtil.removeAll((Collection)newNames, (Object[])currentNames);
            THashSet deletedNames = ContainerUtil.newTroveSet(strategy, (Object[])currentNames);
            ContainerUtil.removeAll((Collection)deletedNames, (Object[])upToDateNames);
            OpenTHashSet actualNames = null;
            if (!fs.isCaseSensitive()) {
                actualNames = new OpenTHashSet(strategy, upToDateNames);
            }
            LogUtil.debug((Logger)LOG, (String)"current=%s +%s -%s", (Object[])new Object[]{currentNames, newNames, deletedNames});
            ArrayList addedMap = ContainerUtil.newArrayListWithCapacity((int)newNames.size());
            for (String name : newNames) {
                this.checkCancelled(dir);
                addedMap.add(Pair.pair((Object)name, (Object)fs.getAttributes((VirtualFile)new FakeVirtualFile((VirtualFile)dir, name))));
            }
            ArrayList updatedMap = ContainerUtil.newArrayListWithCapacity((int)(children.length - deletedNames.size()));
            for (VirtualFile virtualFile : children) {
                if (deletedNames.contains(virtualFile.getName())) continue;
                this.checkCancelled(dir);
                updatedMap.add(Pair.pair((Object)virtualFile, (Object)fs.getAttributes(virtualFile)));
            }
            token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                if (!Arrays.equals(currentNames, persistence.list((VirtualFile)dir)) || !Arrays.equals(children, dir.getChildren())) {
                    LOG.debug("retry");
                    continue;
                }
                for (String name : deletedNames) {
                    this.scheduleDeletion((VirtualFile)dir.findChild(name));
                }
                for (Pair pair : addedMap) {
                    String name = (String)pair.first;
                    FileAttributes fileAttributes = (FileAttributes)pair.second;
                    if (fileAttributes != null) {
                        this.scheduleCreation((VirtualFile)dir, name, fileAttributes.isDirectory(), false);
                        continue;
                    }
                    LOG.warn("[+] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + name);
                }
                for (Pair pair : updatedMap) {
                    VirtualFile child = (VirtualFile)pair.first;
                    FileAttributes fileAttributes = (FileAttributes)pair.second;
                    if (fileAttributes != null) {
                        this.checkAndScheduleChildRefresh((VirtualFile)dir, child, fileAttributes);
                        this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child);
                        continue;
                    }
                    LOG.warn("[x] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + child.getName());
                    this.scheduleDeletion(child);
                }
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partialDirRefresh(NewVirtualFileSystem fs, TObjectHashingStrategy<String> strategy, VirtualDirectoryImpl dir) {
        while (true) {
            List<String> wanted;
            Collection cached;
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                cached = dir.getCachedChildren();
                wanted = dir.getSuspiciousNames();
            }
            finally {
                token.finish();
            }
            OpenTHashSet actualNames = null;
            if (!fs.isCaseSensitive()) {
                actualNames = new OpenTHashSet(strategy, (Object[])VfsUtil.filterNames((String[])fs.list((VirtualFile)dir)));
            }
            LogUtil.debug((Logger)LOG, (String)"cached=%s actual=%s", (Object[])new Object[]{cached, actualNames});
            LogUtil.debug((Logger)LOG, (String)"suspicious=%s", (Object[])new Object[]{wanted});
            ArrayList existingMap = ContainerUtil.newArrayListWithCapacity((int)cached.size());
            for (VirtualFile child : cached) {
                this.checkCancelled(dir);
                existingMap.add(Pair.pair((Object)child, (Object)fs.getAttributes(child)));
            }
            ArrayList wantedMap = ContainerUtil.newArrayListWithCapacity((int)wanted.size());
            for (String name : wanted) {
                if (name.isEmpty()) continue;
                this.checkCancelled(dir);
                wantedMap.add(Pair.pair((Object)name, (Object)fs.getAttributes((VirtualFile)new FakeVirtualFile((VirtualFile)dir, name))));
            }
            token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                FileAttributes childAttributes;
                if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                    LOG.debug("retry");
                    continue;
                }
                for (Pair pair : existingMap) {
                    VirtualFile child = (VirtualFile)pair.first;
                    childAttributes = (FileAttributes)pair.second;
                    if (childAttributes != null) {
                        this.checkAndScheduleChildRefresh((VirtualFile)dir, child, childAttributes);
                        this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, child);
                        continue;
                    }
                    this.scheduleDeletion(child);
                }
                for (Pair pair : wantedMap) {
                    String name = (String)pair.first;
                    childAttributes = (FileAttributes)pair.second;
                    if (childAttributes == null) continue;
                    this.scheduleCreation((VirtualFile)dir, name, childAttributes.isDirectory(), false);
                }
            }
            finally {
                token.finish();
                continue;
            }
            break;
        }
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, VirtualFile child) {
        String currentName;
        String actualName;
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child.getName()))) != null && !currentName.equals(actualName)) {
            this.scheduleAttributeChange(child, "name", currentName, actualName);
        }
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (stopAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkCancelled"));
        }
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)((Pair)this.myRefreshQueue.pullFirst()).first;
                RefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(NewVirtualFile file) {
        file.markClean();
        file.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull VirtualFile parent, @NotNull VirtualFile child, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (childAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childAttributes", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleChildRefresh"));
        }
        if (!this.checkAndScheduleFileTypeChange(parent, child, childAttributes)) {
            boolean upToDateIsDirectory = childAttributes.isDirectory();
            if (this.myIsRecursive || !upToDateIsDirectory) {
                this.myRefreshQueue.addLast((Object)Pair.create((Object)((NewVirtualFile)child), (Object)childAttributes));
            }
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull VirtualFile parent, @NotNull VirtualFile child, @NotNull FileAttributes childAttributes) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        if (childAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childAttributes", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "checkAndScheduleFileTypeChange"));
        }
        boolean currentIsDirectory = child.isDirectory();
        boolean currentIsSymlink = child.is(VFileProperty.SYMLINK);
        boolean currentIsSpecial = child.is(VFileProperty.SPECIAL);
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.scheduleDeletion(child);
            this.scheduleCreation(parent, child.getName(), upToDateIsDirectory, true);
            return true;
        }
        return false;
    }

    private void scheduleAttributeChange(@NotNull VirtualFile file, @NotNull String property, Object current, Object upToDate) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleAttributeChange"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleAttributeChange"));
        }
        LogUtil.debug((Logger)LOG, (String)"update '%s' file=%s", (Object[])new Object[]{property, file});
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file, property, current, upToDate, true));
    }

    private void scheduleUpdateContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleUpdateContent"));
        }
        LogUtil.debug((Logger)LOG, (String)"update file=%s", (Object[])new Object[]{file});
        this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, file, file.getModificationStamp(), -1L, true));
    }

    private void scheduleCreation(@NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, boolean isReCreation) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleCreation"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker", "scheduleCreation"));
        }
        LogUtil.debug((Logger)LOG, (String)"create parent=%s name=%s dir=%b", (Object[])new Object[]{parent, childName, isDirectory});
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, isDirectory, true, isReCreation));
    }

    private void scheduleDeletion(@Nullable VirtualFile file) {
        if (file != null) {
            LogUtil.debug((Logger)LOG, (String)"delete file=%s", (Object[])new Object[]{file});
            this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file, true));
        }
    }

    public static void setCancellingCondition(@Nullable Function<VirtualFile, Boolean> condition) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourCancellingCondition = condition;
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }
}

