/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/formatter/java/JavaLineWrapPositionStrategy", "canUseOffset"));
        }
        CharSequence chars = document.getCharsSequence();
        char charAtOffset = chars.charAt(offset);
        if (charAtOffset == '.' && (offset > 0 && chars.charAt(offset - 1) == '.' || offset + 1 < chars.length() && chars.charAt(offset + 1) == '.')) {
            return false;
        }
        return !JavaLineWrapPositionStrategy.isInsideJDLinkTag(document, offset) && !JavaLineWrapPositionStrategy.isInsideHrefTag(document, offset);
    }

    private static boolean isInsideHrefTag(Document document, int offset) {
        return JavaLineWrapPositionStrategy.isInsideTag(document, offset, "<a", ">");
    }

    private static boolean isInsideJDLinkTag(Document document, int offset) {
        return JavaLineWrapPositionStrategy.isInsideTag(document, offset, "{@link", "}");
    }

    private static boolean isInsideTag(Document document, int offset, String tagStart, String tagEnd) {
        CharSequence sequence = document.getCharsSequence();
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        return CharArrayUtil.indexOf((CharSequence)sequence, (CharSequence)tagStart, (int)lineStartOffset, (int)offset) > 0 && CharArrayUtil.indexOf((CharSequence)sequence, (CharSequence)tagEnd, (int)offset, (int)lineEndOffset) > 0;
    }
}

