/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResolveScopeManagerImpl
extends ResolveScopeManager {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<VirtualFile, GlobalSearchScope> myDefaultResolveScopesCache = new ConcurrentFactoryMap<VirtualFile, GlobalSearchScope>(){

        protected GlobalSearchScope create(@NotNull VirtualFile key) {
            ResolveScopeProvider resolveScopeProvider;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl$1", "create"));
            }
            GlobalSearchScope scope = null;
            Object[] objectArray = (ResolveScopeProvider[])ResolveScopeProvider.EP_NAME.getExtensions();
            int n = objectArray.length;
            for (int i = 0; i < n && (scope = (resolveScopeProvider = objectArray[i]).getResolveScope(key, ResolveScopeManagerImpl.this.myProject)) == null; ++i) {
            }
            if (scope == null) {
                scope = ResolveScopeManagerImpl.this.getInherentResolveScope(key);
            }
            for (ResolveScopeEnlarger enlarger : (ResolveScopeEnlarger[])ResolveScopeEnlarger.EP_NAME.getExtensions()) {
                SearchScope extra = enlarger.getAdditionalResolveScope(key, ResolveScopeManagerImpl.this.myProject);
                if (extra == null) continue;
                scope = scope.union(extra);
            }
            return scope;
        }
    };

    public ResolveScopeManagerImpl(Project project, ProjectRootManager projectRootManager, PsiManager psiManager) {
        this.myProject = project;
        this.myProjectRootManager = projectRootManager;
        this.myManager = psiManager;
        ((PsiManagerImpl)psiManager).registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                ResolveScopeManagerImpl.this.myDefaultResolveScopesCache.clear();
            }
        });
    }

    private GlobalSearchScope getResolveScopeFromProviders(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScopeFromProviders"));
        }
        return this.myDefaultResolveScopesCache.get(vFile);
    }

    private GlobalSearchScope getInherentResolveScope(VirtualFile vFile) {
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean includeTests = projectFileIndex.isInTestSourceContent(vFile);
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        }
        if (!projectFileIndex.isInLibrarySource(vFile) && !projectFileIndex.isInLibraryClasses(vFile)) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        return LibraryScopeCache.getInstance(this.myProject).getLibraryScope(projectFileIndex.getOrderEntriesForFile(vFile));
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        PsiFile contextFile;
        VirtualFile vFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
            contextFile = null;
        } else {
            PsiElement context;
            GlobalSearchScope forcedScope;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof PsiCodeFragment && (forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope()) != null) {
                GlobalSearchScope globalSearchScope = forcedScope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            if (containingFile != null && (context = containingFile.getContext()) != null) {
                GlobalSearchScope globalSearchScope = this.getResolveScope(context);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            contextFile = containingFile;
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            if (contextFile instanceof FileResolveScopeProvider) {
                GlobalSearchScope globalSearchScope = ((FileResolveScopeProvider)contextFile).getFileResolveScope();
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
                }
                return globalSearchScope;
            }
            vFile = contextFile.getOriginalFile().getVirtualFile();
        }
        if (vFile == null || contextFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getResolveScopeFromProviders(vFile);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    public GlobalSearchScope getDefaultResolveScope(VirtualFile vFile) {
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null);
        return this.getResolveScopeFromProviders(vFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        RefResolveService resolveService;
        GlobalSearchScope scope;
        PsiFile containingFile;
        VirtualFile virtualFile;
        VirtualFile vDirectory;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            vDirectory = ((PsiDirectory)element).getVirtualFile();
            virtualFile = null;
            containingFile = null;
        } else {
            containingFile = element.getContainingFile();
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
                }
                return globalSearchScope;
            }
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
                }
                return globalSearchScope;
            }
            vDirectory = virtualFile.getParent();
        }
        if (vDirectory == null) {
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
            }
            return globalSearchScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vDirectory);
        if (module == null) {
            List entries = projectFileIndex.getOrderEntriesForFile(virtualFile != null ? virtualFile : vDirectory);
            GlobalSearchScope result = LibraryScopeCache.getInstance(this.myProject).getLibraryUseScope(entries);
            GlobalSearchScope globalSearchScope = containingFile == null || virtualFile.isDirectory() || result.contains(virtualFile) ? result : GlobalSearchScope.fileScope((PsiFile)containingFile).uniteWith(result);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
            }
            return globalSearchScope;
        }
        boolean isTest = projectFileIndex.isInTestSourceContent(vDirectory);
        GlobalSearchScope globalSearchScope = scope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
        if (virtualFile instanceof VirtualFileWithId && RefResolveService.ENABLED && (resolveService = RefResolveService.getInstance((Project)this.myProject)).isUpToDate()) {
            GlobalSearchScope globalSearchScope2 = resolveService.restrictByBackwardIds(virtualFile, scope);
            if (globalSearchScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
            }
            return globalSearchScope2;
        }
        GlobalSearchScope globalSearchScope3 = scope;
        if (globalSearchScope3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl", "getUseScope"));
        }
        return globalSearchScope3;
    }
}

