/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.annotations.NotNull;

class FileElementInfo
extends SmartPointerElementInfo {
    protected final VirtualFile myVirtualFile;
    protected final Project myProject;
    protected final Language myLanguage;

    public FileElementInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/FileElementInfo", "<init>"));
        }
        this(file.getProject(), file.getVirtualFile(), file.getLanguage());
    }

    protected FileElementInfo(@NotNull Project project, VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/FileElementInfo", "<init>"));
        }
        this(project, virtualFile, null);
    }

    protected FileElementInfo(@NotNull Project project, VirtualFile virtualFile, Language lang) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/FileElementInfo", "<init>"));
        }
        this.myVirtualFile = virtualFile;
        this.myProject = project;
        this.myLanguage = lang;
    }

    @Override
    public PsiElement restoreElement() {
        return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
    }

    @Override
    public PsiFile restoreFile() {
        PsiElement element = this.restoreElement();
        return element == null ? null : element.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/FileElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof FileElementInfo) {
            return Comparing.equal((Object)this.myVirtualFile, (Object)((FileElementInfo)other).myVirtualFile);
        }
        if (other instanceof SelfElementInfo || other instanceof ClsElementInfo) {
            return false;
        }
        return Comparing.equal((Object)this.restoreElement(), (Object)other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        return new TextRange(0, (int)this.myVirtualFile.getLength());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/FileElementInfo", "getProject"));
        }
        return project;
    }
}

