/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterImpl;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.autodetect.DetectedIndentOptionsNotificationProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleManagerImpl
extends CodeStyleManager {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private static final ThreadLocal<ProcessingUnderProgressInfo> SEQUENTIAL_PROCESSING_ALLOWED = new ThreadLocal<ProcessingUnderProgressInfo>(){

        @Override
        protected ProcessingUnderProgressInfo initialValue() {
            return new ProcessingUnderProgressInfo();
        }
    };
    private final FormatterTagHandler myTagHandler;
    private final Project myProject;
    @NonNls
    private static final String DUMMY_IDENTIFIER = "xxx";

    public CodeStyleManagerImpl(Project project) {
        this.myProject = project;
        this.myTagHandler = new FormatterTagHandler(this.getSettings());
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformat"));
        }
        PsiElement psiElement = this.reformat(element, false);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformat"));
        }
        return psiElement;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformat"));
        }
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformat"));
            }
            return psiElement;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree(element);
        PsiElement formatted = SourceTreeToPsiMap.treeElementToPsi(new CodeFormatterFacade(this.getSettings(), element.getLanguage()).processElement(treeElement));
        if (!canChangeWhiteSpacesOnly) {
            PsiElement psiElement = this.postProcessElement(formatted);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformat"));
            }
            return psiElement;
        }
        PsiElement psiElement = formatted;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformat"));
        }
        return psiElement;
    }

    private PsiElement postProcessElement(@NotNull PsiElement formatted) {
        if (formatted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatted", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "postProcessElement"));
        }
        PsiElement result = formatted;
        if (this.getSettings().FORMATTER_TAGS_ENABLED && formatted instanceof PsiFile) {
            this.postProcessEnabledRanges((PsiFile)formatted, formatted.getTextRange(), this.getSettings());
        } else {
            for (PostFormatProcessor postFormatProcessor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
                result = postFormatProcessor.processElement(result, this.getSettings());
            }
        }
        return result;
    }

    private void postProcessText(@NotNull PsiFile file, @NotNull TextRange textRange) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "postProcessText"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "postProcessText"));
        }
        if (!this.getSettings().FORMATTER_TAGS_ENABLED) {
            TextRange currentRange = textRange;
            for (PostFormatProcessor myPostFormatProcessor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
                currentRange = myPostFormatProcessor.processText(file, currentRange, this.getSettings());
            }
        } else {
            this.postProcessEnabledRanges(file, textRange, this.getSettings());
        }
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatRange"));
        }
        return this.reformatRangeImpl(element, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatRange"));
        }
        return this.reformatRangeImpl(element, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file) {
        ((TreeElement)file).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public void reformatText(@NotNull PsiFile file, int startOffset, int endOffset) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        this.reformatText(file, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    public void reformatText(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        this.reformatText(file, ranges, null);
    }

    public void reformatTextWithContext(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatTextWithContext"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatTextWithContext"));
        }
        this.reformatText(file, ranges, null, true);
    }

    public void reformatText(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges, @Nullable Editor editor) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        this.reformatText(file, ranges, editor, false);
    }

    public void reformatText(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges, @Nullable Editor editor, boolean reformatContext) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatText"));
        }
        if (ranges.isEmpty()) {
            return;
        }
        boolean isFullReformat = ranges.size() == 1 && file.getTextRange().equals((Object)ranges.iterator().next());
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        CheckUtil.checkWritable((PsiElement)file);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(this.getSettings(), file.getLanguage());
        codeFormatter.setReformatContext(reformatContext);
        LOG.assertTrue(file.isValid(), (Object)("File name: " + file.getName() + " , class: " + file.getClass().getSimpleName()));
        if (editor == null) {
            editor = PsiUtilBase.findEditor((PsiElement)file);
        }
        CaretPositionKeeper caretKeeper = null;
        if (editor != null) {
            caretKeeper = new CaretPositionKeeper(editor, this.getSettings(), file.getLanguage());
        }
        Collection<TextRange> correctedRanges = FormatterUtil.isFormatterCalledExplicitly() ? this.removeEndingWhiteSpaceFromEachRange(file, ranges) : ranges;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.getProject());
        ArrayList<RangeFormatInfo> infos = new ArrayList<RangeFormatInfo>();
        for (TextRange range : correctedRanges) {
            PsiElement start = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, range.getStartOffset());
            PsiElement end = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, range.getEndOffset());
            if (start != null && !start.isValid()) {
                LOG.error("start=" + start + "; file=" + file);
            }
            if (end != null && !end.isValid()) {
                LOG.error("end=" + start + "; end=" + file);
            }
            boolean formatFromStart = range.getStartOffset() == 0;
            boolean formatToEnd = range.getEndOffset() == file.getTextLength();
            infos.add(new RangeFormatInfo(start == null ? null : smartPointerManager.createSmartPsiElementPointer(start), end == null ? null : smartPointerManager.createSmartPsiElementPointer(end), formatFromStart, formatToEnd));
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        for (TextRange range : correctedRanges) {
            formatRanges.add(range, true);
        }
        codeFormatter.processText(file, formatRanges, true);
        for (RangeFormatInfo info : infos) {
            PsiElement endElement;
            PsiElement startElement = info.startPointer == null ? null : info.startPointer.getElement();
            PsiElement psiElement = endElement = info.endPointer == null ? null : info.endPointer.getElement();
            if ((startElement != null || info.fromStart) && (endElement != null || info.toEnd)) {
                this.postProcessText(file, new TextRange(info.fromStart ? 0 : startElement.getTextRange().getStartOffset(), info.toEnd ? file.getTextLength() : endElement.getTextRange().getEndOffset()));
            }
            if (info.startPointer != null) {
                smartPointerManager.removePointer(info.startPointer);
            }
            if (info.endPointer == null) continue;
            smartPointerManager.removePointer(info.endPointer);
        }
        if (caretKeeper != null) {
            caretKeeper.restoreCaretPosition();
        }
        if (editor instanceof EditorEx && isFullReformat) {
            ((EditorEx)editor).reinitSettings();
            DetectedIndentOptionsNotificationProvider.updateIndentNotification(file, true);
        }
    }

    @NotNull
    private Collection<TextRange> removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file, @NotNull Collection<TextRange> ranges) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "removeEndingWhiteSpaceFromEachRange"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "removeEndingWhiteSpaceFromEachRange"));
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        for (TextRange range : ranges) {
            PsiElement prev;
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            PsiElement lastElementInRange = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, range.getEndOffset());
            if (lastElementInRange instanceof PsiWhiteSpace && rangeStart < lastElementInRange.getTextRange().getStartOffset() && (prev = lastElementInRange.getPrevSibling()) != null) {
                rangeEnd = prev.getTextRange().getEndOffset();
            }
            result.add(new TextRange(rangeStart, rangeEnd));
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "removeEndingWhiteSpaceFromEachRange"));
        }
        return arrayList;
    }

    private PsiElement reformatRangeImpl(PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        LOG.assertTrue(element.isValid());
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            return element;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree(element);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(this.getSettings(), element.getLanguage());
        PsiElement formatted = SourceTreeToPsiMap.treeElementToPsi(codeFormatter.processRange(treeElement, startOffset, endOffset));
        return canChangeWhiteSpacesOnly ? formatted : this.postProcessElement(formatted);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatNewlyAddedElement"));
        }
        if (addedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addedElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "reformatNewlyAddedElement"));
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        TextRange textRange = addedElement.getTextRange();
        Document document = fileViewProvider.getDocument();
        if (document instanceof DocumentWindow) {
            containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
            textRange = ((DocumentWindow)document).injectedToHost(textRange);
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model = CoreFormatterUtil.buildModel(builder, (PsiElement)containingFile, this.getSettings(), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model, this.getSettings(), textRange, containingFile.getFileType());
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    public int adjustLineIndent(final @NotNull PsiFile file, final int offset) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "adjustLineIndent"));
        }
        DetectedIndentOptionsNotificationProvider.updateIndentNotification(file, false);
        return PostprocessReformattingAspect.getInstance(file.getProject()).disablePostprocessFormattingInside(new Computable<Integer>(){

            public Integer compute() {
                return CodeStyleManagerImpl.this.doAdjustLineIndentByOffset(file, offset);
            }
        });
    }

    @Nullable
    static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file, int offset) {
        PsiElement bottomost = file.findElementAt(offset);
        if (bottomost != null && LanguageFormatting.INSTANCE.forContext(bottomost) != null) {
            return bottomost;
        }
        Language fileLang = file.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottomost;
    }

    public int adjustLineIndent(final @NotNull Document document, final int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "adjustLineIndent"));
        }
        return PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(new Computable<Integer>(){

            public Integer compute() {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)CodeStyleManagerImpl.this.myProject);
                documentManager.commitDocument(document);
                PsiFile file = documentManager.getPsiFile(document);
                if (file == null) {
                    return offset;
                }
                return CodeStyleManagerImpl.this.doAdjustLineIndentByOffset(file, offset);
            }
        });
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "doAdjustLineIndentByOffset"));
        }
        return new CodeStyleManagerRunnable<Integer>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Integer doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)offset, (String)" \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result, DocumentWindow documentWindow) {
                return documentWindow.hostToInjected(result.intValue());
            }
        }.perform(file, offset, null, offset);
    }

    public void adjustLineIndent(@NotNull PsiFile file, TextRange rangeToAdjust) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "adjustLineIndent"));
        }
        new CodeStyleManagerRunnable<Object>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range);
                return null;
            }
        }.perform(file, -1, rangeToAdjust, null);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "getLineIndent"));
        }
        return new CodeStyleManagerRunnable<String>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file, offset, null, null);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "getLineIndent"));
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file == null) {
            return "";
        }
        return this.getLineIndent(file, offset);
    }

    public boolean isLineToBeIndented(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "isLineToBeIndented"));
        }
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file)) {
            return false;
        }
        CharSequence chars = file.getViewProvider().getContents();
        int start = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start > 0 && chars.charAt(start) != '\n' && chars.charAt(start) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, end));
        if (element == null) {
            return false;
        }
        if (element.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !this.getSettings().KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element) || IndentHelper.getInstance().getIndent(this.myProject, file.getFileType(), element, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element) {
        Language language = element.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    private static boolean isWhiteSpaceSymbol(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    @Nullable
    public static TextRange insertNewLineIndentMarker(@NotNull PsiFile file, @NotNull Document document, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "insertNewLineIndentMarker"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "insertNewLineIndentMarker"));
        }
        CharSequence text = document.getImmutableCharSequence();
        if (offset <= 0 || offset >= text.length() || !CodeStyleManagerImpl.isWhiteSpaceSymbol(text.charAt(offset))) {
            return null;
        }
        if (!CodeStyleManagerImpl.isWhiteSpaceSymbol(text.charAt(offset - 1))) {
            return null;
        }
        for (int end = offset; end < text.length() && text.charAt(end) != '\n'; ++end) {
            if (CodeStyleManagerImpl.isWhiteSpaceSymbol(text.charAt(end))) continue;
            return null;
        }
        CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
        String dummy = CodeStyleManagerImpl.createDummy(file);
        document.insertString(offset, (CharSequence)dummy);
        return new TextRange(offset, offset + dummy.length());
    }

    @NotNull
    private static String createDummy(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "createDummy"));
        }
        Language language = file.getLanguage();
        PsiComment comment = null;
        try {
            comment = PsiParserFacade.SERVICE.getInstance((Project)file.getProject()).createLineOrBlockCommentFromText(language, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text = comment != null ? comment.getText() : null;
        String string = text != null ? text : DUMMY_IDENTIFIER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "createDummy"));
        }
        return string;
    }

    @Nullable
    public static PsiElement findWhiteSpaceNode(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "findWhiteSpaceNode"));
        }
        return (PsiElement)CodeStyleManagerImpl.doFindWhiteSpaceNode((PsiFile)file, (int)offset).first;
    }

    @NotNull
    private static Pair<PsiElement, CharTable> doFindWhiteSpaceNode(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "doFindWhiteSpaceNode"));
        }
        ASTNode astNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file);
        if (!(astNode instanceof FileElement)) {
            Pair pair = new Pair(null, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "doFindWhiteSpaceNode"));
            }
            return pair;
        }
        PsiElement elementAt = InjectedLanguageUtil.findInjectedElementNoCommit(file, offset);
        CharTable charTable = ((FileElement)astNode).getCharTable();
        if (elementAt == null) {
            elementAt = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset);
        }
        if (elementAt == null) {
            Pair pair = new Pair(null, (Object)charTable);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "doFindWhiteSpaceNode"));
            }
            return pair;
        }
        ASTNode node = elementAt.getNode();
        if (node == null || node.getElementType() != TokenType.WHITE_SPACE) {
            Pair pair = new Pair(null, (Object)charTable);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "doFindWhiteSpaceNode"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)elementAt, (Object)charTable);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "doFindWhiteSpaceNode"));
        }
        return pair;
    }

    public Indent getIndent(String text, FileType fileType) {
        int indent = IndentHelperImpl.getIndent(this.myProject, fileType, text, true);
        int indenLevel = indent / 10000;
        int spaceCount = indent - indenLevel * 10000;
        return new IndentImpl(this.getSettings(), indenLevel, spaceCount, fileType);
    }

    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        if (indentLevel < 0) {
            spaceCount += indentLevel * this.getSettings().getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + this.getSettings().getIndentSize(fileType) - 1) / this.getSettings().getIndentSize(fileType);
            spaceCount += v * this.getSettings().getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType, indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(this.getSettings(), 0, 0, null);
    }

    @NotNull
    private CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "getSettings"));
        }
        return codeStyleSettings;
    }

    public boolean isSequentialProcessingAllowed() {
        return SEQUENTIAL_PROCESSING_ALLOWED.get().isAllowed();
    }

    public static void setSequentialProcessingAllowed(boolean allowed) {
        ProcessingUnderProgressInfo info = SEQUENTIAL_PROCESSING_ALLOWED.get();
        if (allowed) {
            info.decrement();
        } else {
            info.increment();
        }
    }

    public void performActionWithFormatterDisabled(final Runnable r) {
        this.performActionWithFormatterDisabled(new Computable<Object>(){

            public Object compute() {
                r.run();
                return null;
            }
        });
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(final ThrowableRunnable<T> r) throws T {
        final Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(new Computable<Object>(){

            public Object compute() {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    throwable[0] = t;
                }
                return null;
            }
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    public <T> T performActionWithFormatterDisabled(final Computable<T> r) {
        return ((FormatterImpl)FormatterEx.getInstance()).runWithFormattingDisabled(new Computable<T>(){

            public T compute() {
                PostprocessReformattingAspect component = PostprocessReformattingAspect.getInstance(CodeStyleManagerImpl.this.getProject());
                return component.disablePostprocessFormattingInside(r);
            }
        });
    }

    private TextRange postProcessEnabledRanges(@NotNull PsiFile file, @NotNull TextRange range, CodeStyleSettings settings) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "postProcessEnabledRanges"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl", "postProcessEnabledRanges"));
        }
        TextRange result = TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges((ASTNode)file.getNode(), result);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PostFormatProcessor processor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
                TextRange processedRange = processor.processText(file, enabledRange, settings);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result = result.grown(delta);
        return result;
    }

    private static class CaretPositionKeeper {
        Editor myEditor;
        Document myDocument;
        CaretModel myCaretModel;
        RangeMarker myBeforeCaretRangeMarker;
        String myCaretIndentToRestore;
        int myVisualColumnToRestore;
        boolean myBlankLineIndentPreserved;

        CaretPositionKeeper(@NotNull Editor editor, @NotNull CodeStyleSettings settings, @NotNull Language language) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper", "<init>"));
            }
            this.myVisualColumnToRestore = -1;
            this.myBlankLineIndentPreserved = true;
            this.myEditor = editor;
            this.myCaretModel = editor.getCaretModel();
            this.myDocument = editor.getDocument();
            this.myBlankLineIndentPreserved = CaretPositionKeeper.isBlankLineIndentPreserved(settings, language);
            int caretOffset = this.getCaretOffset();
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            int lineEndOffset = this.getLineEndOffsetByTotalOffset(caretOffset);
            boolean shouldFixCaretPosition = this.rangeHasWhiteSpaceSymbolsOnly(this.myDocument.getCharsSequence(), lineStartOffset, lineEndOffset);
            if (shouldFixCaretPosition) {
                this.initRestoreInfo(caretOffset);
            }
        }

        private static boolean isBlankLineIndentPreserved(@NotNull CodeStyleSettings settings, @NotNull Language language) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper", "isBlankLineIndentPreserved"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper", "isBlankLineIndentPreserved"));
            }
            CommonCodeStyleSettings langSettings = settings.getCommonSettings(language);
            if (langSettings != null) {
                CommonCodeStyleSettings.IndentOptions indentOptions = langSettings.getIndentOptions();
                return indentOptions != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
            }
            return false;
        }

        private void initRestoreInfo(int caretOffset) {
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            this.myVisualColumnToRestore = this.myCaretModel.getVisualPosition().column;
            this.myCaretIndentToRestore = this.myDocument.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
            this.myBeforeCaretRangeMarker = this.myDocument.createRangeMarker(0, lineStartOffset);
        }

        public void restoreCaretPosition() {
            if (this.isVirtualSpaceEnabled()) {
                this.restoreVisualPosition();
            } else {
                this.restorePositionByIndentInsertion();
            }
        }

        private void restorePositionByIndentInsertion() {
            if (this.myBeforeCaretRangeMarker == null || !this.myBeforeCaretRangeMarker.isValid() || this.myCaretIndentToRestore == null || this.myBlankLineIndentPreserved) {
                return;
            }
            int newCaretLineStartOffset = this.myBeforeCaretRangeMarker.getEndOffset();
            this.myBeforeCaretRangeMarker.dispose();
            if (this.myCaretModel.getVisualPosition().column == this.myVisualColumnToRestore) {
                return;
            }
            this.insertWhiteSpaceIndentIfNeeded(newCaretLineStartOffset);
        }

        private void restoreVisualPosition() {
            if (this.myVisualColumnToRestore < 0) {
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                return;
            }
            VisualPosition position = this.myCaretModel.getVisualPosition();
            if (this.myVisualColumnToRestore != position.column) {
                this.myCaretModel.moveToVisualPosition(new VisualPosition(position.line, this.myVisualColumnToRestore));
            }
        }

        private void insertWhiteSpaceIndentIfNeeded(int caretLineOffset) {
            int lineToInsertIndent = this.myDocument.getLineNumber(caretLineOffset);
            if (!this.lineContainsWhiteSpaceSymbolsOnly(lineToInsertIndent)) {
                return;
            }
            int lineToInsertStartOffset = this.myDocument.getLineStartOffset(lineToInsertIndent);
            if (lineToInsertIndent != this.getCurrentCaretLine()) {
                this.myCaretModel.moveToOffset(lineToInsertStartOffset);
            }
            this.myDocument.replaceString(lineToInsertStartOffset, caretLineOffset, (CharSequence)this.myCaretIndentToRestore);
        }

        private boolean rangeHasWhiteSpaceSymbolsOnly(CharSequence text, int lineStartOffset, int lineEndOffset) {
            for (int i = lineStartOffset; i < lineEndOffset; ++i) {
                char c = text.charAt(i);
                if (c == ' ' || c == '\t' || c == '\n') continue;
                return false;
            }
            return true;
        }

        private boolean isVirtualSpaceEnabled() {
            return this.myEditor.getSettings().isVirtualSpace();
        }

        private int getLineStartOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineStartOffset(line);
        }

        private int getLineEndOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineEndOffset(line);
        }

        private int getCaretOffset() {
            int caretOffset = this.myCaretModel.getOffset();
            caretOffset = Math.max(Math.min(caretOffset, this.myDocument.getTextLength() - 1), 0);
            return caretOffset;
        }

        private boolean lineContainsWhiteSpaceSymbolsOnly(int lineNumber) {
            int startOffset = this.myDocument.getLineStartOffset(lineNumber);
            int endOffset = this.myDocument.getLineEndOffset(lineNumber);
            return this.rangeHasWhiteSpaceSymbolsOnly(this.myDocument.getCharsSequence(), startOffset, endOffset);
        }

        private int getCurrentCaretLine() {
            return this.myDocument.getLineNumber(this.myCaretModel.getOffset());
        }
    }

    private static class RangeFormatInfo {
        private final SmartPsiElementPointer startPointer;
        private final SmartPsiElementPointer endPointer;
        private final boolean fromStart;
        private final boolean toEnd;

        RangeFormatInfo(@Nullable SmartPsiElementPointer startPointer, @Nullable SmartPsiElementPointer endPointer, boolean fromStart, boolean toEnd) {
            this.startPointer = startPointer;
            this.endPointer = endPointer;
            this.fromStart = fromStart;
            this.toEnd = toEnd;
        }
    }

    private static class ProcessingUnderProgressInfo {
        private static final long DURATION_TIME = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
        private int myCount;
        private long myEndTime;

        private ProcessingUnderProgressInfo() {
        }

        public void increment() {
            if (this.myCount > 0 && System.currentTimeMillis() > this.myEndTime) {
                this.myCount = 0;
            }
            ++this.myCount;
            this.myEndTime = System.currentTimeMillis() + DURATION_TIME;
        }

        public void decrement() {
            if (this.myCount <= 0) {
                return;
            }
            --this.myCount;
        }

        public boolean isAllowed() {
            return this.myCount <= 0 || System.currentTimeMillis() >= this.myEndTime;
        }
    }
}

