/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependentNSReference
extends BasicAttributeValueReference {
    @NotNull
    private final URLReference myReference;
    private final boolean myForceFetchResultValid;

    public DependentNSReference(PsiElement element, TextRange range, @NotNull URLReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference", "<init>"));
        }
        this(element, range, ref, false);
    }

    public DependentNSReference(PsiElement element, TextRange range, @NotNull URLReference ref, boolean valid) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference", "<init>"));
        }
        super(element, range);
        this.myReference = ref;
        this.myForceFetchResultValid = valid;
    }

    @Nullable
    public PsiElement resolve() {
        String canonicalText = this.getCanonicalText();
        PsiFile file = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getContainingFile(), null);
        if (file != null) {
            return file;
        }
        PsiElement element = this.myReference.resolve();
        if (element == null && !this.myForceFetchResultValid && !XmlUtil.isUrlText(canonicalText, this.myElement.getProject())) {
            return this.myElement;
        }
        return element;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public boolean isForceFetchResultValid() {
        return this.myForceFetchResultValid;
    }

    @NotNull
    public URLReference getNamespaceReference() {
        URLReference uRLReference = this.myReference;
        if (uRLReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference", "getNamespaceReference"));
        }
        return uRLReference;
    }
}

