/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;

public class OpenedInEditorWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<VirtualFile[], ProximityLocation> OPENED_EDITORS = NotNullLazyKey.create((String)"openedEditors", (NotNullFunction)new NotNullFunction<ProximityLocation, VirtualFile[]>(){

        @NotNull
        public VirtualFile[] fun(ProximityLocation location) {
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)location.getProject()).getOpenFiles();
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/proximity/OpenedInEditorWeigher$1", "fun"));
            }
            return virtualFileArray;
        }
    });

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/OpenedInEditorWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/OpenedInEditorWeigher", "weigh"));
        }
        if (location.getProject() == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return Boolean.valueOf(false);
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        return Boolean.valueOf(virtualFile != null && ArrayUtil.find((Object[])((Object[])OPENED_EDITORS.getValue((UserDataHolder)location)), (Object)virtualFile) != -1);
    }
}

