/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import org.jetbrains.annotations.NotNull;

public abstract class IntroduceHandlerBase
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.IntroduceHandlerBase");

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/IntroduceHandlerBase", "isAvailableForQuickList"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/IntroduceHandlerBase", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/IntroduceHandlerBase", "isAvailableForQuickList"));
        }
        PsiElement[] elements = ExtractMethodHandler.getElements(file.getProject(), editor, file);
        return elements != null && elements.length > 0;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/IntroduceHandlerBase", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/IntroduceHandlerBase", "invoke"));
        }
        LOG.assertTrue(elements.length >= 1 && elements[0] instanceof PsiExpression, (Object)"incorrect invoke() parameters");
        PsiElement tempExpr = elements[0];
        if (dataContext != null) {
            PsiFile cachedPsiFile;
            Editor editorFromDC = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            PsiFile psiFile = cachedPsiFile = editorFromDC != null ? PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editorFromDC.getDocument()) : null;
            editor = cachedPsiFile != null && PsiTreeUtil.isAncestor((PsiElement)cachedPsiFile, (PsiElement)tempExpr, (boolean)false) ? editorFromDC : null;
        } else {
            editor = null;
        }
        if (tempExpr instanceof PsiExpression) {
            this.invokeImpl(project, (PsiExpression)tempExpr, editor);
        } else if (tempExpr instanceof PsiLocalVariable) {
            this.invokeImpl(project, (PsiLocalVariable)tempExpr, editor);
        } else {
            LOG.error("elements[0] should be PsiExpression or PsiLocalVariable");
        }
    }

    protected abstract boolean invokeImpl(Project var1, PsiExpression var2, Editor var3);

    protected abstract boolean invokeImpl(Project var1, PsiLocalVariable var2, Editor var3);

    public abstract AbstractInplaceIntroducer getInplaceIntroducer();
}

