/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.extractSuperclass.JavaExtractSuperBaseDialog;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ExtractSuperclassDialog
extends JavaExtractSuperBaseDialog {
    private final InterfaceContainmentVerifier myContainmentVerifier = new InterfaceContainmentVerifier(){

        @Override
        public boolean checkedInterfacesContain(PsiMethod psiMethod) {
            return PullUpProcessor.checkedInterfacesContain(ExtractSuperclassDialog.this.myMemberInfos, psiMethod);
        }
    };
    private final Callback myCallback;

    public ExtractSuperclassDialog(Project project, PsiClass sourceClass, List<MemberInfo> selectedMembers, Callback callback) {
        super(project, sourceClass, selectedMembers, ExtractSuperclassHandler.REFACTORING_NAME);
        this.myCallback = callback;
        this.init();
    }

    InterfaceContainmentVerifier getContainmentVerifier() {
        return this.myContainmentVerifier;
    }

    @Override
    protected String getClassNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"superclass.name") : RefactoringBundle.message((String)"extractSuper.rename.original.class.to");
    }

    @Override
    protected String getPackageNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"package.for.new.superclass") : RefactoringBundle.message((String)"package.for.original.class");
    }

    @Override
    protected String getEntityName() {
        return RefactoringBundle.message((String)"ExtractSuperClass.superclass");
    }

    @Override
    protected String getTopLabelText() {
        return RefactoringBundle.message((String)"extract.superclass.from");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.superclass"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        panel.add((Component)memberSelectionPanel, "Center");
        UsesAndInterfacesDependencyMemberInfoModel<PsiMember, MemberInfo> memberInfoModel = new UsesAndInterfacesDependencyMemberInfoModel<PsiMember, MemberInfo>((PsiClass)this.mySourceClass, null, false, this.myContainmentVerifier){

            @Override
            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }
        };
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(memberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener(memberInfoModel);
        panel.add((Component)this.myDocCommentPanel, "East");
        return panel;
    }

    @Override
    protected String getDocCommentPanelName() {
        return RefactoringBundle.message((String)"javadoc.for.abstracts");
    }

    @Override
    protected String getExtractedSuperNameNotSpecifiedMessage() {
        return RefactoringBundle.message((String)"no.superclass.name.specified");
    }

    @Override
    protected boolean checkConflicts() {
        return this.myCallback.checkConflicts(this);
    }

    @Override
    protected int getDocCommentPolicySetting() {
        return JavaRefactoringSettings.getInstance().EXTRACT_SUPERCLASS_JAVADOC;
    }

    @Override
    protected void setDocCommentPolicySetting(int policy) {
        JavaRefactoringSettings.getInstance().EXTRACT_SUPERCLASS_JAVADOC = policy;
    }

    @Override
    protected ExtractSuperBaseProcessor createProcessor() {
        return new ExtractSuperClassProcessor(this.myProject, this.getTargetDirectory(), this.getExtractedSuperName(), (PsiClass)this.mySourceClass, (MemberInfo[])ArrayUtil.toObjectArray(this.getSelectedMemberInfos(), MemberInfo.class), false, new DocCommentPolicy(this.getDocCommentPolicy()));
    }

    @Override
    protected String getHelpId() {
        return "refactoring.extractSuperclass";
    }

    public static interface Callback {
        public boolean checkConflicts(ExtractSuperclassDialog var1);
    }
}

