/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationsImpl
extends EditorNotifications {
    private static final ExtensionPointName<EditorNotifications.Provider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.editorNotificationProvider");
    private static final Key<WeakReference<ProgressIndicator>> CURRENT_UPDATES = Key.create((String)"CURRENT_UPDATES");
    private final ThreadPoolExecutor myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"EditorNotifications executor");
    private final MergingUpdateQueue myUpdateMerger;

    public EditorNotificationsImpl(Project project) {
        super(project);
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ui/EditorNotificationsImpl$1", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl$1", "fileOpened"));
                }
                EditorNotificationsImpl.this.updateNotifications(file);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
    }

    public void updateNotifications(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl", "updateNotifications"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = EditorNotificationsImpl.getCurrentProgress(file);
                if (indicator != null) {
                    indicator.cancel();
                }
                file.putUserData(CURRENT_UPDATES, null);
                if (EditorNotificationsImpl.this.myProject.isDisposed() || !file.isValid()) {
                    return;
                }
                indicator = new ProgressIndicatorBase();
                ReadTask task = EditorNotificationsImpl.this.createTask(indicator, file);
                if (task == null) {
                    return;
                }
                file.putUserData(CURRENT_UPDATES, new WeakReference<ProgressIndicator>(indicator));
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    task.computeInReadAction(indicator);
                } else {
                    ProgressIndicatorUtils.scheduleWithWriteActionPriority(indicator, EditorNotificationsImpl.this.myExecutor, task);
                }
            }
        });
    }

    @Nullable
    private ReadTask createTask(final ProgressIndicator indicator, final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl", "createTask"));
        }
        final FileEditor[] editors = FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file);
        if (editors.length == 0) {
            return null;
        }
        return new ReadTask(){

            private boolean isOutdated() {
                if (EditorNotificationsImpl.this.myProject.isDisposed() || !file.isValid() || indicator != EditorNotificationsImpl.getCurrentProgress(file)) {
                    return true;
                }
                for (FileEditor editor : editors) {
                    if (editor.isValid()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ui/EditorNotificationsImpl$4", "computeInReadAction"));
                }
                if (this.isOutdated()) {
                    return;
                }
                List providers = DumbService.getInstance((Project)EditorNotificationsImpl.this.myProject).filterByDumbAwareness(EXTENSION_POINT_NAME.getExtensions((AreaInstance)EditorNotificationsImpl.this.myProject));
                final ArrayList updates = ContainerUtil.newArrayList();
                for (final FileEditor editor : editors) {
                    for (final EditorNotifications.Provider provider : providers) {
                        final JComponent component = provider.createNotificationPanel(file, editor);
                        updates.add(new Runnable(){

                            @Override
                            public void run() {
                                EditorNotificationsImpl.this.updateNotification(editor, (Key<? extends JComponent>)provider.getKey(), component);
                            }
                        });
                    }
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!this.isOutdated()) {
                            file.putUserData(CURRENT_UPDATES, null);
                            for (Runnable update : updates) {
                                update.run();
                            }
                        }
                    }
                });
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator ignored) {
                if (ignored == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/ui/EditorNotificationsImpl$4", "onCanceled"));
                }
                if (EditorNotificationsImpl.getCurrentProgress(file) == indicator) {
                    EditorNotificationsImpl.this.updateNotifications(file);
                }
            }
        };
    }

    private static ProgressIndicator getCurrentProgress(VirtualFile file) {
        return (ProgressIndicator)SoftReference.dereference((Reference)((Reference)file.getUserData(CURRENT_UPDATES)));
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key, @Nullable JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorNotificationsImpl", "updateNotification"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ui/EditorNotificationsImpl", "updateNotification"));
        }
        JComponent old = (JComponent)editor.getUserData(key);
        if (old != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component != null) {
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, (Object)component);
        } else {
            editor.putUserData(key, null);
        }
    }

    public void updateAllNotifications() {
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file : FileEditorManager.getInstance((Project)EditorNotificationsImpl.this.myProject).getOpenFiles()) {
                    EditorNotificationsImpl.this.updateNotifications(file);
                }
            }
        });
    }
}

