/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.io.DataExternalizer;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ValueContainer<Value> {
    private volatile boolean myNeedsCompacting = false;

    @NotNull
    public abstract IntIterator getInputIdsIterator(Value var1);

    @NotNull
    public abstract IntPredicate getValueAssociationPredicate(Value var1);

    @NotNull
    public abstract ValueIterator<Value> getValueIterator();

    @NotNull
    public abstract List<Value> toValueList();

    public abstract int size();

    public final boolean forEach(@NotNull ContainerAction<Value> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/ValueContainer", "forEach"));
        }
        ValueIterator<Value> valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            IntIterator intIterator = valueIterator.getInputIdsIterator();
            while (intIterator.hasNext()) {
                if (action.perform(intIterator.next(), value)) continue;
                return false;
            }
        }
        return true;
    }

    boolean needsCompacting() {
        return this.myNeedsCompacting;
    }

    void setNeedsCompacting(boolean value) {
        this.myNeedsCompacting = value;
    }

    public abstract void saveTo(DataOutput var1, DataExternalizer<Value> var2) throws IOException;

    public static interface ContainerAction<T> {
        public boolean perform(int var1, T var2);
    }

    public static interface ValueIterator<Value>
    extends Iterator<Value> {
        @NotNull
        public IntIterator getInputIdsIterator();

        @NotNull
        public IntPredicate getValueAssociationPredicate();

        public Object getFileSetObject();
    }

    public static interface IntPredicate {
        public boolean contains(int var1);
    }

    public static interface IntIterator {
        public boolean hasNext();

        public int next();

        public int size();

        public boolean hasAscendingOrder();

        public IntIterator createCopyInInitialState();
    }
}

