/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class VcsLogPopupComponent
extends JPanel {
    private static final int GAP_BEFORE_ARROW = 3;
    private static final int BORDER_SIZE = 2;
    private static final Border INNER_MARGIN_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border FOCUSED_BORDER = VcsLogPopupComponent.createFocusedBorder();
    private static final Border UNFOCUSED_BORDER = VcsLogPopupComponent.createUnfocusedBorder();
    @NotNull
    private final String myName;
    @NotNull
    private JLabel myNameLabel;
    @NotNull
    private JLabel myValueLabel;

    protected VcsLogPopupComponent(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/ui/VcsLogPopupComponent", "<init>"));
        }
        this.myName = name;
    }

    public JComponent initUi() {
        this.myNameLabel = new JLabel(this.myName + ": ");
        this.myValueLabel = new JLabel(){

            @Override
            public String getText() {
                return VcsLogPopupComponent.this.getCurrentText();
            }
        };
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(UNFOCUSED_BORDER);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myNameLabel);
        this.add(this.myValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.installChangeListener(new Runnable(){

            @Override
            public void run() {
                VcsLogPopupComponent.this.myValueLabel.revalidate();
                VcsLogPopupComponent.this.myValueLabel.repaint();
            }
        });
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        this.indicateHovering();
        this.indicateFocusing();
        return this;
    }

    public abstract String getCurrentText();

    public abstract void installChangeListener(@NotNull Runnable var1);

    protected abstract ActionGroup createActionGroup();

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogPopupComponent$3", "focusGained"));
                }
                VcsLogPopupComponent.this.setBorder(FOCUSED_BORDER);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogPopupComponent$3", "focusLost"));
                }
                VcsLogPopupComponent.this.setBorder(UNFOCUSED_BORDER);
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogPopupComponent$4", "keyPressed"));
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    VcsLogPopupComponent.this.showPopupMenu();
                }
            }
        });
    }

    private void showPopupMenuOnClick() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/VcsLogPopupComponent$5", "onClick"));
                }
                VcsLogPopupComponent.this.showPopupMenu();
                return true;
            }
        }.installOn((Component)this);
    }

    private void indicateHovering() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogPopupComponent$6", "mouseEntered"));
                }
                VcsLogPopupComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/VcsLogPopupComponent$6", "mouseExited"));
                }
                VcsLogPopupComponent.this.setDefaultForeground();
            }
        });
    }

    private void setDefaultForeground() {
        this.myNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        this.myValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor().darker().darker());
    }

    private void setOnHoverForeground() {
        this.myNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.myValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private void showPopupMenu() {
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        popup.showUnderneathOf((Component)this);
    }

    private static Border createFocusedBorder() {
        return BorderFactory.createCompoundBorder((Border)new RoundedLineBorder(UIUtil.getHeaderActiveColor(), 10, 2), INNER_MARGIN_BORDER);
    }

    private static Border createUnfocusedBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), INNER_MARGIN_BORDER);
    }
}

