/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class EditBreakpointAction
extends XDebuggerActionBase
implements DumbAware {
    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSupport", "com/intellij/xdebugger/impl/actions/EditBreakpointAction", "getHandler"));
        }
        EditBreakpointActionHandler editBreakpointActionHandler = debuggerSupport.getEditBreakpointAction();
        if (editBreakpointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/EditBreakpointAction", "getHandler"));
        }
        return editBreakpointActionHandler;
    }

    public static class ContextAction
    extends DumbAwareAction {
        private final GutterIconRenderer myRenderer;
        private final Object myBreakpoint;
        private DebuggerSupport myDebuggerSupport;

        public ContextAction(GutterIconRenderer breakpointRenderer, Object breakpoint, DebuggerSupport debuggerSupport) {
            super(ActionsBundle.actionText((String)"EditBreakpoint"));
            this.myRenderer = breakpointRenderer;
            this.myBreakpoint = breakpoint;
            this.myDebuggerSupport = debuggerSupport;
        }

        public void actionPerformed(AnActionEvent e) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            if (editor == null) {
                return;
            }
            this.myDebuggerSupport.getEditBreakpointAction().editBreakpoint(ContextAction.getEventProject((AnActionEvent)e), editor, this.myBreakpoint, this.myRenderer);
        }
    }
}

