/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspectionBase
extends BaseInspection {
    public boolean ignoreEmptySuperMethods;
    final ExternalizableStringSet annotations = new ExternalizableStringSet("javax.annotation.OverridingMethodsMustInvokeSuper");
    boolean onlyReportWhenAnnotated;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.onlyReportWhenAnnotated) {
            node.addContent(new Element("option").setAttribute("name", "onlyReportWhenAnnotated").setAttribute("value", String.valueOf(this.onlyReportWhenAnnotated)));
        }
        if (!this.annotations.hasDefaultValues()) {
            Element element = new Element("option").setAttribute("name", "annotations");
            Element valueElement = new Element("value");
            this.annotations.writeExternal(valueElement);
            node.addContent(element.addContent(valueElement));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            Element value;
            if ("onlyReportWhenAnnotated".equals(option.getAttributeValue("name"))) {
                this.onlyReportWhenAnnotated = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (!"annotations".equals(option.getAttributeValue("name")) || (value = option.getChild("value")) == null) continue;
            this.annotations.readExternal(value);
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod methodToSearchFor;
        private boolean hasSuperCall;

        SuperCallVisitor(PsiMethod methodToSearchFor) {
            this.methodToSearchFor = methodToSearchFor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$SuperCallVisitor", "visitElement"));
            }
            if (this.hasSuperCall) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$SuperCallVisitor", "visitMethodCallExpression"));
            }
            if (this.hasSuperCall) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String text = qualifier.getText();
            if (!"super".equals(text)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (method.equals(this.methodToSearchFor)) {
                this.hasSuperCall = true;
            }
        }

        boolean hasSuperCall() {
            return this.hasSuperCall;
        }
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod superMethod;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$RefusedBequestVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod leastConcreteSuperMethod = this.getLeastConcreteSuperMethod(method);
            if (leastConcreteSuperMethod == null) {
                return;
            }
            PsiClass objectClass = ClassUtils.findObjectClass((PsiElement)method);
            PsiMethod[] superMethods = method.findSuperMethods(objectClass);
            if (superMethods.length > 0) {
                return;
            }
            if (RefusedBequestInspectionBase.this.ignoreEmptySuperMethods && MethodUtils.isTrivial(superMethod = (PsiMethod)leastConcreteSuperMethod.getNavigationElement(), true)) {
                return;
            }
            if (RefusedBequestInspectionBase.this.onlyReportWhenAnnotated && !AnnotationUtil.isAnnotated((PsiModifierListOwner)leastConcreteSuperMethod, (Collection)((Object)RefusedBequestInspectionBase.this.annotations))) {
                return;
            }
            if (this.containsSuperCall((PsiElement)body, leastConcreteSuperMethod)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        @Nullable
        private PsiMethod getLeastConcreteSuperMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods(true)) {
                PsiClass containingClass = superMethod.getContainingClass();
                if (containingClass == null || superMethod.hasModifierProperty("abstract") || containingClass.isInterface()) continue;
                return superMethod;
            }
            return null;
        }

        private boolean containsSuperCall(@NotNull PsiElement context, @NotNull PsiMethod method) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$RefusedBequestVisitor", "containsSuperCall"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$RefusedBequestVisitor", "containsSuperCall"));
            }
            SuperCallVisitor visitor = new SuperCallVisitor(method);
            context.accept((PsiElementVisitor)visitor);
            return visitor.hasSuperCall();
        }
    }
}

