/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspectionBase
extends BaseInspection {
    @Nullable
    static PsiStatement getPreviousStatement(PsiElement context) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)context, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (!(prevStatement instanceof PsiStatement)) {
            return null;
        }
        return (PsiStatement)prevStatement;
    }

    @NotNull
    public String getID() {
        if ("WhileLoopReplaceableByForEach" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase", "getID"));
        }
        return "WhileLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileCanBeForeachVisitor();
    }

    private static class IteratorHasNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasNextCalled;
        private final PsiVariable iterator;

        private IteratorHasNextVisitor(@NotNull PsiVariable iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorHasNextVisitor", "<init>"));
            }
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorHasNextVisitor", "visitElement"));
            }
            if (!this.hasNextCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorHasNextVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"hasNext".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.hasNextCalled = true;
            }
        }

        boolean isHasNextCalled() {
            return this.hasNextCalled;
        }
    }

    private static class IteratorMethodCallVisitor
    extends JavaRecursiveElementVisitor {
        private boolean methodCalled;
        private final PsiVariable iterator;

        IteratorMethodCallVisitor(@NotNull PsiVariable iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorMethodCallVisitor", "<init>"));
            }
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorMethodCallVisitor", "visitElement"));
            }
            if (!this.methodCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$IteratorMethodCallVisitor", "visitMethodCallExpression"));
            }
            if (this.methodCalled) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if ("next".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.methodCalled = true;
            }
        }

        boolean isMethodCalled() {
            return this.methodCalled;
        }
    }

    private static class NumberCallsToIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumberCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$NumberCallsToIteratorNextVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }

    private static class WhileCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private WhileCanBeForeachVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/migration/WhileCanBeForeachInspectionBase$WhileCanBeForeachVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(whileStatement);
            if (!WhileCanBeForeachVisitor.isCollectionLoopStatement(whileStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)whileStatement, new Object[0]);
        }

        private static boolean isCollectionLoopStatement(PsiWhileStatement whileStatement) {
            PsiClass qualifierClass;
            PsiStatement initialization = WhileCanBeForeachInspectionBase.getPreviousStatement((PsiElement)whileStatement);
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
                return false;
            }
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return false;
            }
            if (!(initialValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
            PsiExpressionList argumentList = initialCall.getArgumentList();
            PsiExpression[] argument = argumentList.getExpressions();
            if (argument.length != 0) {
                return false;
            }
            PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
            String initialCallName = initialMethodExpression.getReferenceName();
            if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
                return false;
            }
            PsiExpression qualifier = initialMethodExpression.getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression) {
                return false;
            }
            if (qualifier != null) {
                PsiType qualifierType = qualifier.getType();
                if (!(qualifierType instanceof PsiClassType)) {
                    return false;
                }
                qualifierClass = ((PsiClassType)qualifierType).resolve();
            } else {
                qualifierClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)whileStatement, PsiClass.class);
            }
            if (qualifierClass == null) {
                return false;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable")) {
                return false;
            }
            PsiExpression condition = whileStatement.getCondition();
            if (!WhileCanBeForeachVisitor.isHasNextCalled(variable, condition)) {
                return false;
            }
            PsiStatement body = whileStatement.getBody();
            if (body == null) {
                return false;
            }
            if (WhileCanBeForeachVisitor.calculateCallsToIteratorNext(variable, (PsiElement)body) != 1) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorRemoveCalled(variable, (PsiElement)body)) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorHasNextCalled(variable, (PsiElement)body)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body)) {
                return false;
            }
            for (PsiElement nextSibling = whileStatement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!VariableAccessUtils.variableValueIsUsed(variable, nextSibling)) continue;
                return false;
            }
            return true;
        }

        private static boolean isHasNextCalled(PsiVariable iterator, PsiExpression condition) {
            if (!(condition instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"hasNext".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return true;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            return iterator.equals(target);
        }

        private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiElement context) {
            NumberCallsToIteratorNextVisitor visitor = new NumberCallsToIteratorNextVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.getNumCallsToIteratorNext();
        }

        private static boolean isIteratorRemoveCalled(PsiVariable iterator, PsiElement context) {
            IteratorMethodCallVisitor visitor = new IteratorMethodCallVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isMethodCalled();
        }

        private static boolean isIteratorHasNextCalled(PsiVariable iterator, PsiElement context) {
            IteratorHasNextVisitor visitor = new IteratorHasNextVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isHasNextCalled();
        }
    }
}

