/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBufferReplaceableByStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiElement element = (PsiElement)infos[0];
        if (element instanceof PsiNewExpression) {
            String string = InspectionGadgetsBundle.message("new.string.buffer.replaceable.by.string.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection", "buildErrorString"));
            }
            return string;
        }
        String typeText = ((PsiType)infos[1]).getPresentableText();
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.problem.descriptor", typeText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String typeText = ((PsiType)infos[1]).getCanonicalText();
        return new StringBufferReplaceableByStringFix("java.lang.StringBuilder".equals(typeText));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringVisitor();
    }

    private static boolean isAppendCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"append".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 3) {
            return arguments[0].getType() instanceof PsiArrayType && arguments[1].getType() == PsiType.INT && arguments[2].getType() == PsiType.INT;
        }
        return arguments.length == 1;
    }

    private static boolean isToStringCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"toString".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        return arguments.length == 0;
    }

    @Nullable
    private static PsiExpression getCompleteExpression(PsiElement element) {
        PsiElement parent;
        PsiElement completeExpression = element;
        boolean found = false;
        while ((parent = completeExpression.getParent()) instanceof PsiReferenceExpression) {
            PsiElement grandParent = parent.getParent();
            if (StringBufferReplaceableByStringInspection.isToStringCall(grandParent)) {
                found = true;
            } else if (!StringBufferReplaceableByStringInspection.isAppendCall(grandParent)) {
                return null;
            }
            completeExpression = grandParent;
            if (!found) continue;
            return (PsiExpression)completeExpression;
        }
        return null;
    }

    private static class ReplaceableByStringVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myParent;
        private final PsiVariable myVariable;
        private boolean myReplaceable;
        private boolean myPossibleSideEffect;
        private boolean myToStringFound;

        ReplaceableByStringVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection$ReplaceableByStringVisitor", "<init>"));
            }
            this.myReplaceable = true;
            this.myVariable = variable;
            this.myParent = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiIfStatement.class, PsiLoopStatement.class});
        }

        public boolean isReplaceable() {
            return this.myReplaceable && this.myToStringFound;
        }

        public void visitElement(PsiElement element) {
            if (!this.myReplaceable) {
                return;
            }
            super.visitElement(element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            if (expression.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            if (expression.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            if (expression.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (expression.getTextOffset() < this.myVariable.getTextOffset() || this.myToStringFound) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                this.myPossibleSideEffect = true;
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                this.myPossibleSideEffect = true;
                return;
            }
            String name = aClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(name) || "java.lang.StringBuilder".equals(name)) {
                return;
            }
            if (this.isArgumentOfStringBuilderMethod(expression)) {
                return;
            }
            this.myPossibleSideEffect = true;
        }

        private boolean isArgumentOfStringBuilderMethod(PsiMethodCallExpression expression) {
            PsiExpressionList parent = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            if (parent == null) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                if (!this.isCallToStringBuilderMethod(methodCallExpression)) {
                    return this.isArgumentOfStringBuilderMethod(methodCallExpression);
                }
                return true;
            }
            if (grandParent instanceof PsiNewExpression) {
                PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)grandParent, PsiLocalVariable.class, (boolean)true, (Class[])new Class[]{PsiExpressionList.class});
                if (!this.myVariable.equals(variable)) {
                    return false;
                }
                PsiNewExpression newExpression = (PsiNewExpression)grandParent;
                PsiMethod constructor = newExpression.resolveMethod();
                if (constructor == null) {
                    return false;
                }
                PsiClass aClass = constructor.getContainingClass();
                if (aClass == null) {
                    return false;
                }
                String name = aClass.getQualifiedName();
                return "java.lang.StringBuffer".equals(name) || "java.lang.StringBuilder".equals(name);
            }
            return false;
        }

        private boolean isCallToStringBuilderMethod(PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            while (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)qualifier;
                PsiReferenceExpression methodExpression1 = callExpression.getMethodExpression();
                qualifier = methodExpression1.getQualifierExpression();
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.myVariable.equals(target)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String name1 = aClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(name1) || "java.lang.StringBuilder".equals(name1);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement grandParent;
            if (!this.myReplaceable || expression.getTextOffset() < this.myVariable.getTextOffset()) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier != null) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!this.myVariable.equals(target)) {
                return;
            }
            if (this.myToStringFound) {
                this.myReplaceable = false;
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiCodeBlock.class, PsiIfStatement.class, PsiLoopStatement.class});
            if (!this.myParent.equals(element)) {
                this.myReplaceable = false;
                return;
            }
            PsiElement parent = expression.getParent();
            do {
                if (!(parent instanceof PsiReferenceExpression)) {
                    this.myReplaceable = false;
                    return;
                }
                grandParent = parent.getParent();
                if (!StringBufferReplaceableByStringInspection.isAppendCall(grandParent)) {
                    if (!StringBufferReplaceableByStringInspection.isToStringCall(grandParent)) {
                        this.myReplaceable = false;
                        return;
                    }
                    this.myToStringFound = true;
                    return;
                }
                if (!this.myPossibleSideEffect) continue;
                this.myReplaceable = false;
                return;
            } while (!((parent = grandParent.getParent()) instanceof PsiExpressionStatement));
        }
    }

    private static class StringBufferReplaceableByStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferReplaceableByStringVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection$StringBufferReplaceableByStringVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            PsiType type = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type) && !TypeUtils.typeEquals("java.lang.StringBuilder", type)) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (!StringBufferReplaceableByStringVisitor.isNewStringBufferOrStringBuilder(initializer)) {
                return;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            ReplaceableByStringVisitor visitor = new ReplaceableByStringVisitor((PsiVariable)variable);
            codeBlock.accept((PsiElementVisitor)visitor);
            if (!visitor.isReplaceable()) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, variable, type);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type) && !TypeUtils.typeEquals("java.lang.StringBuilder", type)) {
                return;
            }
            PsiExpression completeExpression = StringBufferReplaceableByStringInspection.getCompleteExpression((PsiElement)expression);
            if (completeExpression == null) {
                return;
            }
            this.registerNewExpressionError(expression, expression, type);
        }

        private static boolean isNewStringBufferOrStringBuilder(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiNewExpression) {
                return true;
            }
            if (!StringBufferReplaceableByStringInspection.isAppendCall((PsiElement)expression) || !(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return StringBufferReplaceableByStringVisitor.isNewStringBufferOrStringBuilder(qualifier);
        }
    }

    private static class StringBufferReplaceableByStringFix
    extends InspectionGadgetsFix {
        private final boolean isStringBuilder;

        private StringBufferReplaceableByStringFix(boolean isStringBuilder) {
            this.isStringBuilder = isStringBuilder;
        }

        @NotNull
        public String getName() {
            if (this.isStringBuilder) {
                String string = InspectionGadgetsBundle.message("string.builder.replaceable.by.string.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection$StringBufferReplaceableByStringFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection$StringBufferReplaceableByStringFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with 'String'" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection$StringBufferReplaceableByStringFix", "getFamilyName"));
            }
            return "Replace with 'String'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            boolean useVariable;
            PsiCodeBlock codeBlock;
            StringBuilder builder;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiVariable)) {
                PsiExpression stringBuilderExpression;
                StringBuilder stringExpression;
                if (parent instanceof PsiNewExpression && (stringExpression = StringBufferReplaceableByStringFix.buildStringExpression((PsiElement)(stringBuilderExpression = StringBufferReplaceableByStringInspection.getCompleteExpression(parent)), new StringBuilder())) != null && stringBuilderExpression != null) {
                    PsiReplacementUtil.replaceExpression(stringBuilderExpression, stringExpression.toString());
                }
                return;
            }
            PsiVariable variable = (PsiVariable)parent;
            PsiTypeElement originalTypeElement = variable.getTypeElement();
            if (originalTypeElement == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (StringBufferReplaceableByStringInspection.isAppendCall((PsiElement)initializer)) {
                builder = StringBufferReplaceableByStringFix.buildStringExpression((PsiElement)initializer, new StringBuilder());
                if (builder == null) {
                    return;
                }
            } else if (initializer instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiExpression[] arguments = argumentList.getExpressions();
                builder = arguments.length == 0 || PsiType.INT.equals((Object)arguments[0].getType()) ? new StringBuilder() : new StringBuilder(arguments[0].getText());
            } else {
                return;
            }
            if ((codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
                return;
            }
            StringBuildingVisitor visitor = new StringBuildingVisitor(variable, builder);
            codeBlock.accept((PsiElementVisitor)visitor);
            if (visitor.hadProblem()) {
                return;
            }
            List<PsiMethodCallExpression> expressions = visitor.getExpressions();
            String expression = builder.toString().trim();
            PsiMethodCallExpression lastExpression = expressions.get(expressions.size() - 1);
            boolean bl = useVariable = expression.contains("\n") && !StringBufferReplaceableByStringFix.isVariableInitializer((PsiExpression)lastExpression);
            if (useVariable) {
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class);
                if (statement == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiStatement newStatement = factory.createStatementFromText("java.lang.String " + variable.getName() + '=' + expression + ';', (PsiElement)variable);
                codeBlock.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
            variable.delete();
            int size = expressions.size() - 1;
            for (int i = 0; i < size; ++i) {
                expressions.get(i).getParent().delete();
            }
            if (useVariable) {
                PsiReplacementUtil.replaceExpression((PsiExpression)lastExpression, variable.getName());
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)lastExpression, expression);
            }
        }

        private static boolean isVariableInitializer(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)parent;
            PsiExpression initializer = variable.getInitializer();
            return initializer == expression;
        }

        @Nullable
        private static StringBuilder buildStringExpression(PsiElement element, @NonNls StringBuilder result) {
            if (element instanceof PsiNewExpression) {
                PsiExpression argument;
                PsiType type;
                PsiNewExpression newExpression = (PsiNewExpression)element;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return null;
                }
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length == 1 && !PsiType.INT.equals((Object)(type = (argument = arguments[0]).getType()))) {
                    if (type != null && type.equalsToText("java.lang.CharSequence")) {
                        result.append("String.valueOf(").append(argument.getText()).append(')');
                    } else if (ParenthesesUtils.getPrecedence(argument) > 6) {
                        result.append('(').append(argument.getText()).append(')');
                    } else {
                        result.append(argument.getText());
                    }
                }
                return result;
            }
            for (PsiElement child : element.getChildren()) {
                if (child instanceof PsiExpressionList || StringBufferReplaceableByStringFix.buildStringExpression(child, result) != null) continue;
                return null;
            }
            if (element instanceof PsiWhiteSpace) {
                if (element.getText().contains("\n")) {
                    result.append('\n');
                }
            } else if (element instanceof PsiComment) {
                result.append(element.getText());
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String referenceName = methodExpression.getReferenceName();
                if ("toString".equals(referenceName)) {
                    if (result.length() == 0) {
                        result.append("\"\"");
                    }
                } else if ("append".equals(referenceName)) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    if (arguments.length == 0) {
                        return null;
                    }
                    if (arguments.length > 1) {
                        if (result.length() != 0) {
                            StringBufferReplaceableByStringFix.insertPlus(result);
                        }
                        result.append("String.valueOf").append(argumentList.getText());
                        return result;
                    }
                    PsiExpression argument = arguments[0];
                    PsiType type = argument.getType();
                    String argumentText = argument.getText();
                    if (result.length() != 0) {
                        StringBufferReplaceableByStringFix.insertPlus(result);
                        if (ParenthesesUtils.getPrecedence(argument) > 6 || type instanceof PsiPrimitiveType && ParenthesesUtils.getPrecedence(argument) == 6) {
                            result.append('(').append(argumentText).append(')');
                        } else {
                            if (StringUtil.startsWithChar((CharSequence)argumentText, (char)'+')) {
                                result.append(' ');
                            }
                            result.append(argumentText);
                        }
                    } else if (type instanceof PsiPrimitiveType) {
                        if (argument instanceof PsiLiteralExpression) {
                            PsiLiteralExpression literalExpression = (PsiLiteralExpression)argument;
                            if (PsiType.CHAR.equals((Object)literalExpression.getType())) {
                                result.append('\"');
                                Character c = (Character)literalExpression.getValue();
                                if (c != null) {
                                    result.append(StringUtil.escapeStringCharacters((String)c.toString()));
                                }
                                result.append('\"');
                            } else {
                                result.append('\"').append(literalExpression.getValue()).append('\"');
                            }
                        } else {
                            result.append("String.valueOf(").append(argumentText).append(")");
                        }
                    } else if (ParenthesesUtils.getPrecedence(argument) >= 6) {
                        result.append('(').append(argumentText).append(')');
                    } else if (type != null && !type.equalsToText("java.lang.String")) {
                        result.append("String.valueOf(").append(argumentText).append(")");
                    } else {
                        result.append(argumentText);
                    }
                }
            }
            return result;
        }

        private static void insertPlus(@NonNls StringBuilder result) {
            if (result.charAt(result.length() - 1) == '\n') {
                for (int index = result.length() - 2; index > 0; --index) {
                    char c = result.charAt(index);
                    if (c == '/' && result.charAt(index - 1) == '/') {
                        result.insert(index - 1, "+ ");
                        return;
                    }
                    if (c == '\n') break;
                }
                result.insert(result.length() - 1, '+');
            } else {
                result.append('+');
            }
        }

        private static class StringBuildingVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable myVariable;
            private final StringBuilder myBuilder;
            private final List<PsiMethodCallExpression> expressions;
            private boolean myProblem;

            private StringBuildingVisitor(@NotNull PsiVariable variable, StringBuilder builder) {
                if (variable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/style/StringBufferReplaceableByStringInspection$StringBufferReplaceableByStringFix$StringBuildingVisitor", "<init>"));
                }
                this.expressions = ContainerUtil.newArrayList();
                this.myVariable = variable;
                this.myBuilder = builder;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (this.myProblem) {
                    return;
                }
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!this.myVariable.equals(target)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = null;
                PsiElement parent = expression.getParent();
                PsiElement grandParent = parent.getParent();
                while (parent instanceof PsiReferenceExpression && grandParent instanceof PsiMethodCallExpression) {
                    methodCallExpression = (PsiMethodCallExpression)grandParent;
                    parent = methodCallExpression.getParent();
                    grandParent = parent.getParent();
                    if (!"toString".equals(methodCallExpression.getMethodExpression().getReferenceName())) continue;
                }
                if (StringBufferReplaceableByStringFix.buildStringExpression(methodCallExpression, this.myBuilder) == null) {
                    this.myProblem = true;
                }
                this.myBuilder.append('\n');
                this.expressions.add(methodCallExpression);
            }

            public List<PsiMethodCallExpression> getExpressions() {
                return this.expressions;
            }

            private boolean hadProblem() {
                return this.myProblem;
            }
        }
    }
}

