/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.jetbrains.annotations.NotNull;

public final class ImageEditorManagerImpl {
    private ImageEditorManagerImpl() {
    }

    @NotNull
    public static ImageEditor createImageEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditor"));
        }
        ImageEditorImpl imageEditorImpl = new ImageEditorImpl(project, file);
        if (imageEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditor"));
        }
        return imageEditorImpl;
    }

    @NotNull
    public static ImageEditorUI createImageEditorUI(BufferedImage image) {
        ImageEditorUI ui = new ImageEditorUI(null);
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        ui.getImageComponent().setGridVisible(gridOptions.isShowDefault());
        ui.getImageComponent().setTransparencyChessboardVisible(transparencyChessboardOptions.isShowDefault());
        ui.setImage(image, null);
        ImageEditorUI imageEditorUI = ui;
        if (imageEditorUI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditorUI"));
        }
        return imageEditorUI;
    }

    public static void releaseImageEditor(@NotNull ImageEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "releaseImageEditor"));
        }
        if (!editor.isDisposed()) {
            editor.dispose();
        }
    }
}

