/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ConsoleManager;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;

public abstract class NetService
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(NetService.class);
    protected final Project project;
    private final ConsoleManager consoleManager;
    protected final AsyncValueLoader<OSProcessHandler> processHandler;

    protected NetService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/NetService", "<init>"));
        }
        this(project, new ConsoleManager());
    }

    protected NetService(@NotNull Project project, @NotNull ConsoleManager consoleManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/NetService", "<init>"));
        }
        if (consoleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleManager", "org/jetbrains/builtInWebServer/NetService", "<init>"));
        }
        this.processHandler = new AsyncValueLoader<OSProcessHandler>(){

            protected boolean isCancelOnReject() {
                return true;
            }

            @Nullable
            private OSProcessHandler doGetProcessHandler(int port) {
                try {
                    return NetService.this.createProcessHandler(NetService.this.project, port);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }

            @NotNull
            protected Promise<OSProcessHandler> load(final @NotNull AsyncPromise<OSProcessHandler> promise) throws IOException {
                if (promise == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/builtInWebServer/NetService$1", "load"));
                }
                final int port = NetUtils.findAvailableSocketPort();
                final OSProcessHandler processHandler = this.doGetProcessHandler(port);
                if (processHandler == null) {
                    promise.setError((Throwable)Promise.createError((String)"rejected"));
                    AsyncPromise<OSProcessHandler> asyncPromise2 = promise;
                    if (asyncPromise2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/NetService$1", "load"));
                    }
                    return asyncPromise2;
                }
                promise.rejected((Consumer)new Consumer<Throwable>(){

                    public void consume(Throwable error) {
                        processHandler.destroyProcess();
                        Promise.logError((Logger)LOG, (Throwable)error);
                    }
                });
                final MyProcessAdapter processListener = new MyProcessAdapter();
                processHandler.addProcessListener((ProcessListener)processListener);
                processHandler.startNotify();
                if (promise.getState() == Promise.State.REJECTED) {
                    AsyncPromise<OSProcessHandler> asyncPromise3 = promise;
                    if (asyncPromise3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/NetService$1", "load"));
                    }
                    return asyncPromise3;
                }
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            if (promise.getState() != Promise.State.REJECTED) {
                                try {
                                    NetService.this.connectToProcess((AsyncPromise<OSProcessHandler>)promise, port, processHandler, processListener);
                                }
                                catch (Throwable e) {
                                    if (promise.setError(e)) break block3;
                                    LOG.error(e);
                                }
                            }
                        }
                    }
                });
                AsyncPromise<OSProcessHandler> asyncPromise4 = promise;
                if (asyncPromise4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/NetService$1", "load"));
                }
                return asyncPromise4;
            }

            protected void disposeResult(@NotNull OSProcessHandler processHandler) {
                if (processHandler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/builtInWebServer/NetService$1", "disposeResult"));
                }
                try {
                    NetService.this.closeProcessConnections();
                }
                finally {
                    processHandler.destroyProcess();
                }
            }
        };
        this.project = project;
        this.consoleManager = consoleManager;
    }

    @Nullable
    protected abstract OSProcessHandler createProcessHandler(@NotNull Project var1, int var2) throws ExecutionException;

    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler, @NotNull Consumer<String> errorOutputConsumer) {
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/builtInWebServer/NetService", "connectToProcess"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/builtInWebServer/NetService", "connectToProcess"));
        }
        if (errorOutputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutputConsumer", "org/jetbrains/builtInWebServer/NetService", "connectToProcess"));
        }
        promise.setResult((Object)processHandler);
    }

    protected abstract void closeProcessConnections();

    public void dispose() {
        this.processHandler.reset();
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        if (consoleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleBuilder", "org/jetbrains/builtInWebServer/NetService", "configureConsole"));
        }
    }

    @NotNull
    protected abstract String getConsoleToolWindowId();

    @NotNull
    protected abstract Icon getConsoleToolWindowIcon();

    @NotNull
    public ActionGroup getConsoleToolWindowActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/NetService", "getConsoleToolWindowActions"));
        }
        return defaultActionGroup;
    }

    private final class MyProcessAdapter
    extends ProcessAdapter
    implements Consumer<String> {
        private MyProcessAdapter() {
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            this.print(event.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType));
        }

        private void print(String text, ConsoleViewContentType contentType) {
            NetService.this.consoleManager.getConsole(NetService.this).print(text, contentType);
        }

        public void processTerminated(ProcessEvent event) {
            NetService.this.processHandler.reset();
            this.print(NetService.this.getConsoleToolWindowId() + " terminated\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        public void consume(String message) {
            this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }
}

