/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.BrowserConnection;

public abstract class VmConnection<T extends Vm>
implements Disposable,
BrowserConnection {
    private final AtomicReference<ConnectionState> state = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private final EventDispatcher<DebugEventListener> dispatcher = EventDispatcher.create(DebugEventListener.class);
    private final EventDispatcher<SocketConnectionListener> connectionDispatcher = EventDispatcher.create(SocketConnectionListener.class);
    protected volatile T vm;
    private final AsyncPromise<Void> opened = new AsyncPromise();
    private final AtomicBoolean closed = new AtomicBoolean();

    public final Vm getVm() {
        return this.vm;
    }

    @Override
    @NotNull
    public ConnectionState getState() {
        ConnectionState connectionState = this.state.get();
        if (connectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/VmConnection", "getState"));
        }
        return connectionState;
    }

    public void addDebugListener(@NotNull DebugEventListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/debugger/connection/VmConnection", "addDebugListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/debugger/connection/VmConnection", "addDebugListener"));
        }
        this.dispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void addDebugListener(@NotNull DebugEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/debugger/connection/VmConnection", "addDebugListener"));
        }
        this.dispatcher.addListener((EventListener)listener);
    }

    @NotNull
    public Promise<Void> opened() {
        AsyncPromise<Void> asyncPromise2 = this.opened;
        if (asyncPromise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/VmConnection", "opened"));
        }
        return asyncPromise2;
    }

    @Override
    public void executeOnStart(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/debugger/connection/VmConnection", "executeOnStart"));
        }
        this.opened.done((Consumer)new Consumer<Void>(){

            public void consume(Void aVoid) {
                runnable.run();
            }
        });
    }

    protected void setState(@NotNull ConnectionStatus status, @Nullable String message) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/debugger/connection/VmConnection", "setState"));
        }
        this.setState(status, message, null);
    }

    protected void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/debugger/connection/VmConnection", "setState"));
        }
        ConnectionState newState = new ConnectionState(status, message, messageLinkListener);
        ConnectionState oldState = this.state.getAndSet(newState);
        if (oldState == null || oldState.getStatus() != status) {
            if (status == ConnectionStatus.CONNECTION_FAILED) {
                this.opened.setError((Throwable)Promise.createError((String)newState.getMessage()));
            }
            ((SocketConnectionListener)this.connectionDispatcher.getMulticaster()).statusChanged(status);
        }
    }

    @Override
    public void addListener(@NotNull SocketConnectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/debugger/connection/VmConnection", "addListener"));
        }
        this.connectionDispatcher.addListener((EventListener)listener);
    }

    public DebugEventListener getDebugEventListener() {
        return (DebugEventListener)this.dispatcher.getMulticaster();
    }

    protected void startProcessing() {
        this.opened.setResult(null);
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/debugger/connection/VmConnection", "close"));
        }
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.opened.getState() == Promise.State.PENDING) {
            this.opened.setError((Throwable)Promise.createError((String)"closed"));
        }
        this.setState(status, message);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<Void> detachAndClose() {
        Promise<Void> callback;
        T currentVm;
        if (this.opened.getState() == Promise.State.PENDING) {
            this.opened.setError((Throwable)Promise.createError((String)"detached and closed"));
        }
        if ((currentVm = this.vm) == null) {
            callback = Promise.DONE;
        } else {
            this.vm = null;
            callback = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        Promise<Void> promise = callback;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/connection/VmConnection", "detachAndClose"));
        }
        return promise;
    }
}

