/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkinProject;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.ui.TagNameFieldOwner;
import com.intellij.cvsSupport2.ui.experts.importToCvs.CvsFieldValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AdditionalOptionsPanel
implements RefreshableOnComponent,
TagNameFieldOwner {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myTagName;
    private JCheckBox myTag;
    private JLabel myErrorLabel;
    private JCheckBox myOverrideExisting;
    private final CvsConfiguration myConfiguration;
    private boolean myIsCorrect = true;
    private String myErrorMessage;

    public AdditionalOptionsPanel(CvsConfiguration configuration, Collection<FilePath> files, Project project) {
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        TagsHelper.addChooseBranchAction(this.myTagName, files, project);
        this.myTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalOptionsPanel.this.updateEnable();
            }
        });
        CvsFieldValidator.installOn(this, this.myTagName.getTextField(), this.myErrorLabel, new AbstractButton[]{this.myTag});
    }

    private void updateEnable() {
        boolean tag = this.myTag.isSelected();
        this.myTagName.setEnabled(tag);
        this.myOverrideExisting.setEnabled(tag);
    }

    public void refresh() {
        this.myTagName.setText(this.myConfiguration.TAG_AFTER_PROJECT_COMMIT_NAME);
        this.myOverrideExisting.setSelected(this.myConfiguration.OVERRIDE_EXISTING_TAG_FOR_PROJECT);
        this.updateEnable();
    }

    public void saveState() {
        if (!this.myIsCorrect) {
            throw new InputException(CvsBundle.message((String)"error.message.incorrect.tag.name", (Object[])new Object[]{this.myErrorMessage}), (JComponent)this.myTagName);
        }
        this.myConfiguration.TAG_AFTER_PROJECT_COMMIT = this.myTag.isSelected();
        this.myConfiguration.OVERRIDE_EXISTING_TAG_FOR_PROJECT = this.myOverrideExisting.isSelected();
        this.myConfiguration.TAG_AFTER_PROJECT_COMMIT_NAME = this.myTagName.getText().trim();
    }

    public void restoreState() {
        this.refresh();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    public void enableOkAction() {
        this.myIsCorrect = true;
    }

    @Override
    public void disableOkAction(String errorMessage) {
        this.myIsCorrect = false;
        this.myErrorMessage = errorMessage;
    }

    @Override
    public boolean tagFieldIsActive() {
        return this.myTag.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, new Dimension(293, 74), null));
        this.myTag = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("check.box.tag.commited.after.checkin.option"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText(" ###");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(10, -1), null));
        this.myOverrideExisting = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("check.box.tag.commited.after.checkin.override.existings"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTagName = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

