/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.printer;

import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValueArray;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.BinaryExpression;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.RawListAccessor;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.StaticInitializer;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;
import lombok.ast.WildcardKind;
import lombok.ast.printer.SourceFormatter;

public class SourcePrinter
extends ForwardingAstVisitor {
    private final SourceFormatter formatter;

    public SourcePrinter(SourceFormatter formatter) {
        this.formatter = formatter;
    }

    private void visit(Node node) {
        if (node != null) {
            node.accept(this);
        }
    }

    @Override
    public boolean visitNode(Node node) {
        this.formatter.buildBlock(node);
        this.formatter.fail("NOT_IMPLEMENTED: " + node.getClass().getSimpleName());
        this.formatter.closeBlock();
        return false;
    }

    private void append(String text) {
        StringBuilder sb = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == '\n') {
                if (sb.length() > 0) {
                    this.formatter.append(sb.toString());
                }
                sb.setLength(0);
                this.formatter.verticalSpace();
                continue;
            }
            if (c == ' ') {
                if (sb.length() > 0) {
                    this.formatter.append(sb.toString());
                }
                sb.setLength(0);
                this.formatter.space();
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            this.formatter.append(sb.toString());
        }
    }

    private void visitAll0(String relation, RawListAccessor<?, ?> nodes, String separator, String prefix, String suffix, boolean suppress) {
        if (nodes.isEmpty()) {
            return;
        }
        this.append(prefix);
        boolean first = true;
        for (Node n : nodes) {
            if (!first) {
                this.append(separator);
            }
            first = false;
            this.formatter.nameNextElement(relation);
            if (suppress) {
                this.formatter.startSuppressBlock();
            }
            this.visit(n);
            if (!suppress) continue;
            this.formatter.endSuppressBlock();
        }
        this.append(suffix);
    }

    private void visitAllSuppressed(RawListAccessor<?, ?> nodes, String separator, String prefix, String suffix) {
        this.visitAll0(null, nodes, separator, prefix, suffix, true);
    }

    private void visitAll(RawListAccessor<?, ?> nodes, String separator, String prefix, String suffix) {
        this.visitAll0(null, nodes, separator, prefix, suffix, false);
    }

    private void visitAll(String relation, RawListAccessor<?, ?> nodes, String separator, String prefix, String suffix) {
        this.visitAll0(relation, nodes, separator, prefix, suffix, false);
    }

    private boolean isValidJavaIdentifier(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        char c = in.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        char[] cs = in.toCharArray();
        for (int i = 1; i < cs.length; ++i) {
            if (Character.isJavaIdentifierPart(cs[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visitTypeReference(TypeReference node) {
        WildcardKind kind = node.astWildcard();
        this.formatter.buildInline(node);
        this.formatter.property("WildcardKind", (Object)kind);
        this.formatter.property("arrayDimensions", node.astArrayDimensions());
        if (kind == WildcardKind.UNBOUND) {
            this.formatter.append("?");
            this.formatter.closeInline();
            return true;
        }
        if (kind == WildcardKind.EXTENDS) {
            this.formatter.append("?");
            this.formatter.space();
            this.formatter.keyword("extends");
            this.formatter.space();
        } else if (kind == WildcardKind.SUPER) {
            this.formatter.append("?");
            this.formatter.space();
            this.formatter.keyword("super");
            this.formatter.space();
        }
        this.visitAll(node.rawParts(), ".", "", "");
        for (int i = 0; i < node.astArrayDimensions(); ++i) {
            this.formatter.append("[]");
        }
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitTypeReferencePart(TypeReferencePart node) {
        this.formatter.buildInline(node);
        this.visit(node.astIdentifier());
        this.visitAll(node.rawTypeArguments(), ", ", "<", ">");
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitVariableReference(VariableReference node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.visit(node.astIdentifier());
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitIdentifier(Identifier node) {
        String name = node.astValue();
        if (name == null) {
            name = "?!?NULL_IDENTIFIER?!?";
        } else if (name.isEmpty()) {
            name = "?!?EMPTY_IDENTIFIER?!?";
        } else if (!this.isValidJavaIdentifier(name)) {
            name = "?!?INVALID_IDENTIFIER: " + name + "?!?";
        }
        this.formatter.buildInline(node);
        this.formatter.property("name", name);
        this.formatter.append(name);
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitIntegralLiteral(IntegralLiteral node) {
        this.parensOpen(node);
        String raw = node.rawValue();
        this.formatter.buildInline(node);
        this.formatter.property("value", raw);
        this.formatter.append(raw);
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitFloatingPointLiteral(FloatingPointLiteral node) {
        this.parensOpen(node);
        String raw = node.rawValue();
        this.formatter.buildInline(node);
        this.formatter.property("value", raw);
        this.formatter.append(raw);
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitBooleanLiteral(BooleanLiteral node) {
        this.parensOpen(node);
        String raw = node.rawValue();
        this.formatter.buildInline(node);
        this.formatter.property("value", raw);
        this.formatter.append(raw);
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitCharLiteral(CharLiteral node) {
        this.parensOpen(node);
        String raw = node.rawValue();
        this.formatter.buildInline(node);
        this.formatter.property("value", raw);
        this.formatter.append(raw);
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitStringLiteral(StringLiteral node) {
        this.parensOpen(node);
        String raw = node.rawValue();
        this.formatter.buildInline(node);
        this.formatter.property("value", raw);
        this.formatter.append(raw);
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitNullLiteral(NullLiteral node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.formatter.keyword("null");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    private void parensOpen(Expression node) {
        for (int i = 0; i < node.getIntendedParens(); ++i) {
            this.formatter.append("(");
        }
    }

    private void parensClose(Expression node) {
        for (int i = 0; i < node.getIntendedParens(); ++i) {
            this.formatter.append(")");
        }
    }

    @Override
    public boolean visitBinaryExpression(BinaryExpression node) {
        String symbol;
        this.parensOpen(node);
        try {
            symbol = node.astOperator().getSymbol();
        }
        catch (Exception e) {
            symbol = node.rawOperator();
        }
        this.formatter.buildInline(node);
        this.formatter.property("operator", symbol);
        this.formatter.nameNextElement("left");
        this.visit(node.rawLeft());
        this.formatter.space();
        this.formatter.operator(symbol);
        this.formatter.space();
        this.formatter.nameNextElement("right");
        this.visit(node.rawRight());
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitUnaryExpression(UnaryExpression node) {
        UnaryOperator op;
        this.parensOpen(node);
        try {
            op = node.astOperator();
            if (op == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.formatter.buildInline(node);
            this.visit(node.astOperand());
            this.formatter.closeInline();
            this.parensClose(node);
            return true;
        }
        this.formatter.buildInline(node);
        this.formatter.property("operator", op.getSymbol());
        this.formatter.property("postfix", op.isPostfix());
        if (!op.isPostfix()) {
            this.formatter.operator(op.getSymbol());
        }
        this.visit(node.astOperand());
        if (op.isPostfix()) {
            this.formatter.operator(op.getSymbol());
        }
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitCast(Cast node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.formatter.append("(");
        this.visit(node.rawTypeReference());
        this.formatter.append(")");
        this.formatter.space();
        this.visit(node.rawOperand());
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitInlineIfExpression(InlineIfExpression node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.formatter.nameNextElement("condition");
        this.visit(node.rawCondition());
        this.formatter.space();
        this.formatter.operator("?");
        this.formatter.space();
        this.formatter.nameNextElement("ifTrue");
        this.visit(node.rawIfTrue());
        this.formatter.space();
        this.formatter.operator(":");
        this.formatter.space();
        this.formatter.nameNextElement("ifFalse");
        this.visit(node.rawIfFalse());
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitInstanceOf(InstanceOf node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.formatter.nameNextElement("operand");
        this.visit(node.rawObjectReference());
        this.formatter.space();
        this.formatter.keyword("instanceof");
        this.formatter.space();
        this.formatter.nameNextElement("type");
        this.visit(node.rawTypeReference());
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitConstructorInvocation(ConstructorInvocation node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        if (node.rawQualifier() != null) {
            this.formatter.nameNextElement("qualifier");
            this.visit(node.rawQualifier());
            this.formatter.append(".");
        }
        this.formatter.keyword("new");
        this.formatter.space();
        this.visitAll(node.rawConstructorTypeArguments(), ", ", "<", ">");
        this.formatter.nameNextElement("type");
        this.visit(node.rawTypeReference());
        this.formatter.append("(");
        this.visitAll(node.rawArguments(), ", ", "", "");
        this.formatter.append(")");
        if (node.rawAnonymousClassBody() != null) {
            this.formatter.space();
            this.formatter.startSuppressBlock();
            this.visit(node.rawAnonymousClassBody());
            this.formatter.endSuppressBlock();
        }
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitMethodInvocation(MethodInvocation node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        if (node.rawOperand() != null) {
            this.formatter.nameNextElement("operand");
            this.visit(node.rawOperand());
            this.formatter.append(".");
        }
        this.visitAll(node.rawMethodTypeArguments(), ", ", "<", ">");
        this.formatter.nameNextElement("methodName");
        this.visit(node.astName());
        this.formatter.append("(");
        this.visitAll(node.rawArguments(), ", ", "", "");
        this.formatter.append(")");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitSelect(Select node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        if (node.rawOperand() != null) {
            this.formatter.nameNextElement("operand");
            this.visit(node.rawOperand());
            this.formatter.append(".");
        }
        this.formatter.nameNextElement("selected");
        this.visit(node.astIdentifier());
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitArrayAccess(ArrayAccess node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.visit(node.rawOperand());
        this.formatter.append("[");
        this.visit(node.rawIndexExpression());
        this.formatter.append("]");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitArrayCreation(ArrayCreation node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.formatter.keyword("new");
        this.formatter.space();
        this.visit(node.rawComponentTypeReference());
        this.visitAll(node.rawDimensions(), "", "", "");
        if (node.rawInitializer() != null) {
            this.formatter.space();
            this.visit(node.rawInitializer());
        }
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitAnnotationValueArray(AnnotationValueArray node) {
        this.formatter.buildInline(node);
        this.formatter.append("{");
        this.visitAll(node.rawValues(), ", ", "", "");
        this.formatter.append("}");
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitArrayInitializer(ArrayInitializer node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.formatter.append("{");
        this.visitAll(node.rawExpressions(), ", ", "", "");
        this.formatter.append("}");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitArrayDimension(ArrayDimension node) {
        this.formatter.buildInline(node);
        this.formatter.append("[");
        this.visit(node.rawDimension());
        this.formatter.append("]");
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitClassLiteral(ClassLiteral node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        this.visit(node.rawTypeReference());
        this.formatter.append(".");
        this.formatter.keyword("class");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitSuper(Super node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        if (node.rawQualifier() != null) {
            this.visit(node.rawQualifier());
            this.formatter.append(".");
        }
        this.formatter.keyword("super");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitThis(This node) {
        this.parensOpen(node);
        this.formatter.buildInline(node);
        if (node.rawQualifier() != null) {
            this.visit(node.rawQualifier());
            this.formatter.append(".");
        }
        this.formatter.keyword("this");
        this.formatter.closeInline();
        this.parensClose(node);
        return true;
    }

    @Override
    public boolean visitExpressionStatement(ExpressionStatement node) {
        this.formatter.buildBlock(node);
        this.visit(node.rawExpression());
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitLabelledStatement(LabelledStatement node) {
        this.formatter.buildBlock(node);
        this.formatter.nameNextElement("label");
        this.visit(node.astLabel());
        this.formatter.append(":");
        this.visit(node.rawStatement());
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitIf(If node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("if");
        this.formatter.space();
        this.formatter.append("(");
        this.formatter.nameNextElement("condition");
        this.visit(node.rawCondition());
        this.formatter.append(")");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.formatter.nameNextElement("ifTrue");
        this.visit(node.rawStatement());
        this.formatter.endSuppressBlock();
        if (node.rawElseStatement() != null) {
            this.formatter.space();
            this.formatter.keyword("else");
            this.formatter.space();
            this.formatter.startSuppressBlock();
            this.formatter.nameNextElement("ifFalse");
            this.visit(node.rawElseStatement());
            this.formatter.endSuppressBlock();
        }
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitFor(For node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("for");
        this.formatter.space();
        this.formatter.append("(");
        if (node.isVariableDeclarationBased()) {
            this.formatter.nameNextElement("init");
            this.visit(node.rawVariableDeclaration());
        } else {
            this.visitAll("init", node.rawExpressionInits(), ", ", "", "");
        }
        this.formatter.append(";");
        if (node.rawCondition() != null) {
            this.formatter.space();
            this.formatter.nameNextElement("condition");
            this.visit(node.rawCondition());
        }
        this.formatter.append(";");
        if (!node.rawUpdates().isEmpty()) {
            this.formatter.space();
            this.visitAll(node.rawUpdates(), ", ", "", "");
        }
        this.formatter.append(")");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawStatement());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitForEach(ForEach node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("for");
        this.formatter.space();
        this.formatter.append("(");
        this.formatter.nameNextElement("variable");
        this.visit(node.rawVariable());
        this.formatter.space();
        this.formatter.append(":");
        this.formatter.space();
        this.formatter.nameNextElement("iterable");
        this.visit(node.rawIterable());
        this.formatter.append(")");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawStatement());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitTry(Try node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("try");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.formatter.nameNextElement("try");
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.visitAll(node.rawCatches(), " ", " ", "");
        if (node.rawFinally() != null) {
            this.formatter.space();
            this.formatter.keyword("finally");
            this.formatter.space();
            this.formatter.startSuppressBlock();
            this.formatter.nameNextElement("finally");
            this.visit(node.rawFinally());
            this.formatter.endSuppressBlock();
        }
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitCatch(Catch node) {
        this.formatter.buildInline(node);
        this.formatter.keyword("catch");
        this.formatter.space();
        this.formatter.append("(");
        this.visit(node.rawExceptionDeclaration());
        this.formatter.append(")");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitWhile(While node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("while");
        this.formatter.space();
        this.formatter.append("(");
        this.formatter.nameNextElement("condition");
        this.visit(node.rawCondition());
        this.formatter.append(")");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawStatement());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitDoWhile(DoWhile node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("do");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawStatement());
        this.formatter.endSuppressBlock();
        this.formatter.space();
        this.formatter.keyword("while");
        this.formatter.space();
        this.formatter.append("(");
        this.formatter.nameNextElement("condition");
        this.visit(node.rawCondition());
        this.formatter.append(")");
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitSynchronized(Synchronized node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("synchronized");
        this.formatter.space();
        this.formatter.append("(");
        this.formatter.nameNextElement("lock");
        this.visit(node.rawLock());
        this.formatter.append(")");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.astBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitBlock(Block node) {
        this.formatter.buildBlock(node);
        this.formatter.append("{");
        this.formatter.buildBlock(null);
        this.visitAll(node.rawContents(), "", "", "");
        this.formatter.closeBlock();
        this.formatter.append("}");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitAssert(Assert node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("assert");
        this.formatter.space();
        this.formatter.nameNextElement("assertion");
        this.visit(node.rawAssertion());
        if (node.rawMessage() != null) {
            this.formatter.append(":");
            this.formatter.space();
            this.formatter.nameNextElement("message");
            this.visit(node.rawMessage());
        }
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitEmptyStatement(EmptyStatement node) {
        this.formatter.buildBlock(node);
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitSwitch(Switch node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("switch");
        this.formatter.space();
        this.formatter.append("(");
        this.formatter.nameNextElement("operand");
        this.visit(node.rawCondition());
        this.formatter.append(")");
        this.formatter.space();
        Node body = node.rawBody();
        if (!(body instanceof Block)) {
            this.visit(body);
            this.formatter.closeBlock();
            return true;
        }
        this.formatter.append("{");
        this.formatter.buildBlock(null);
        for (Node child : ((Block)body).rawContents()) {
            if (child instanceof Case || child instanceof Default) {
                this.formatter.startSuppressIndent();
                this.visit(child);
                this.formatter.endSuppressIndent();
                continue;
            }
            this.visit(child);
        }
        this.formatter.closeBlock();
        this.formatter.append("}");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitCase(Case node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("case");
        this.formatter.space();
        this.formatter.nameNextElement("condition");
        this.visit(node.rawCondition());
        this.formatter.append(":");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitDefault(Default node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("default");
        this.formatter.append(":");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitBreak(Break node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("break");
        if (node.astLabel() != null) {
            this.formatter.space();
            this.visit(node.astLabel());
        }
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitContinue(Continue node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("continue");
        if (node.astLabel() != null) {
            this.formatter.space();
            this.visit(node.astLabel());
        }
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitReturn(Return node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("return");
        if (node.rawValue() != null) {
            this.formatter.space();
            this.visit(node.rawValue());
        }
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitThrow(Throw node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("throw");
        this.formatter.space();
        this.visit(node.rawThrowable());
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitVariableDeclaration(VariableDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.rawDefinition());
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitVariableDefinition(VariableDefinition node) {
        this.formatter.buildInline(node);
        this.formatter.property("varargs", node.astVarargs());
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.nameNextElement("type");
        this.visit(node.rawTypeReference());
        if (node.astVarargs()) {
            this.formatter.append("...");
        }
        this.formatter.space();
        this.visitAll(node.rawVariables(), ", ", "", "");
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
        this.formatter.buildInline(node);
        this.formatter.property("arrayDimensions", node.astArrayDimensions());
        this.formatter.nameNextElement("varName");
        this.visit(node.astName());
        for (int i = 0; i < node.astArrayDimensions(); ++i) {
            this.formatter.append("[]");
        }
        if (node.rawInitializer() != null) {
            this.formatter.space();
            this.formatter.append("=");
            this.formatter.space();
            this.visit(node.rawInitializer());
        }
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitTypeVariable(TypeVariable node) {
        this.formatter.buildInline(node);
        this.visit(node.astName());
        if (!node.rawExtending().isEmpty()) {
            this.formatter.space();
            this.formatter.keyword("extends");
            this.visitAll(node.rawExtending(), " & ", " ", "");
        }
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitKeywordModifier(KeywordModifier node) {
        this.formatter.buildInline(node);
        this.formatter.property("modifier", node.astName());
        if (node.astName() == null || node.astName().isEmpty()) {
            this.formatter.fail("MISSING_MODIFIER");
        } else {
            this.formatter.keyword(node.astName());
        }
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitModifiers(Modifiers node) {
        this.formatter.buildInline(node);
        this.visitAll(node.rawAnnotations(), "", "", "");
        this.visitAll(node.rawKeywords(), " ", "", "");
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitAnnotation(Annotation node) {
        this.formatter.buildBlock(node);
        this.formatter.append("@");
        this.visit(node.rawAnnotationTypeReference());
        this.visitAll(node.rawElements(), ", ", "(", ")");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitAnnotationElement(AnnotationElement node) {
        this.formatter.buildInline(node);
        if (node.astName() != null) {
            this.formatter.nameNextElement("name");
            this.visit(node.astName());
            this.formatter.space();
            this.formatter.append("=");
            this.formatter.space();
        }
        this.visit(node.astValue());
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitEnumTypeBody(EnumTypeBody node) {
        this.formatter.buildBlock(node);
        this.formatter.append("{");
        this.formatter.buildBlock(null);
        this.visitAll("constant", node.rawConstants(), ",\n", "", "");
        if (!node.rawMembers().isEmpty()) {
            this.formatter.append(";");
            this.formatter.verticalSpace();
        }
        this.visitAll(node.rawMembers(), "\n", "", "");
        this.formatter.closeBlock();
        this.formatter.append("}");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitNormalTypeBody(NormalTypeBody node) {
        this.formatter.buildBlock(node);
        this.formatter.append("{");
        this.formatter.buildBlock(null);
        this.visitAll(node.rawMembers(), "\n", "", "");
        this.formatter.closeBlock();
        this.formatter.append("}");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitMethodDeclaration(MethodDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.visitAll(node.rawTypeVariables(), ", ", "<", ">");
        if (!node.rawTypeVariables().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.nameNextElement("returnType");
        this.visit(node.rawReturnTypeReference());
        this.formatter.space();
        this.formatter.nameNextElement("methodName");
        this.visit(node.astMethodName());
        this.formatter.append("(");
        this.visitAll("parameter", node.rawParameters(), ", ", "", "");
        this.formatter.append(")");
        if (!node.rawThrownTypeReferences().isEmpty()) {
            this.formatter.space();
            this.formatter.keyword("throws");
            this.visitAll("throws", node.rawThrownTypeReferences(), ", ", " ", "");
        }
        if (node.rawBody() == null) {
            this.formatter.append(";");
        } else {
            this.formatter.space();
            this.formatter.startSuppressBlock();
            this.visit(node.rawBody());
            this.formatter.endSuppressBlock();
        }
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.visitAll(node.rawTypeVariables(), ", ", "<", ">");
        if (!node.rawTypeVariables().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.nameNextElement("typeName");
        this.visit(node.astTypeName());
        this.formatter.append("(");
        this.visitAll("parameter", node.rawParameters(), ", ", "", "");
        this.formatter.append(")");
        this.formatter.space();
        if (!node.rawThrownTypeReferences().isEmpty()) {
            this.formatter.keyword("throws");
            this.visitAll("throws", node.rawThrownTypeReferences(), ", ", " ", " ");
        }
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        if (node.rawBody() == null) {
            this.formatter.append(";");
        }
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitSuperConstructorInvocation(SuperConstructorInvocation node) {
        this.formatter.buildBlock(node);
        if (node.rawQualifier() != null) {
            this.formatter.nameNextElement("qualifier");
            this.visit(node.rawQualifier());
            this.formatter.append(".");
        }
        this.visitAll(node.rawConstructorTypeArguments(), ", ", "<", ">");
        this.formatter.keyword("super");
        this.formatter.append("(");
        this.visitAll(node.rawArguments(), ", ", "", "");
        this.formatter.append(")");
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation node) {
        this.formatter.buildBlock(node);
        this.visitAll(node.rawConstructorTypeArguments(), ", ", "<", ">");
        this.formatter.keyword("this");
        this.formatter.append("(");
        this.visitAll(node.rawArguments(), ", ", "", "");
        this.formatter.append(")");
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitInstanceInitializer(InstanceInitializer node) {
        this.formatter.buildBlock(node);
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitStaticInitializer(StaticInitializer node) {
        this.formatter.buildBlock(node);
        this.formatter.keyword("static");
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitClassDeclaration(ClassDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.keyword("class");
        this.formatter.space();
        this.formatter.nameNextElement("typeName");
        this.visit(node.astName());
        this.visitAll(node.rawTypeVariables(), ", ", "<", ">");
        this.formatter.space();
        if (node.rawExtending() != null) {
            this.formatter.keyword("extends");
            this.formatter.space();
            this.formatter.nameNextElement("extends");
            this.visit(node.rawExtending());
            this.formatter.space();
        }
        if (!node.rawImplementing().isEmpty()) {
            this.formatter.keyword("implements");
            this.visitAll("implements", node.rawImplementing(), ", ", " ", " ");
        }
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitInterfaceDeclaration(InterfaceDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.keyword("interface");
        this.formatter.space();
        this.formatter.nameNextElement("typeName");
        this.visit(node.astName());
        this.visitAll(node.rawTypeVariables(), ", ", "<", ">");
        this.formatter.space();
        if (!node.rawExtending().isEmpty()) {
            this.formatter.keyword("extends");
            this.visitAll("extends", node.rawExtending(), ", ", " ", " ");
        }
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitEnumDeclaration(EnumDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.keyword("enum");
        this.formatter.space();
        this.formatter.nameNextElement("typeName");
        this.visit(node.astName());
        this.formatter.space();
        if (!node.rawImplementing().isEmpty()) {
            this.formatter.keyword("implements");
            this.visitAll("implements", node.rawImplementing(), ", ", " ", " ");
        }
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitEnumConstant(EnumConstant node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildInline(node);
        this.visitAllSuppressed(node.rawAnnotations(), "\n", "", "\n");
        this.formatter.nameNextElement("name");
        this.visit(node.astName());
        this.visitAll(node.rawArguments(), ", ", "(", ")");
        if (node.rawBody() != null) {
            this.formatter.space();
            this.formatter.startSuppressBlock();
            this.visit(node.rawBody());
            this.formatter.endSuppressBlock();
        }
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitAnnotationDeclaration(AnnotationDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.append("@");
        this.formatter.keyword("interface");
        this.formatter.space();
        this.formatter.nameNextElement("constantName");
        this.visit(node.astName());
        this.formatter.space();
        this.formatter.startSuppressBlock();
        this.visit(node.rawBody());
        this.formatter.endSuppressBlock();
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visit(node.astModifiers());
        if (!node.astModifiers().rawKeywords().isEmpty()) {
            this.formatter.space();
        }
        this.formatter.nameNextElement("returnType");
        this.visit(node.rawReturnTypeReference());
        this.formatter.space();
        this.formatter.nameNextElement("methodName");
        this.visit(node.astMethodName());
        this.formatter.append("(");
        this.formatter.append(")");
        if (node.rawDefaultValue() != null) {
            this.formatter.space();
            this.formatter.keyword("default");
            this.formatter.space();
            this.formatter.nameNextElement("default");
            this.visit(node.rawDefaultValue());
        }
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitCompilationUnit(CompilationUnit node) {
        this.formatter.buildBlock(node);
        if (node.rawPackageDeclaration() != null) {
            this.visit(node.rawPackageDeclaration());
            if (!node.rawTypeDeclarations().isEmpty() || !node.rawImportDeclarations().isEmpty()) {
                this.formatter.verticalSpace();
            }
        }
        this.visitAll(node.rawImportDeclarations(), "", "", "");
        if (!node.rawTypeDeclarations().isEmpty() && !node.rawImportDeclarations().isEmpty()) {
            this.formatter.verticalSpace();
        }
        this.visitAll(node.rawTypeDeclarations(), "\n", "", "");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitPackageDeclaration(PackageDeclaration node) {
        this.visit(node.rawJavadoc());
        this.formatter.buildBlock(node);
        this.visitAll(node.rawAnnotations(), "", "", "");
        this.formatter.keyword("package");
        this.formatter.space();
        this.visitAll(node.rawParts(), ".", "", "");
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitImportDeclaration(ImportDeclaration node) {
        this.formatter.buildBlock(node);
        this.formatter.property("static", node.astStaticImport());
        this.formatter.property("star", node.astStarImport());
        this.formatter.keyword("import");
        this.formatter.space();
        if (node.astStaticImport()) {
            this.formatter.keyword("static");
            this.formatter.space();
        }
        this.visitAll(node.rawParts(), ".", "", "");
        if (node.astStarImport()) {
            this.formatter.append(".*");
        }
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitParseArtefact(Node node) {
        this.formatter.buildInline(node);
        this.formatter.fail("ARTEFACT: " + node.getClass().getSimpleName());
        this.formatter.closeInline();
        return true;
    }

    @Override
    public boolean visitComment(Comment node) {
        this.formatter.buildBlock(node);
        this.formatter.append(node.astBlockComment() ? "/*" : "//");
        if (node.astContent() == null) {
            this.formatter.fail("MISSING_COMMENT");
        } else {
            this.formatter.append(node.astContent());
        }
        if (node.astBlockComment()) {
            this.formatter.append("*/");
        }
        this.formatter.closeBlock();
        return true;
    }

    @Override
    public boolean visitEmptyDeclaration(EmptyDeclaration node) {
        this.formatter.buildBlock(node);
        this.formatter.append(";");
        this.formatter.closeBlock();
        return true;
    }
}

