/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.DoubleValue;
import org.jetbrains.eval4j.Eval4jPackage$values$09c1b05a;
import org.jetbrains.eval4j.FloatValue;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.LongValue;
import org.jetbrains.eval4j.NOT_A_VALUE;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.VOID_VALUE;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.jdi.JDIFailureException;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class JdiPackage$jdiValues$95a87561 {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Frame<Value> makeInitialFrame(@JetValueParameter(name="methodNode") @NotNull MethodNode methodNode, @JetValueParameter(name="arguments") @NotNull List<? extends Value> arguments2) {
        void value2;
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        boolean isStatic = (methodNode.access & Opcodes.ACC_STATIC) != 0;
        Type[] params2 = Type.getArgumentTypes((String)methodNode.desc);
        boolean bl = arguments2.size() == (isStatic ? ((Object[])params2).length : ((Object[])params2).length + 1);
        if (KotlinPackage.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "Wrong number of arguments for " + methodNode + ": " + arguments2;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Frame frame = new Frame(methodNode.maxLocals, methodNode.maxStack);
        Type type2 = Type.getReturnType((String)methodNode.desc);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getReturnType(methodNode.desc)");
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)Eval4jPackage$values$09c1b05a.makeNotInitializedValue(type2));
        int index2 = 0;
        for (IndexedValue indexedValue : KotlinPackage.withIndex((Iterable)arguments2)) {
            int i = indexedValue.component1();
            Value arg = (Value)indexedValue.component2();
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)arg);
            if (arg.getSize() != 2) continue;
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE$);
        }
        while (index2 < methodNode.maxLocals) {
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE$);
        }
        return frame;
    }

    @NotNull
    public static final ObjectValue asValue(@JetValueParameter(name="$receiver", type="?") ObjectReference $receiver) {
        ObjectReference objectReference = $receiver;
        return Intrinsics.areEqual((Object)objectReference, null) ? Eval4jPackage$values$09c1b05a.getNULL_VALUE() : new ObjectValue($receiver, JdiPackage$jdiValues$95a87561.asType($receiver.type()));
    }

    @NotNull
    public static final Value asValue(@JetValueParameter(name="$receiver", type="?") com.sun.jdi.Value $receiver) {
        Value value2;
        com.sun.jdi.Value value3 = $receiver;
        if (Intrinsics.areEqual((Object)value3, null)) {
            value2 = Eval4jPackage$values$09c1b05a.getNULL_VALUE();
        } else if (value3 instanceof VoidValue) {
            value2 = VOID_VALUE.INSTANCE$;
        } else if (value3 instanceof BooleanValue) {
            int n = ((BooleanValue)$receiver).intValue();
            Type type2 = Type.BOOLEAN_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.BOOLEAN_TYPE");
            value2 = new IntValue(n, type2);
        } else if (value3 instanceof ByteValue) {
            int n = ((ByteValue)$receiver).intValue();
            Type type3 = Type.BYTE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.BYTE_TYPE");
            value2 = new IntValue(n, type3);
        } else if (value3 instanceof ShortValue) {
            int n = ((ShortValue)$receiver).intValue();
            Type type4 = Type.SHORT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"Type.SHORT_TYPE");
            value2 = new IntValue(n, type4);
        } else if (value3 instanceof CharValue) {
            int n = ((CharValue)$receiver).intValue();
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.CHAR_TYPE");
            value2 = new IntValue(n, type5);
        } else if (value3 instanceof IntegerValue) {
            int n = ((IntegerValue)$receiver).intValue();
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"Type.INT_TYPE");
            value2 = new IntValue(n, type6);
        } else if (value3 instanceof com.sun.jdi.LongValue) {
            value2 = new LongValue(((com.sun.jdi.LongValue)$receiver).longValue());
        } else if (value3 instanceof com.sun.jdi.FloatValue) {
            value2 = new FloatValue(((com.sun.jdi.FloatValue)$receiver).floatValue());
        } else if (value3 instanceof com.sun.jdi.DoubleValue) {
            value2 = new DoubleValue(((com.sun.jdi.DoubleValue)$receiver).doubleValue());
        } else if (value3 instanceof ObjectReference) {
            value2 = JdiPackage$jdiValues$95a87561.asValue((ObjectReference)$receiver);
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $receiver, null, 2, null);
        }
        return value2;
    }

    @NotNull
    public static final Type asType(@JetValueParameter(name="$receiver") com.sun.jdi.Type $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type2 = Type.getType((String)$receiver.signature());
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(this.signature())");
        return type2;
    }

    @Nullable
    public static final ObjectReference getJdiObj(@JetValueParameter(name="$receiver") Value $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ObjectReference)Eval4jPackage$values$09c1b05a.obj$default($receiver, null, 1);
    }

    @Nullable
    public static final ClassObjectReference getJdiClass(@JetValueParameter(name="$receiver") Value $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ClassObjectReference)JdiPackage$jdiValues$95a87561.getJdiObj($receiver);
    }

    @Nullable
    public static final com.sun.jdi.Value asJdiValue(@JetValueParameter(name="$receiver") Value $receiver, @JetValueParameter(name="vm") @NotNull VirtualMachine vm, @JetValueParameter(name="expectedType") @NotNull Type expectedType) {
        com.sun.jdi.Value value2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Value value3 = $receiver;
        if (Intrinsics.areEqual((Object)value3, (Object)Eval4jPackage$values$09c1b05a.getNULL_VALUE())) {
            value2 = null;
        } else if (Intrinsics.areEqual((Object)value3, (Object)VOID_VALUE.INSTANCE$)) {
            value2 = vm.mirrorOfVoid();
        } else if (value3 instanceof IntValue) {
            PrimitiveValue primitiveValue;
            Type type2 = expectedType;
            if (Intrinsics.areEqual((Object)type2, (Object)Type.BOOLEAN_TYPE)) {
                primitiveValue = vm.mirrorOf(Eval4jPackage$values$09c1b05a.getBoolean($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.BYTE_TYPE)) {
                primitiveValue = vm.mirrorOf((byte)Eval4jPackage$values$09c1b05a.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.SHORT_TYPE)) {
                primitiveValue = vm.mirrorOf((short)Eval4jPackage$values$09c1b05a.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.CHAR_TYPE)) {
                primitiveValue = vm.mirrorOf((char)Eval4jPackage$values$09c1b05a.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.INT_TYPE)) {
                primitiveValue = vm.mirrorOf(Eval4jPackage$values$09c1b05a.getInt($receiver));
            } else {
                throw (Throwable)new JDIFailureException("Unknown value type: " + $receiver, null, 2, null);
            }
            value2 = primitiveValue;
        } else if (value3 instanceof LongValue) {
            value2 = vm.mirrorOf(((Number)((AbstractValue)$receiver).getValue()).longValue());
        } else if (value3 instanceof FloatValue) {
            value2 = vm.mirrorOf(((Number)((AbstractValue)$receiver).getValue()).floatValue());
        } else if (value3 instanceof DoubleValue) {
            value2 = vm.mirrorOf(((Number)((AbstractValue)$receiver).getValue()).doubleValue());
        } else if (value3 instanceof ObjectValue) {
            Object v = ((AbstractValue)$receiver).getValue();
            if (v == null) {
                throw new TypeCastException("kotlin.Any? cannot be cast to com.sun.jdi.ObjectReference");
            }
            value2 = (ObjectReference)v;
        } else if (value3 instanceof NewObjectValue) {
            Object object = Eval4jPackage$values$09c1b05a.obj$default($receiver, null, 1);
            if (object == null) {
                throw new TypeCastException("kotlin.Any? cannot be cast to com.sun.jdi.ObjectReference");
            }
            value2 = (ObjectReference)object;
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $receiver, null, 2, null);
        }
        return value2;
    }
}

