/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.transformer;

import kotlin.jvm.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public abstract class MethodTransformer {
    @KotlinSignature(value="fun <V : Value?> runAnalyzer(analyzer: Analyzer<V>, internalClassName: String, node: MethodNode): Array<Frame<V>?>")
    @NotNull
    protected static <V extends Value> Frame<V>[] runAnalyzer(@NotNull Analyzer<V> analyzer, @NotNull String internalClassName, @NotNull MethodNode node2) {
        Frame[] frameArray;
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        try {
            frameArray = analyzer.analyze(internalClassName, node2);
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        if (frameArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "runAnalyzer"));
        }
        return frameArray;
    }

    @KotlinSignature(value="fun <V : Value?> analyze(internalClassName: String, node: MethodNode, interpreter: Interpreter<V>): Array<Frame<V>?>")
    @NotNull
    protected static <V extends Value> Frame<V>[] analyze(@NotNull String internalClassName, @NotNull MethodNode node2, @NotNull Interpreter<V> interpreter) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        Frame<V>[] frameArray = MethodTransformer.runAnalyzer(new Analyzer(interpreter), internalClassName, node2);
        if (frameArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer", "analyze"));
        }
        return frameArray;
    }

    public abstract void transform(@NotNull String var1, @NotNull MethodNode var2);
}

