/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetValueArgument;

public class KotlinLambdaUnwrapper
extends KotlinUnwrapRemoveBase {
    public KotlinLambdaUnwrapper(String key) {
        super(key);
    }

    private static JetElement getLambdaEnclosingElement(@NotNull JetFunctionLiteralExpression lambda2) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinLambdaUnwrapper", "getLambdaEnclosingElement"));
        }
        PsiElement parent = lambda2.getParent();
        if (parent instanceof JetValueArgument) {
            return (JetElement)PsiTreeUtil.getParentOfType((PsiElement)parent, JetCallExpression.class, (boolean)true);
        }
        if (parent instanceof JetCallExpression) {
            return (JetElement)parent;
        }
        if (parent instanceof JetProperty && ((JetProperty)parent).isLocal()) {
            return (JetElement)parent;
        }
        return lambda2;
    }

    public boolean isApplicableTo(PsiElement e) {
        if (!(e instanceof JetFunctionLiteralExpression)) {
            return false;
        }
        JetFunctionLiteralExpression lambda2 = (JetFunctionLiteralExpression)e;
        JetBlockExpression body2 = lambda2.getBodyExpression();
        JetElement enclosingElement = KotlinLambdaUnwrapper.getLambdaEnclosingElement((JetFunctionLiteralExpression)e);
        if (body2 == null || enclosingElement == null) {
            return false;
        }
        return this.canExtractExpression(body2, (JetElement)enclosingElement.getParent());
    }

    protected void doUnwrap(PsiElement element, KotlinUnwrapRemoveBase.Context context2) throws IncorrectOperationException {
        JetFunctionLiteralExpression lambda2 = (JetFunctionLiteralExpression)element;
        JetBlockExpression body2 = lambda2.getBodyExpression();
        JetElement enclosingExpression = KotlinLambdaUnwrapper.getLambdaEnclosingElement(lambda2);
        context2.extractFromBlock(body2, enclosingExpression);
        context2.delete((PsiElement)enclosingExpression);
    }
}

