/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.DeclarationDescriptorLookupObjectImpl;
import org.jetbrains.kotlin.idea.core.completion.DeclarationDescriptorLookupObject;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.NamePackage;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"v\u0006)y\"*\u001a;EK\u000ed\u0017M]1uS>t'+Z7pi\u0016tWm]:XK&<\u0007.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*Q1m\\7qY\u0016$\u0018n\u001c8\u000b)1{wn[;q\u000b2,W.\u001a8u/\u0016Lw\r[3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*Y1m\u001c3f\u0013:\u001c\u0018n\u001a5u\u0015\u0019awn\\6va*1A(\u001b8jizRAAZ5mK*9!*\u001a;GS2,'b\u00019tS*Y\u0011.\u001c9peR\u001c\u0015m\u00195f\u0015-IU\u000e]8si\u000e\u000b7\r[3\u000bW)+G\u000fR3dY\u0006\u0014\u0018\r^5p]J+Wn\u001c;f]\u0016\u001c8oV3jO\",'\u000fJ%na>\u0014HoQ1dQ\u0016TQ\"];bY&4\u0017.\u001a3OC6,'\u0002\u00047p_.,\bo\u00142kK\u000e$(bA!os*11\u000b\u001e:j]\u001eTAA[1wC*!A.\u00198h\u0015\u0019y%M[3di*)q/Z5hQ*9Q\r\\3nK:$(\"\u0004'p_.,\b/\u00127f[\u0016tGO\u0003\u0004XK&<\u0007\u000e\u001e\u0006'\u0015\u0016$H)Z2mCJ\fG/[8o%\u0016lw\u000e^3oKN\u001cx+Z5hQ\u0016\u0014HeV3jO\"$(6\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A9!\u0002\u0002\u0005\u0007!!QA\u0001C\u0004\u0011\u0013)!\u0001\u0002\u0003\t\u000b\u0015\u0019A\u0011\u0002\u0005\u0004\u0019\u0001)!\u0001B\u0001\t\u000f\u0015\u0019A1\u0002E\u0007\u0019\u0001)!\u0001b\u0003\t\u000e\u0015\u0019AQ\u0001\u0005\t\u0019\u0001)!\u0001\u0002\u0002\t\u0012\u0015\t\u00012A\u0003\u0004\t!A!\u0002\u0004\u0001\u0006\u0007\u0011A\u0001R\u0003\u0007\u0001\u000b\u0005A1\"\u0002\u0002\u0005\u0014!]QA\u0001\u0003\u000b\u0011+)!\u0001\u0002\u0006\t\u0019\u0015\u0019A\u0011\u0002E\u000e\u0019\u0001)1\u0001\"\u0002\t\u001d1\u0001QA\u0001\u0003\u0003\u0011;)!\u0001\"\u0003\t\u001c\u0011\tARA\r\u0003\u000b\u0005AQ\u0001\b\u0005\u001d\u001d5ZA!\u0019\u0003\u0019\r\u0005\u0012Q!\u0001\u0005\u0007+\u000e!Qa\u0001\u0003\u0007\u0013\u0005Ai!L\u0006\u0005C\u0012Az!\t\u0002\u0006\u0003!9Qk\u0001\u0003\u0006\u0007\u0011=\u0011\"\u0001E\b[Q!\u0011\u0001G\u0005\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001C\r)\u0011\u0001C\u0005\r\u0002E\u001bQ\u0001B\u0005\n\u0003!UQ\"\u0001\u0005\f[M!1\u0002'\u0007\u001e\u000e\u0011\u0001\u0001\"D\u0007\u0003\u000b\u0005A9\u0002U\u0002\u0001C\t)\u0011\u0001\u0003\u0007R\u0007\u0015!I\"C\u0001\t\u001a5\t\u0001\"D[\u0015\u000bO!1\u001d\u0001M\u0006;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0003#\u000e)A1B\u0005\u0002\t\u0001i\u0011\u0001#\u0004"})
public final class JetDeclarationRemotenessWeigher
extends LookupElementWeigher {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ImportCache importCache;
    private final JetFile file;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetDeclarationRemotenessWeigher.class);
    }

    @NotNull
    public Weight weigh(@JetValueParameter(name="element") @NotNull LookupElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Object o = element.getObject();
        if (o instanceof DeclarationDescriptorLookupObjectImpl) {
            PsiFile elementFile;
            PsiElement psiElement = ((DeclarationDescriptorLookupObjectImpl)o).getPsiElement();
            Object object = elementFile = psiElement != null ? psiElement.getContainingFile() : null;
            if (elementFile instanceof JetFile && Intrinsics.areEqual((Object)((JetFile)elementFile).getOriginalFile(), (Object)this.file)) {
                return Weight.thisFile;
            }
        }
        Object object = o;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"o");
        String qualifiedName = this.qualifiedName(object);
        if (qualifiedName != null && NamePackage.isValidJavaFqName(qualifiedName)) {
            Weight weight;
            ImportPath importPath = new ImportPath(qualifiedName);
            FqName fqName2 = importPath.fqnPart();
            if (KotlinPackage.isNotEmpty(JavaToKotlinClassMap.INSTANCE.mapPlatformClass(fqName2))) {
                weight = Weight.notToBeUsedInKotlin;
            } else {
                Project project = this.file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                if (ImportInsertHelper.Companion.getInstance(project).isImportedWithDefault(importPath, this.file)) {
                    weight = Weight.kotlinDefaultImport;
                } else {
                    FqName fqName3 = fqName2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName");
                    if (this.importCache.isImportedWithPreciseImport(fqName3)) {
                        weight = Weight.preciseImport;
                    } else {
                        FqName fqName4 = fqName2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"fqName");
                        if (this.importCache.isImportedWithAllUnderImport(fqName4)) {
                            weight = Weight.allUnderImport;
                        } else {
                            FqName fqName5 = fqName2.parent();
                            Intrinsics.checkExpressionValueIsNotNull((Object)fqName5, (String)"fqName.parent()");
                            weight = this.importCache.hasPreciseImportFromPackage(fqName5) ? Weight.hasImportFromSamePackage : Weight.notImported;
                        }
                    }
                }
            }
            return weight;
        }
        return Weight.default;
    }

    private final String qualifiedName(@JetValueParameter(name="lookupObject") Object lookupObject) {
        Object object = lookupObject;
        return object instanceof DeclarationDescriptorLookupObject ? DescriptorUtils.getFqName(((DeclarationDescriptorLookupObject)lookupObject).getDescriptor()).toString() : (object instanceof PsiClass ? ((PsiClass)lookupObject).getQualifiedName() : (String)null);
    }

    public JetDeclarationRemotenessWeigher(@JetValueParameter(name="file") @NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super("kotlin.declarationRemoteness");
        this.file = file;
        this.importCache = new ImportCache();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"y\u0004)1q+Z5hQRTqDS3u\t\u0016\u001cG.\u0019:bi&|gNU3n_R,g.Z:t/\u0016Lw\r[3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!bY8na2,G/[8o\u0015\u0011)e.^7\u000b\rqJg.\u001b;?\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u0011QD\u0017n\u001d$jY\u0016T1c[8uY&tG)\u001a4bk2$\u0018*\u001c9peRTQ\u0002\u001d:fG&\u001cX-S7q_J$(BD1mYVsG-\u001a:J[B|'\u000f\u001e\u0006\bI\u00164\u0017-\u001e7u\u0015aA\u0017m]%na>\u0014HO\u0012:p[N\u000bW.\u001a)bG.\fw-\u001a\u0006\f]>$\u0018*\u001c9peR,GMC\no_R$vNQ3Vg\u0016$\u0017J\\&pi2Lg\u000e\u0013\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0003!%QA\u0001C\u0005\u0011\u0015)!\u0001B\u0003\t\f\u0011\t\r\u0001D\u0002\u001a\r\u0015\t\u0001\u0002B\u0005\u0004\u0013\t)\u0011\u0001C\u00021\rA6\u0001g\u0002Y\ba!\u0001\f\u0002M\u00051\u0014UzQA\u0004\u0003b\u0002a!\u0011EA\u0003\u0002\u0011\r\t6a\u0002\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\f5\tAQ\u0001"})
    private static final class Weight
    extends Enum<Weight> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ Weight thisFile;
        public static final /* enum */ Weight kotlinDefaultImport;
        public static final /* enum */ Weight preciseImport;
        public static final /* enum */ Weight allUnderImport;
        public static final /* enum */ Weight default;
        public static final /* enum */ Weight hasImportFromSamePackage;
        public static final /* enum */ Weight notImported;
        public static final /* enum */ Weight notToBeUsedInKotlin;
        private static final /* synthetic */ Weight[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(Weight.class);
            Weight[] weightArray = new Weight[8];
            Weight[] weightArray2 = weightArray;
            weightArray[0] = thisFile = new Weight();
            weightArray[1] = kotlinDefaultImport = new Weight();
            weightArray[2] = preciseImport = new Weight();
            weightArray[3] = allUnderImport = new Weight();
            weightArray[4] = default = new Weight();
            weightArray[5] = hasImportFromSamePackage = new Weight();
            weightArray[6] = notImported = new Weight();
            weightArray[7] = notToBeUsedInKotlin = new Weight();
            $VALUES = weightArray;
        }

        public static Weight[] values() {
            return (Weight[])$VALUES.clone();
        }

        public static Weight valueOf(String string) {
            return Enum.valueOf(Weight.class, string);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"/\u0006)Y\u0011*\u001c9peR\u001c\u0015m\u00195f\u0015}QU\r\u001e#fG2\f'/\u0019;j_:\u0014V-\\8uK:,7o],fS\u001eDWM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015)\u0019w.\u001c9mKRLwN\u001c\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\bbY2,f\u000eZ3s\u00136\u0004xN\u001d;t\u0015\u001dA\u0015m\u001d5TKRTAA[1wC*!Q\u000f^5m\u0015\u00191\u0015OT1nK*!a.Y7f\u0015U\u0001(/Z2jg\u0016LU\u000e]8siB\u000b7m[1hKNTa\u0002\u001d:fG&\u001cX-S7q_J$8OC\u000eiCN\u0004&/Z2jg\u0016LU\u000e]8si\u001a\u0013x.\u001c)bG.\fw-\u001a\u0006\fa\u0006\u001c7.Y4f\u001d\u0006lWMC\u0004C_>dW-\u00198\u000b9%\u001c\u0018*\u001c9peR,GmV5uQ\u0006cG.\u00168eKJLU\u000e]8si*Y\u0012n]%na>\u0014H/\u001a3XSRD\u0007K]3dSN,\u0017*\u001c9peR\u0014(B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0005!\u0005Q!\u0001E\u0006\u000b\t!Q\u0001\u0003\u0004\u0006\u0007\u0011-\u0001\"\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0004\u0006\u0007\u00115\u0001R\u0002\u0007\u0001\u000b\t!Y\u0001C\u0003\u0006\u0007\u0011\u001d\u00012\u0003\u0007\u0001\u000b\t!i\u0001#\u0004\u0005\u0003\na1!\u0007\u0002\u0006\u0003!!Qf\u0004\u0003b\ta%\u0011EB\u0003\u0002\u0011\u0019I1!\u0003\u0002\u0006\u0003!9Qk\u0001\u0003\u0006\u0007\u0011%\u0011\"\u0001E\b[=!\u0011\r\u0002M\bC\u0019)\u0011\u0001\u0003\u0004\n\u0007%\u0011Q!\u0001\u0005\b+\u000e!Qa\u0001C\b\u0013\u0005Ay!L\b\u0005C\u0012A\u0002\"\t\u0004\u0006\u0003!1\u0011bA\u0005\u0003\u000b\u0005Aq!V\u0002\u0005\u000b\r!\u0001\"C\u0001\t\u00105\u001aB\u0001\u0001M\t;\u001b!\u0001\u0001C\u0005\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\t#\u000e)A\u0011C\u0005\u0002\t\u0003i\u0011\u0001#\u0005.'\u0011\u0001\u0001DCO\u0007\t\u0001Aq!\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0002C)\u0004\u000b\u0011Q\u0011\"\u0001C\u0001\u001b\u0005A\t\"L\n\u0005\u0001aUQT\u0002\u0003\u0001\u0011\u001di!!B\u0001\t\u000fA\u001b\u0001!\t\u0002\u0006\u0003!A\u0011kA\u0003\u0005\u0016%\tA\u0011A\u0007\u0002\u0011#)T\"\u0002\u0007\u0005G\u0004AB!\t\u0002\u0006\u0003!\u0019\u0011kA\u0003\u0005\t%\tA\u0001A\u0007\u0002\u0011\u0013\u0001"})
    private final class ImportCache {
        public static final /* synthetic */ KClass $kotlinClass;
        private final HashSet<FqName> preciseImports = new HashSet();
        private final HashSet<FqName> preciseImportPackages = new HashSet();
        private final HashSet<FqName> allUnderImports = new HashSet();

        static {
            $kotlinClass = Reflection.createKotlinClass(ImportCache.class);
        }

        public final boolean isImportedWithPreciseImport(@JetValueParameter(name="name") @NotNull FqName name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return this.preciseImports.contains(name2);
        }

        public final boolean isImportedWithAllUnderImport(@JetValueParameter(name="name") @NotNull FqName name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            return this.allUnderImports.contains(name2.parent());
        }

        public final boolean hasPreciseImportFromPackage(@JetValueParameter(name="packageName") @NotNull FqName packageName) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            return this.preciseImportPackages.contains(packageName);
        }

        public ImportCache() {
            for (JetImportDirective jetImportDirective : JetDeclarationRemotenessWeigher.this.file.getImportDirectives()) {
                ImportPath importPath;
                if (jetImportDirective.getImportPath() == null) {
                    continue;
                }
                FqName fqName2 = importPath.fqnPart();
                if (importPath.isAllUnder()) {
                    this.allUnderImports.add(fqName2);
                    continue;
                }
                this.preciseImports.add(fqName2);
                this.preciseImportPackages.add(fqName2.parent());
            }
        }
    }
}

