/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.codeInsight;

import com.intellij.codeInsight.generation.ClassMemberWithElement;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.JetDescriptorIconProvider;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

public class DescriptorClassMember
extends MemberChooserObjectBase
implements ClassMemberWithElement {
    public static final String NO_PARENT_FOR = "No parent for ";
    @NotNull
    private final DeclarationDescriptor myDescriptor;
    @NotNull
    private final PsiElement myPsiElement;

    public DescriptorClassMember(@NotNull PsiElement element, @NotNull DeclarationDescriptor descriptor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/core/codeInsight/DescriptorClassMember", "<init>"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/core/codeInsight/DescriptorClassMember", "<init>"));
        }
        super(DescriptorRenderer.STARTS_FROM_NAME.render(descriptor2), DescriptorClassMember.getIcon(element, descriptor2));
        this.myPsiElement = element;
        this.myDescriptor = descriptor2;
    }

    private static Icon getIcon(PsiElement element, DeclarationDescriptor declarationDescriptor) {
        if (element.isValid()) {
            int flags;
            boolean isClass = element instanceof PsiClass || element instanceof JetClass;
            int n = flags = isClass ? 0 : 1;
            if (element instanceof JetDeclaration) {
                return JetDescriptorIconProvider.getIcon(declarationDescriptor, element, flags);
            }
            return element.getIcon(flags);
        }
        return JetDescriptorIconProvider.getIcon(declarationDescriptor, element, 0);
    }

    public MemberChooserObject getParentNodeDelegate() {
        DeclarationDescriptor parent = this.myDescriptor.getContainingDeclaration();
        Object declaration = this.myPsiElement instanceof JetDeclaration ? PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this.myPsiElement, JetNamedDeclaration.class) : ((PsiMember)this.myPsiElement).getContainingClass();
        assert (parent != null) : "No parent for " + this.myDescriptor;
        assert (declaration != null) : "No parent for " + this.myPsiElement;
        return new DescriptorClassMember((PsiElement)declaration, parent);
    }

    public DeclarationDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DescriptorClassMember that = (DescriptorClassMember)((Object)o);
        return this.myDescriptor.equals(that.myDescriptor);
    }

    public int hashCode() {
        return this.myDescriptor.hashCode();
    }

    public PsiElement getElement() {
        return this.myPsiElement;
    }
}

