/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$KotlinEvaluationBuilder$17256668;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135$WhenMappings;
import org.jetbrains.kotlin.idea.intentions.InsertExplicitTypeArguments;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionEnginePackage$extractableAnalysisUtil$afbf6fde;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionEnginePackage$extractorUtil$1a985e71;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.PatternMatchingPackage$JetPsiRange$c52eadd8;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetImportList;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilPackage;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135 {
    @Nullable
    public static final ExtractionResult getFunctionForExtractedFragment(@JetValueParameter(name="codeFragment") @NotNull JetCodeFragment codeFragment, @JetValueParameter(name="breakpointFile") @NotNull PsiFile breakpointFile, @JetValueParameter(name="breakpointLine") int breakpointLine) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)breakpointFile, (String)"breakpointFile");
        Function1<AnalysisResult, String> getErrorMessageForExtractFunctionResult$ = new Function1<AnalysisResult, String>(breakpointFile, breakpointLine, codeFragment){
            final /* synthetic */ PsiFile $breakpointFile;
            final /* synthetic */ int $breakpointLine;
            final /* synthetic */ JetCodeFragment $codeFragment;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@JetValueParameter(name="analysisResult") @NotNull AnalysisResult analysisResult) {
                AnalysisResult.ErrorMessage it;
                Collection destination;
                Iterable $receiver;
                Iterable $receiver2;
                List<String> list;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)analysisResult, (String)"analysisResult");
                if (KotlinInternalMode.Instance.getEnabled()) {
                    Collection<String> collection;
                    Iterable iterable = analysisResult.getMessages();
                    object = new StringBuilder().append("ERRORS:").append("\n");
                    list = new StringBuilder().append("Couldn't extract function for debugger:\n").append("FILE NAME: " + this.$breakpointFile.getName() + "\n").append("BREAKPOINT LINE: " + this.$breakpointLine + "\n").append("CODE FRAGMENT:" + "\n" + this.$codeFragment.getText() + "\n");
                    Logger logger = EvaluatePackage$KotlinEvaluationBuilder$17256668.getLogger();
                    Iterable iterable2 = $receiver2;
                    Collection collection2 = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                    for (T item : $receiver) {
                        AnalysisResult.ErrorMessage errorMessage = (AnalysisResult.ErrorMessage)((Object)item);
                        collection = destination;
                        String string = (Object)((Object)it) + ": " + it.renderMessage();
                        collection.add(string);
                    }
                    collection = (List)destination;
                    logger.error(((StringBuilder)((Object)list)).append(((StringBuilder)object).append(KotlinPackage.joinToString$default((Iterable)collection, (String)"\n", null, null, (int)0, null, null, (int)62)).append("\n").toString()).append("FILE TEXT: " + "\n" + this.$breakpointFile.getText() + "\n").toString());
                }
                $receiver2 = analysisResult.getMessages();
                $receiver = $receiver2;
                destination = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (T item : $receiver) {
                    Object object2;
                    block16: {
                        String message;
                        block15: {
                            void $receiver3;
                            String string;
                            void errorMessage;
                            it = (AnalysisResult.ErrorMessage)((Object)item);
                            object = destination;
                            switch (EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135$WhenMappings.$EnumSwitchMapping$0[errorMessage.ordinal()]) {
                                case 1: {
                                    string = "Cannot perform an action without an expression";
                                    break;
                                }
                                case 2: {
                                    string = "Cannot perform an action at this breakpoint " + this.$breakpointFile.getName() + ":" + this.$breakpointLine;
                                    break;
                                }
                                case 3: {
                                    string = "Cannot perform an action for expression with super call";
                                    break;
                                }
                                case 4: {
                                    string = "Cannot perform an action because following types are unavailable from debugger scope";
                                    break;
                                }
                                case 5: {
                                    string = "Cannot perform an action because this code fragment contains erroneous types";
                                    break;
                                }
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    string = "Cannot perform an action for this expression";
                                    break;
                                }
                                case 10: {
                                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected error: " + errorMessage)));
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            message = string;
                            object2 = errorMessage.getAdditionalInfo();
                            if (object2 == null) break block15;
                            List<String> list2 = object2;
                            List it2 = (List)$receiver3;
                            object2 = message + ": " + KotlinPackage.joinToString$default((Iterable)it2, (String)", ", null, null, (int)0, null, null, (int)62);
                            if (object2 != null) break block16;
                        }
                        object2 = message;
                    }
                    list = object2;
                    object.add(list);
                }
                return KotlinPackage.joinToString$default((Iterable)((List)destination), (String)", ", null, null, (int)0, null, null, (int)62);
            }
            {
                this.$breakpointFile = psiFile;
                this.$breakpointLine = n;
                this.$codeFragment = jetCodeFragment;
                super(1);
            }
        };
        Function0<ExtractionResult> generateFunction$ = new Function0<ExtractionResult>(breakpointFile, codeFragment, breakpointLine, getErrorMessageForExtractFunctionResult$){
            final /* synthetic */ PsiFile $breakpointFile;
            final /* synthetic */ JetCodeFragment $codeFragment;
            final /* synthetic */ int $breakpointLine;
            final /* synthetic */ getFunctionForExtractedFragment.1 $getErrorMessageForExtractFunctionResult;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ExtractionResult invoke() {
                ExtractableCodeDescriptorWithConflicts validationResult;
                void it;
                JetFile originalFile;
                PsiFile psiFile = this.$breakpointFile;
                if (psiFile == null) {
                    throw new TypeCastException("com.intellij.psi.PsiFile cannot be cast to org.jetbrains.kotlin.psi.JetFile");
                }
                JetFile $receiver = originalFile = (JetFile)psiFile;
                JetPsiFactory jetPsiFactory = PsiPackage.JetPsiFactory((PsiElement)$receiver);
                String string = $receiver.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getName()");
                String string2 = $receiver.getText();
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                CharSequence charSequence = string;
                Object object = jetPsiFactory;
                String string4 = it;
                JetFile tmpFile = ((JetPsiFactory)object).createAnalyzableFile((String)charSequence, string4, (PsiElement)$receiver);
                tmpFile.setOriginalFile((PsiFile)$receiver);
                CodeFragmentUtilPackage.setSuppressDiagnosticsInDebugMode(tmpFile, CodeFragmentUtilPackage.getSuppressDiagnosticsInDebugMode($receiver));
                JetFile tmpFile2 = tmpFile;
                CodeFragmentUtilPackage.setSuppressDiagnosticsInDebugMode(tmpFile2, true);
                PsiElement contextElement = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.getExpressionToAddDebugExpressionBefore(tmpFile2, this.$codeFragment.getContext(), this.$breakpointLine);
                if (contextElement == null) {
                    return null;
                }
                if (contextElement instanceof JetFile) {
                    Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)("Cannot perform an action at this breakpoint " + ((JetFile)this.$breakpointFile).getName() + ":" + this.$breakpointLine));
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026me()}:${breakpointLine}\")");
                    throw throwable;
                }
                EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.addImportsToFile(this.$codeFragment.importsAsImportList(), tmpFile2);
                JetExpression newDebugExpression = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.addDebugExpressionBeforeContextElement(this.$codeFragment, contextElement);
                if (newDebugExpression == null) {
                    return null;
                }
                JetDeclaration targetSibling = (JetDeclaration)KotlinPackage.firstOrNull(tmpFile2.getDeclarations());
                if (targetSibling == null) {
                    return null;
                }
                ExtractionOptions options = new ExtractionOptions(false, true, false, true, true, 4, null);
                AnalysisResult analysisResult = ExtractionEnginePackage$extractableAnalysisUtil$afbf6fde.performAnalysis(new ExtractionData(tmpFile2, PatternMatchingPackage$JetPsiRange$c52eadd8.toRange((PsiElement)newDebugExpression), targetSibling, null, options));
                if (Intrinsics.areEqual((Object)((Object)analysisResult.getStatus()), (Object)((Object)AnalysisResult.Status.SUCCESS)) ^ true) {
                    Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)this.$getErrorMessageForExtractFunctionResult.invoke(analysisResult));
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026onResult(analysisResult))");
                    throw throwable;
                }
                ExtractableCodeDescriptor extractableCodeDescriptor = analysisResult.getDescriptor();
                if (extractableCodeDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                if (!(validationResult = ExtractionEnginePackage$extractableAnalysisUtil$afbf6fde.validate(extractableCodeDescriptor)).getConflicts().isEmpty()) {
                    void destination;
                    void $receiver2;
                    void $receiver3;
                    Iterable iterable = validationResult.getConflicts().keySet();
                    charSequence = new StringBuilder().append("Following declarations are unavailable in debug scope: ");
                    void var10_14 = $receiver3;
                    Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
                    for (T item : $receiver2) {
                        void it2;
                        PsiElement psiElement = (PsiElement)item;
                        object = destination;
                        string4 = it2.getText();
                        object.add(string4);
                    }
                    object = (List)destination;
                    Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)((StringBuilder)charSequence).append(KotlinPackage.joinToString$default((Iterable)((Iterable)object), (String)",", null, null, (int)0, null, null, (int)62)).toString());
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026() }.joinToString(\",\")}\")");
                    throw throwable;
                }
                ExtractionGeneratorOptions generatorOptions = new ExtractionGeneratorOptions(true, null, true, true, false, 2, null);
                return ExtractionEnginePackage$extractorUtil$1a985e71.generateDeclaration$default(new ExtractionGeneratorConfiguration(validationResult.getDescriptor(), generatorOptions), null, 1);
            }
            {
                this.$breakpointFile = psiFile;
                this.$codeFragment = jetCodeFragment;
                this.$breakpointLine = n;
                this.$getErrorMessageForExtractFunctionResult = var4_4;
                super(0);
            }
        };
        return (ExtractionResult)ApplicationPackage.runReadAction((Function0)new Function0<ExtractionResult>(generateFunction$){
            final /* synthetic */ getFunctionForExtractedFragment.2 $generateFunction;

            @Nullable
            public final ExtractionResult invoke() {
                return this.$generateFunction.invoke();
            }
            {
                this.$generateFunction = var1_1;
                super(0);
            }
        });
    }

    public static final void addImportsToFile(@JetValueParameter(name="newImportList", type="?") @Nullable JetImportList newImportList, @JetValueParameter(name="tmpFile") @NotNull JetFile tmpFile) {
        Intrinsics.checkParameterIsNotNull((Object)tmpFile, (String)"tmpFile");
        if (newImportList != null) {
            JetImportList tmpFileImportList = tmpFile.getImportList();
            JetPackageDirective packageDirective = tmpFile.getPackageDirective();
            JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)tmpFile);
            if (tmpFileImportList == null) {
                tmpFile.addAfter(psiFactory.createNewLine(), packageDirective);
                tmpFile.addAfter((PsiElement)newImportList, tmpFile.getPackageDirective());
            } else {
                tmpFileImportList.replace((PsiElement)newImportList);
            }
            tmpFile.addAfter(psiFactory.createNewLine(), packageDirective);
        }
    }

    @Nullable
    public static final PsiElement getElementInCopy(@JetValueParameter(name="$receiver") JetFile $receiver, @JetValueParameter(name="e") @NotNull PsiElement e) {
        Integer offset;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        TextRange textRange = e.getTextRange();
        Integer n = offset = textRange != null ? Integer.valueOf(textRange.getStartOffset()) : null;
        if (offset == null) {
            return null;
        }
        PsiElement elementAt = $receiver.findElementAt(((Number)offset).intValue());
        while (true) {
            if (elementAt != null) {
                PsiElement psiElement = elementAt;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                TextRange textRange2 = psiElement.getTextRange();
                TextRange textRange3 = e.getTextRange();
                if (!(Intrinsics.areEqual((Object)(textRange2 != null ? Integer.valueOf(textRange2.getEndOffset()) : null), (Object)(textRange3 != null ? Integer.valueOf(textRange3.getEndOffset()) : null)) ^ true)) break;
            }
            PsiElement psiElement = elementAt;
            elementAt = psiElement != null ? psiElement.getParent() : null;
        }
        return elementAt;
    }

    @Nullable
    public static final PsiElement getExpressionToAddDebugExpressionBefore(@JetValueParameter(name="tmpFile") @NotNull JetFile tmpFile, @JetValueParameter(name="contextElement", type="?") @Nullable PsiElement contextElement, @JetValueParameter(name="line") int line) {
        PsiElement parentOfParent;
        PsiElement parent;
        PsiElement elementAt;
        Intrinsics.checkParameterIsNotNull((Object)tmpFile, (String)"tmpFile");
        if (contextElement == null) {
            Integer lineStart = CodeInsightUtils.getStartLineOffset((PsiFile)tmpFile, line);
            if (lineStart == null) {
                return null;
            }
            PsiElement elementAtOffset = tmpFile.findElementAt(((Number)lineStart).intValue());
            if (elementAtOffset == null) {
                return null;
            }
            PsiElement psiElement = CodeInsightUtils.getTopmostElementAtOffset(elementAtOffset, ((Number)lineStart).intValue());
            if (psiElement == null) {
                psiElement = elementAtOffset;
            }
            return psiElement;
        }
        getExpressionToAddDebugExpressionBefore.1 shouldStop$ = getExpressionToAddDebugExpressionBefore.1.INSTANCE$;
        PsiElement psiElement = elementAt = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.getElementInCopy(tmpFile, contextElement);
        Object object = parent = psiElement != null ? psiElement.getParent() : null;
        if (shouldStop$.invoke(elementAt, parent)) {
            return elementAt;
        }
        PsiElement psiElement2 = parent;
        Object object2 = parentOfParent = psiElement2 != null ? psiElement2.getParent() : null;
        while (parent != null && parentOfParent != null && !shouldStop$.invoke(parent, parentOfParent)) {
            PsiElement psiElement3 = parent;
            PsiElement psiElement4 = parent = psiElement3 != null ? psiElement3.getParent() : null;
            parentOfParent = psiElement4 != null ? psiElement4.getParent() : null;
        }
        return parent;
    }

    @Nullable
    public static final JetExpression addDebugExpressionBeforeContextElement(@JetValueParameter(name="codeFragment") @NotNull JetCodeFragment codeFragment, @JetValueParameter(name="contextElement") @NotNull PsiElement contextElement) {
        PsiElement parent;
        PsiElement elementBefore;
        JetBlockExpression block;
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)contextElement, (String)"contextElement");
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)codeFragment);
        Function1<JetClassBody, PsiElement> insertNewInitializer$ = new Function1<JetClassBody, PsiElement>(psiFactory){
            final /* synthetic */ JetPsiFactory $psiFactory;

            @Nullable
            public final PsiElement invoke(@JetValueParameter(name="classBody") @NotNull JetClassBody classBody) {
                JetBlockExpression block;
                Intrinsics.checkParameterIsNotNull((Object)classBody, (String)"classBody");
                JetClassInitializer initializer = this.$psiFactory.createAnonymousInitializer();
                PsiElement psiElement = classBody.addAfter(initializer, classBody.getFirstChild());
                if (psiElement == null) {
                    throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetClassInitializer");
                }
                JetClassInitializer newInitializer = (JetClassInitializer)psiElement;
                JetBlockExpression jetBlockExpression = block = (JetBlockExpression)newInitializer.getBody();
                return jetBlockExpression != null ? jetBlockExpression.getLastChild() : null;
            }
            {
                this.$psiFactory = jetPsiFactory;
                super(1);
            }
        };
        if (contextElement instanceof JetProperty && !((JetProperty)contextElement).isLocal()) {
            JetExpression delegateExpressionOrInitializer = ((JetProperty)contextElement).getDelegateExpressionOrInitializer();
            if (delegateExpressionOrInitializer != null) {
                psiElement = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.wrapInRunFun(delegateExpressionOrInitializer);
            } else {
                JetPropertyAccessor getter;
                JetPropertyAccessor jetPropertyAccessor = ((JetProperty)contextElement).getGetter();
                if (jetPropertyAccessor == null) {
                    Intrinsics.throwNpe();
                }
                if (!(getter = jetPropertyAccessor).hasBlockBody()) {
                    JetExpression jetExpression = getter.getBodyExpression();
                    if (jetExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.wrapInRunFun(jetExpression);
                } else {
                    JetExpression jetExpression = getter.getBodyExpression();
                    if (jetExpression == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression! cannot be cast to org.jetbrains.kotlin.psi.JetBlockExpression");
                    }
                    psiElement = (PsiElement)KotlinPackage.first(((JetBlockExpression)jetExpression).getStatements());
                }
            }
        } else if (contextElement instanceof JetClassOrObject) {
            JetClassBody jetClassBody = ((JetClassOrObject)contextElement).getBody();
            if (jetClassBody == null) {
                Intrinsics.throwNpe();
            }
            psiElement = insertNewInitializer$.invoke(jetClassBody);
        } else if (contextElement instanceof JetFunctionLiteral) {
            JetBlockExpression jetBlockExpression = ((JetFunctionLiteral)contextElement).getBodyExpression();
            if (jetBlockExpression == null) {
                Intrinsics.throwNpe();
            }
            block = jetBlockExpression;
            JetElement jetElement = (JetElement)KotlinPackage.firstOrNull(block.getStatements());
            psiElement = jetElement != null ? (PsiElement)jetElement : block.getLastChild();
        } else if (contextElement instanceof JetDeclarationWithBody && !((JetDeclarationWithBody)contextElement).hasBlockBody()) {
            JetExpression jetExpression = ((JetDeclarationWithBody)contextElement).getBodyExpression();
            if (jetExpression == null) {
                Intrinsics.throwNpe();
            }
            psiElement = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.wrapInRunFun(jetExpression);
        } else if (contextElement instanceof JetDeclarationWithBody && ((JetDeclarationWithBody)contextElement).hasBlockBody()) {
            JetExpression jetExpression = ((JetDeclarationWithBody)contextElement).getBodyExpression();
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression! cannot be cast to org.jetbrains.kotlin.psi.JetBlockExpression");
            }
            block = (JetBlockExpression)jetExpression;
            JetElement last = (JetElement)KotlinPackage.lastOrNull(block.getStatements());
            psiElement = last instanceof JetReturnExpression ? (PsiElement)last : block.getRBrace();
        } else if (contextElement instanceof JetWhenEntry) {
            JetExpression entryExpression = ((JetWhenEntry)contextElement).getExpression();
            if (entryExpression instanceof JetBlockExpression) {
                JetElement jetElement = (JetElement)KotlinPackage.firstOrNull(((JetBlockExpression)entryExpression).getStatements());
                psiElement = jetElement != null ? (PsiElement)jetElement : ((JetBlockExpression)entryExpression).getLastChild();
            } else {
                JetExpression jetExpression = entryExpression;
                if (jetExpression == null) {
                    Intrinsics.throwNpe();
                }
                psiElement = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.wrapInRunFun(jetExpression);
            }
        } else {
            psiElement = contextElement;
        }
        PsiElement psiElement2 = elementBefore = psiElement;
        Object object = parent = psiElement2 != null ? psiElement2.getParent() : null;
        if (parent == null || elementBefore == null) {
            return null;
        }
        parent.addBefore(psiFactory.createNewLine(), elementBefore);
        JetElement debugExpression = codeFragment.getContentElement();
        if (debugExpression == null) {
            return null;
        }
        PsiElement newDebugExpression = parent.addBefore((PsiElement)debugExpression, elementBefore);
        if (newDebugExpression == null) {
            return null;
        }
        parent.addBefore(psiFactory.createNewLine(), elementBefore);
        PsiElement psiElement3 = newDebugExpression;
        if (psiElement3 == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetExpression");
        }
        return (JetExpression)psiElement3;
    }

    @NotNull
    public static final JetCallExpression replaceByRunFunction(@JetValueParameter(name="expression") @NotNull JetExpression expression2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression jetExpression = PsiPackage.JetPsiFactory((PsiElement)expression2).createExpression("run { " + "\n" + expression2.getText() + " " + "\n" + "}");
        if (jetExpression == null) {
            throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression cannot be cast to org.jetbrains.kotlin.psi.JetCallExpression");
        }
        JetCallExpression callExpression = (JetCallExpression)jetExpression;
        PsiElement $receiver = (PsiElement)expression2;
        PsiElement result2 = $receiver.replace((PsiElement)callExpression);
        if (result2 instanceof JetCallExpression) {
            PsiElement psiElement = result2;
            object = psiElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"result");
        } else {
            PsiElement psiElement = result2;
            if (psiElement == null) {
                throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetParenthesizedExpression");
            }
            JetExpression jetExpression2 = ((JetParenthesizedExpression)psiElement).getExpression();
            if (jetExpression2 == null) {
                throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression! cannot be cast to T");
            }
            object = (JetCallExpression)jetExpression2;
        }
        JetCallExpression replaced = (JetCallExpression)object;
        JetTypeArgumentList typeArguments = InsertExplicitTypeArguments.Companion.createTypeArguments(replaced, ResolvePackage.analyze$default(replaced, null, 1));
        Object object2 = typeArguments;
        if (object2 != null && (object2 = ((JetTypeArgumentList)object2).getArguments()) != null ? KotlinPackage.isNotEmpty((Collection)((Collection)object2)) : false) {
            JetExpression calleeExpression = replaced.getCalleeExpression();
            JetTypeArgumentList jetTypeArgumentList = typeArguments;
            if (jetTypeArgumentList == null) {
                Intrinsics.throwNpe();
            }
            replaced.addAfter((PsiElement)jetTypeArgumentList, (PsiElement)calleeExpression);
        }
        return replaced;
    }

    @Nullable
    public static final PsiElement wrapInRunFun(@JetValueParameter(name="expression") @NotNull JetExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetCallExpression replacedBody = EvaluatePackage$extractFunctionForDebuggerUtil$0ddc2135.replaceByRunFunction(expression2);
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)expression2.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            throw new TypeCastException("com.intellij.psi.util.PsiModificationTracker! cannot be cast to com.intellij.psi.impl.PsiModificationTrackerImpl");
        }
        ((PsiModificationTrackerImpl)psiModificationTracker).incCounter();
        JetBlockExpression jetBlockExpression = ((JetFunctionLiteralArgument)KotlinPackage.first(replacedBody.getFunctionLiteralArguments())).getFunctionLiteral().getBodyExpression();
        return jetBlockExpression != null ? jetBlockExpression.getFirstChild() : null;
    }
}

