/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"&\n)\u0001C)\u001a7fO\u0006$X\r\u001a)s_B,'\u000f^=GS\u0016dG\rR3tGJL\u0007\u000f^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T\u0001\u0002Z3ck\u001e<WM\u001d\u0006\u0007e\u0016tG-\u001a:\u000b'\u0019KW\r\u001c3EKN\u001c'/\u001b9u_JLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\t)\u0018N\u0003\u0003j[Bd'\"B<bi\u000eD'B\u0002\u001fj]&$hHC\u0004qe>TWm\u0019;\u000b\u000fA\u0013xN[3di*9q\u000e]3oCBL'\"C8cU\u0016\u001cGOU3g\u0015=y%M[3diJ+g-\u001a:f]\u000e,'bA:v]*\u0019!\u000eZ5\u000b\u0011\u0011,G.Z4bi\u0016TQAR5fY\u0012TqC]3oI\u0016\u0014H)\u001a7fO\u0006$X\r\u001a)s_B,'\u000f^=\u000b\u000f\t{w\u000e\\3b]*Yq-\u001a;EK2,w-\u0019;f\u001519W\r^(cU\u0016\u001cGOU3g\u0015i9W\r\u001e*f]\u0012,'\u000fR3mK\u001e\fG/\u001a3Qe>\u0004XM\u001d;z\u0015%\u0019\u0017\r\\2WC2,XMC\tfm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRTQ#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u00136\u0004HN\u0003\u0004f]\u001eLg.\u001a\u0006\u000bKZ\fG.^1uS>t'\"\u0002,bYV,'\"D2bY\u000e4\u0016\r\\;f\u001d\u0006lWM\u0003\u0004TiJLgn\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'B\b4j]\u0012<U\r\u001e;fe\u001a{'\u000fR3mK\u001e\fG/\u001a3Qe>\u0004XM\u001d;z\u0015\u0019iU\r\u001e5pI*9r-\u001a;EKN\u001c'/\u001b9u_J,e/\u00197vCRLwN\u001c\u0006\bG>tG/\u001a=u\u0015=!UMY;hO\u0016\u00148i\u001c8uKb$(\"\u0004)tS\u0016C\bO]3tg&|gNC\u0002qg&TqaZ3u\u001d\u0006lWM%\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\b!%QA\u0001\u0003\u0005\u0011\u000b)!\u0001\"\u0003\t\u000b\u0015\u0011A!\u0002E\u0006\u000b\t!Y\u0001\u0003\u0004\u0006\u0007\u00111\u0001r\u0001\u0007\u0001\u000b\t!A\u0001\u0003\u0005\u0006\u0005\u00119\u0001bB\u0003\u0004\t\u001fAy\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u00012C\u0003\u0003\t#A!\"B\u0002\u0005\u0013!IA\u0002A\u0003\u0004\t%A1\u0002\u0004\u0001\u0006\u0003!\rQa\u0001C\u000b\u00111a\u0001!\u0002\u0002\u0005\u0010!=QA\u0001\u0003\n\u0011%)!\u0001B\u0005\t\u0017\u0015\u0011A\u0011\u0002E\u0010\u000b\t!Q\u0002\u0003\t\u0006\u0007\u0011m\u0001b\u0004\u0007\u0001\u000b\r!\u0011\u0002#\t\r\u0001\u0015\u0011A!\u0003E\u0011\u000b\t!Y\u0002C\b\u0006\u0007\u0011U\u00012\u0005\u0007\u0001\u000b\u0005A!#\u0002\u0002\u0005\"!\u0015RA\u0001\u0003\u0012\u0011G)1\u0001B\u0005\t(1\u0001QA\u0001\u0003\n\u0011O)1\u0001\"\u0003\t+1\u0001QA\u0001\u0003\u0005\u0011Y)1\u0001b\n\t,1\u0001QA\u0001C\u0014\u0011W)!\u0001\"\u0003\t+\u0011\u0001AbA\r\u0003\u000b\u0005Ai!L\b\u0005A\u0012A*\"\t\u0002\u0006\u0003!QQk\u0001\u0005\u0006\u0007\u0011U\u0011\"\u0001E\r\u001b\r!I\"C\u0001\t\u001a5zA\u0001\u0019\u0003\u0019\u0012\u0005\u0012Q!\u0001E\n+\u000eAQa\u0001C\t\u0013\u0005AA\"D\u0002\u0005\u001b%\t\u0001\u0002D\u0017\u0010\t\u0001$\u0001tC\u0011\u0003\u000b\u0005A1\"V\u0002\t\u000b\r!9\"C\u0001\u0005\u00025\u0019A1D\u0005\u0002\t\u0003iS\u0003B\u0006\u0019\u001du=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001\u0003\b\r\u0002A\u001b\u0001!I\u0002\u0006\u0003!uA\u0012A)\u0004\u000b\u0011q\u0011\"\u0001\u0005\u0010\u001b\u0005Ay\",\u0006\u0005\u0017a\t\u0012eA\u0003\u0002\u0011Aa\t!U\u0002\u0004\tEI\u0011\u0001c\t.\u0016\u0011\t\u0001dE\u0011\u0004\u000b\u0005A!\u0003$\u0001R\u0007\r!1#C\u0001\t&5*Ba\u0003\r\u0015;\u001f!\u0001\u0001#\u000b\u000e\u0007\u0015\t\u0001b\u0005G\u0001!\u000e\u0001\u0011eA\u0003\u0002\u0011Qa\t!U\u0002\u0006\tQI\u0011\u0001#\u000b\u000e\u0003!)R6\u0003\u0003\f1[\t#!B\u0001\t!E\u001b1\u0001\"\f\n\u0003!\rR'M\u00031\t\r\b\u0001TBO\u0007\t\u0001Aq!\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012C\u0007\u0003\u000b\u0005A\u0019\u0002UB\u0001;\u001b!\u0001\u0001#\u0006\u000e\u0005\u0015\t\u0001B\u0003)\u0004\u0003u5A\u0001\u0001E\f\u001b\t)\u0011\u0001C\u0006Q\u0007\u0007\t#!B\u0001\t\u0007E\u001b1\u0002\"\u0004\n\u0003\u0011\u0001Q\"\u0001E\f\u001b\u0005AA\"D\u0001\t\u001a5\tA\u0011\u0001"})
public final class DelegatedPropertyFieldDescriptor
extends FieldDescriptorImpl {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final ObjectReference objectRef;
    @NotNull
    private final Field delegate;
    private final boolean renderDelegatedProperty;

    static {
        $kotlinClass = Reflection.createKotlinClass(DelegatedPropertyFieldDescriptor.class);
    }

    @Nullable
    public Value calcValue(@JetValueParameter(name="evaluationContext", type="?") @Nullable EvaluationContextImpl evaluationContext) {
        ThreadReference threadReference;
        if (evaluationContext == null) {
            return null;
        }
        if (!this.renderDelegatedProperty) {
            return super.calcValue(evaluationContext);
        }
        Method method = this.findGetterForDelegatedProperty();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = evaluationContext.getSuspendContext().getThread();
        ThreadReference threadReference2 = threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
        if (method == null || threadReference == null) {
            return super.calcValue(evaluationContext);
        }
        try {
            return evaluationContext.getDebugProcess().invokeInstanceMethod((EvaluationContext)evaluationContext, this.getObject(), method, KotlinPackage.listOf(), evaluationContext.getSuspendContext().getSuspendPolicy());
        }
        catch (EvaluateException e) {
            return e.getExceptionFromTargetVM();
        }
    }

    @Nullable
    public String calcValueName() {
        StringBuilder receiver = new StringBuilder();
        StringBuilder $receiver = receiver;
        NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
        Object object = nodeRendererSettings != null ? nodeRendererSettings.getClassRenderer() : null;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        ClassRenderer classRenderer = object;
        $receiver.append(this.getName());
        if (classRenderer.SHOW_DECLARED_TYPE) {
            $receiver.append(": ");
            Mirror mirror = this.getValue();
            $receiver.append(classRenderer.renderTypeName(mirror != null && (mirror = mirror.type()) != null ? mirror.name() : null));
        }
        return $receiver.toString();
    }

    @NotNull
    public String getName() {
        return KotlinPackage.removeSuffix((String)this.delegate.name(), (String)JvmAbi.DELEGATED_PROPERTY_NAME_SUFFIX);
    }

    @Nullable
    public PsiExpression getDescriptorEvaluation(@JetValueParameter(name="context", type="?") @Nullable DebuggerContext context2) {
        return null;
    }

    private final Method findGetterForDelegatedProperty() {
        String fieldName = this.getName();
        if (!Name.isValidIdentifier(fieldName)) {
            return null;
        }
        String getterName = PropertyCodegen.getterName(Name.identifier(fieldName));
        List<Method> list = this.getObject().referenceType().methodsByName(getterName);
        return list != null ? (Method)KotlinPackage.firstOrNull(list) : null;
    }

    @NotNull
    public final ObjectReference getObjectRef() {
        return this.objectRef;
    }

    @NotNull
    public final Field getDelegate() {
        return this.delegate;
    }

    public final boolean getRenderDelegatedProperty() {
        return this.renderDelegatedProperty;
    }

    public DelegatedPropertyFieldDescriptor(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="objectRef") @NotNull ObjectReference objectRef, @JetValueParameter(name="delegate") @NotNull Field delegate2, @JetValueParameter(name="renderDelegatedProperty") boolean renderDelegatedProperty) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)objectRef, (String)"objectRef");
        Intrinsics.checkParameterIsNotNull((Object)delegate2, (String)"delegate");
        super(project, objectRef, delegate2);
        this.objectRef = objectRef;
        this.delegate = delegate2;
        this.renderDelegatedProperty = renderDelegatedProperty;
    }
}

