/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.handlers;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.findUsages.KotlinFindUsagesHandlerFactory;

public abstract class KotlinFindUsagesHandler<T extends PsiElement>
extends FindUsagesHandler {
    private final KotlinFindUsagesHandlerFactory factory;
    private final Collection<? extends PsiElement> elementsToSearch;

    public KotlinFindUsagesHandler(@NotNull T psiElement, @NotNull Collection<? extends PsiElement> elementsToSearch, @NotNull KotlinFindUsagesHandlerFactory factory2) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "<init>"));
        }
        if (elementsToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToSearch", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "<init>"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "<init>"));
        }
        super(psiElement);
        this.factory = factory2;
        this.elementsToSearch = elementsToSearch;
    }

    @NotNull
    public T getElement() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "getElement"));
        }
        return (T)psiElement;
    }

    public KotlinFindUsagesHandler(@NotNull T psiElement, @NotNull KotlinFindUsagesHandlerFactory factory2) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "<init>"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "<init>"));
        }
        this(psiElement, Collections.emptyList(), factory2);
    }

    @NotNull
    public final KotlinFindUsagesHandlerFactory getFactory() {
        KotlinFindUsagesHandlerFactory kotlinFindUsagesHandlerFactory = this.factory;
        if (kotlinFindUsagesHandlerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "getFactory"));
        }
        return kotlinFindUsagesHandlerFactory;
    }

    protected static boolean processUsage(Processor<UsageInfo> processor, PsiReference ref) {
        if (ref == null) {
            return true;
        }
        TextRange rangeInElement = ref.getRangeInElement();
        return processor.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
    }

    protected static boolean processUsage(@NotNull Processor<UsageInfo> processor, @NotNull PsiElement element) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "processUsage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "processUsage"));
        }
        return processor.process((Object)new UsageInfo(element));
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray;
        if (this.elementsToSearch.isEmpty()) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = this.getPsiElement();
        } else {
            psiElementArray = this.elementsToSearch.toArray(new PsiElement[this.elementsToSearch.size()]);
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    protected boolean searchTextOccurrences(final @NotNull PsiElement element, final @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        boolean searchText;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "searchTextOccurrences"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "searchTextOccurrences"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "searchTextOccurrences"));
        }
        final SearchScope scope2 = options.searchScope;
        boolean bl = searchText = options.isSearchForTextOccurrences && scope2 instanceof GlobalSearchScope;
        if (searchText) {
            if (options.fastTrack != null) {
                options.fastTrack.searchCustom((Processor)new Processor<Processor<PsiReference>>(){

                    public boolean process(Processor<PsiReference> consumer2) {
                        return KotlinFindUsagesHandler.this.processUsagesInText(element, processor, (GlobalSearchScope)scope2);
                    }
                });
            } else {
                return this.processUsagesInText(element, processor, (GlobalSearchScope)scope2);
            }
        }
        return true;
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/kotlin/idea/findUsages/handlers/KotlinFindUsagesHandler", "processElementUsages"));
        }
        return this.searchReferences(element, processor, options) && this.searchTextOccurrences(element, processor, options);
    }

    protected abstract boolean searchReferences(@NotNull PsiElement var1, @NotNull Processor<UsageInfo> var2, @NotNull FindUsagesOptions var3);
}

