/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

public abstract class CalleeReferenceVisitorBase
extends JetTreeVisitorVoid {
    private final BindingContext bindingContext;
    private final boolean deepTraversal;

    protected CalleeReferenceVisitorBase(BindingContext bindingContext2, boolean deepTraversal) {
        this.bindingContext = bindingContext2;
        this.deepTraversal = deepTraversal;
    }

    protected abstract void processDeclaration(JetReferenceExpression var1, PsiElement var2);

    @Override
    public void visitJetElement(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/CalleeReferenceVisitorBase", "visitJetElement"));
        }
        if (this.deepTraversal || !(element instanceof JetClassOrObject) && !(element instanceof JetNamedFunction)) {
            super.visitJetElement(element);
        }
    }

    @Override
    public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/hierarchy/calls/CalleeReferenceVisitorBase", "visitSimpleNameExpression"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (descriptor2 == null) {
            return;
        }
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declaration == null) {
            return;
        }
        if (CalleeReferenceVisitorBase.isProperty(descriptor2, declaration) || CalleeReferenceVisitorBase.isCallable(descriptor2, declaration, expression2)) {
            this.processDeclaration(expression2, declaration);
        }
    }

    private static boolean isCallable(DeclarationDescriptor descriptor2, PsiElement declaration, JetSimpleNameExpression reference) {
        JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)reference, JetCallElement.class);
        if (callElement2 == null || !PsiTreeUtil.isAncestor((PsiElement)callElement2.getCalleeExpression(), (PsiElement)reference, (boolean)false)) {
            return false;
        }
        return descriptor2 instanceof FunctionDescriptor && (declaration instanceof JetClassOrObject || declaration instanceof JetNamedFunction || declaration instanceof PsiMethod);
    }

    private static boolean isProperty(DeclarationDescriptor descriptor2, PsiElement declaration) {
        return descriptor2 instanceof PropertyDescriptor && declaration instanceof JetProperty;
    }
}

