/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.psi.JetExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;

class LabelsHighlightingVisitor
extends HighlightingVisitor {
    LabelsHighlightingVisitor(AnnotationHolder holder) {
        super(holder);
    }

    @Override
    public void visitExpressionWithLabel(@NotNull JetExpressionWithLabel expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/LabelsHighlightingVisitor", "visitExpressionWithLabel"));
        }
        JetSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            JetPsiChecker.highlightName(this.holder, (PsiElement)targetLabel, JetHighlightingColors.LABEL);
        }
    }
}

