/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.tasks.TasksPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    VariablesHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
        ValueParameterDescriptor parameterDescriptor;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitSimpleNameExpression"));
        }
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target == null) {
            return;
        }
        if (target instanceof ValueParameterDescriptor && Boolean.TRUE.equals(this.bindingContext.get(BindingContext.AUTO_CREATED_IT, parameterDescriptor = (ValueParameterDescriptor)target))) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Automatically declared based on the expected type").setTextAttributes(JetHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER);
        }
        this.highlightVariable((PsiElement)expression2, target);
        super.visitSimpleNameExpression(expression2);
    }

    @Override
    public void visitProperty(@NotNull JetProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitProperty"));
        }
        this.visitVariableDeclaration(property);
        super.visitProperty(property);
    }

    @Override
    public void visitParameter(@NotNull JetParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitParameter"));
        }
        this.visitVariableDeclaration(parameter);
        super.visitParameter(parameter);
    }

    @Override
    public void visitExpression(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitExpression"));
        }
        JetType smartCast = this.bindingContext.get(BindingContext.SMARTCAST, expression2);
        if (smartCast != null) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(smartCast)).setTextAttributes(JetHighlightingColors.SMART_CAST_VALUE);
        }
        super.visitExpression(expression2);
    }

    private void visitVariableDeclaration(JetNamedDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        PsiElement nameIdentifier = declaration.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private void highlightVariable(@NotNull PsiElement elementToHighlight, @NotNull DeclarationDescriptor descriptor2) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "highlightVariable"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "highlightVariable"));
        }
        if (descriptor2 instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            if (TasksPackage.isDynamic(variableDescriptor)) {
                JetPsiChecker.highlightName(this.holder, elementToHighlight, JetHighlightingColors.DYNAMIC_PROPERTY_CALL);
                return;
            }
            if (variableDescriptor.isVar()) {
                JetPsiChecker.highlightName(this.holder, elementToHighlight, JetHighlightingColors.MUTABLE_VARIABLE);
            }
            if (this.bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) == CaptureKind.NOT_INLINE) {
                String msg = ((VariableDescriptor)descriptor2).isVar() ? "Wrapped into a reference object to be modified when captured in a closure" : "Value captured in a closure";
                this.holder.createInfoAnnotation(elementToHighlight, msg).setTextAttributes(JetHighlightingColors.WRAPPED_INTO_REF);
            }
            if (descriptor2 instanceof LocalVariableDescriptor) {
                JetPsiChecker.highlightName(this.holder, elementToHighlight, JetHighlightingColors.LOCAL_VARIABLE);
            }
            if (descriptor2 instanceof ValueParameterDescriptor) {
                JetPsiChecker.highlightName(this.holder, elementToHighlight, JetHighlightingColors.PARAMETER);
            }
        }
    }
}

