/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"H\u0006)\u00013i\u001c8wKJ$Hk\\*ue&tw\rV3na2\fG/Z%oi\u0016tG/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!\"\u001b8uK:$\u0018n\u001c8t\u0015)RU\r^*fY\u001a$\u0016M]4fi&twm\u00144gg\u0016$\u0018J\u001c3fa\u0016tG-\u001a8u\u0013:$XM\u001c;j_:T1CS3u\u0005&t\u0017M]=FqB\u0014Xm]:j_:T1\u0001]:j\u0015\u0019a\u0014N\\5u})9\u0011\r\u001d9msR{'bB3mK6,g\u000e\u001e\u0006\u0007K\u0012LGo\u001c:\u000b\r\u0015#\u0017\u000e^8s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'\u0002B+oSRT\u0011BY;jY\u0012$V\r\u001f;\u000b\t\u0015D\bO\u001d\u0006\u000e\u0015\u0016$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u00179,W\rZ:Ce\u0006\u001cWm\u001d\u0006\b\u0005>|G.Z1o\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\t\u0019|G\u000e\u001a\u0006\u0005Y\u00164GOC\u0003sS\u001eDGO\u0003\bjg\u0006\u0003\b\u000f\\5dC\ndW\rV8\u001f\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Qa\u0001\u0003\u0003\u0011\ra\u0001!\u0002\u0002\u0005\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0001\t\u000f\u0015\u0011A\u0011\u0002E\b\u000b\t!Q\u0001\u0003\u0005\u0006\u0005\u0011-\u0001BB\u0003\u0004\t\u0019Ai\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\b\u0011#a\u0001!\u0002\u0002\u0005\b!\u001dQA\u0001\u0003\u0007\u0011\u001b)1\u0001b\u0002\t\u00151\u0001Qa\u0001\u0003\b\u0011-a\u0001!B\u0002\u0005\u000f!]A\u0002A\u0003\u0002\u00111)!\u0001\"\u0006\t\u001a\u0015\u0011Aa\u0003E\f\u000b\t!9\u0001\u0003\u0006\u0005\u00071\u0015\u0011DB\u0003\u0002\u0011\rI1!\u0003\u0002\u0006\u0003!!Q\u0016\b\u0003\f1\u0015ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u000eA\u001b\t!\t\u0002\u0006\u0003!=\u0011kA\u0004\u0005\u000b%\tA\u0001A\u0007\u0002\u0011!i\u0011\u0001#\u0005.<\u0011\t\u0001$CO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!IA\u0012\u0001)\u0004\u0001u5A\u0001\u0001E\u000b\u001b\t)\u0011\u0001c\u0005Q\u0007\u0003\t#!B\u0001\t\u0015E\u001bq\u0001B\u0005\n\u0003!]Q\"\u0001\u0005\r\u001b\u0005!\t!l\u000f\u0005\u0003aiQt\u0002\u0003\u0001\u00117i1!B\u0001\t\u00131\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BD\u0007\u0003\u000b\u0005A!\u0002UB\u0001C\t)\u0011\u0001\u0003\u0006R\u0007\u001d!Q\"C\u0001\t\u00185\t\u0001\u0002D\u0007\u0002\u0011/i3\u0003B\u0006\u0019\u001eu5A\u0001\u0001E\u0006\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001\t#!B\u0001\t\u0014E\u001bQ\u0001\"\b\n\u0003\u0011\u0005Q\"\u0001\u0005\tk-)!\u0002Br\u00011\u0013\t#!B\u0001\t\u0006E\u001b1\u0001\"\u0003\n\u0003\u0011\u0001\u0001"})
public final class ConvertToStringTemplateIntention
extends JetSelfTargetingOffsetIndependentIntention<JetBinaryExpression> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConvertToStringTemplateIntention.class);
    }

    @Override
    public boolean isApplicableTo(@JetValueParameter(name="element") @NotNull JetBinaryExpression element) {
        JetType elementType;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getOperationToken(), (Object)((Object)JetTokens.PLUS)) ^ true) {
            return false;
        }
        JetTypeInfo jetTypeInfo = BindingContextUtils.getRecordedTypeInfo(element, ResolvePackage.analyze$default(element, null, 1));
        JetType jetType = elementType = jetTypeInfo != null ? jetTypeInfo.getType() : null;
        if (!KotlinBuiltIns.isString(elementType)) {
            return false;
        }
        JetExpression jetExpression = element.getLeft();
        if (jetExpression == null) {
            return false;
        }
        JetExpression left = jetExpression;
        JetExpression jetExpression2 = element.getRight();
        if (jetExpression2 == null) {
            return false;
        }
        JetExpression right = jetExpression2;
        return !PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)left)) && !PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)right));
    }

    @Override
    public void applyTo(@JetValueParameter(name="element") @NotNull JetBinaryExpression element, @JetValueParameter(name="editor") @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        PsiElement parent = element.getParent();
        if (parent instanceof JetBinaryExpression) {
            JetBinaryExpression jetBinaryExpression = (JetBinaryExpression)parent;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetBinaryExpression, (String)"parent");
            if (this.isApplicableTo(jetBinaryExpression)) {
                JetBinaryExpression jetBinaryExpression2 = (JetBinaryExpression)parent;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetBinaryExpression2, (String)"parent");
                this.applyTo(jetBinaryExpression2, editor);
                return;
            }
        }
        String rightText = this.buildText(element.getRight(), false);
        String text = this.fold(element.getLeft(), rightText);
        element.replace((PsiElement)PsiPackage.JetPsiFactory((PsiElement)element).createExpression(text));
    }

    private final String fold(@JetValueParameter(name="left", type="?") JetExpression left, @JetValueParameter(name="right") String right) {
        boolean needsBraces;
        boolean bl = needsBraces = !KotlinPackage.isEmpty((String)right) && KotlinPackage.first((String)right) != '$' && KotlinPackage.isJavaIdentifierPart((char)KotlinPackage.first((String)right));
        if (left instanceof JetBinaryExpression && this.isApplicableTo((JetBinaryExpression)left)) {
            String leftRight = this.buildText(((JetBinaryExpression)left).getRight(), needsBraces);
            return this.fold(((JetBinaryExpression)left).getLeft(), leftRight + right);
        }
        String leftText = this.buildText(left, needsBraces);
        return "\"" + leftText + right + "\"";
    }

    private final String buildText(@JetValueParameter(name="expr", type="?") JetExpression expr, @JetValueParameter(name="needsBraces") boolean needsBraces) {
        String string;
        JetExpression expression2 = JetPsiUtil.deparenthesize(expr);
        Object object = expression2;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object expressionText2 = object;
        JetExpression jetExpression = expression2;
        if (jetExpression instanceof JetConstantExpression) {
            BindingContext context2 = ResolvePackage.analyze$default(expression2, null, 1);
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.Companion.evaluate(expression2, new DelegatingBindingTrace(context2, "Trace for evaluating constant"), null);
            if (constant instanceof IntegerValueTypeConstant) {
                JetTypeInfo jetTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context2);
                JetType jetType = jetTypeInfo != null ? jetTypeInfo.getType() : null;
                if (jetType == null) {
                    Intrinsics.throwNpe();
                }
                JetType elementType = jetType;
                string = ((IntegerValueTypeConstant)constant).getValue(elementType).toString();
            } else {
                CompileTimeConstant<?> compileTimeConstant = constant;
                string = String.valueOf(compileTimeConstant != null ? compileTimeConstant.getValue() : null);
            }
        } else if (jetExpression instanceof JetStringTemplateExpression) {
            String base;
            String string2;
            if (KotlinPackage.startsWith$default((String)expressionText2, (String)"\"\"\"", (boolean)false, (int)2) && KotlinPackage.endsWith$default((String)expressionText2, (String)"\"\"\"", (boolean)false, (int)2)) {
                String unquoted = KotlinPackage.substring((String)expressionText2, (int)3, (int)(((String)expressionText2).length() - 3));
                string2 = StringUtil.escapeStringCharacters((String)unquoted);
            } else {
                string2 = base = StringUtil.unquoteString((String)expressionText2);
            }
            string = needsBraces && KotlinPackage.endsWith$default((String)base, (char)'$', (boolean)false, (int)2) ? KotlinPackage.substring((String)base, (int)0, (int)(base.length() - 1)) + "\\$" : base;
        } else {
            string = jetExpression instanceof JetSimpleNameExpression ? (needsBraces ? "${" + (String)expressionText2 + "}" : "$" + (String)expressionText2) : (Intrinsics.areEqual((Object)jetExpression, null) ? "" : "${" + KotlinPackage.replace((String)expressionText2, (Regex)KotlinPackage.toRegex((String)"\n+"), (String)" ") + "}");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (expression) {\n    \u2026x(), \" \") + \"}\"\n        }");
        return string;
    }

    public ConvertToStringTemplateIntention() {
        super(JetBinaryExpression.class, "Convert concatenation to template", null, false, 12, null);
    }
}

